/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.TableRow;

public abstract class RowBandAdapter {
    protected abstract ReportItemHandle getElementHandle();

    protected Module getModule() {
        return this.getElementHandle().getModule();
    }

    protected abstract int getColumnCount();

    protected abstract int getRowCount();

    protected int computeRowCount(TableRow row) {
        List contents = row.getContentsSlot();
        Iterator cellIter = contents.iterator();
        int count = 0;
        while (cellIter.hasNext()) {
            Cell cell = (Cell)cellIter.next();
            int columnSpan = cell.getColSpan(null);
            count += columnSpan;
        }
        return count;
    }

    protected int computeRowCount(RowHandle rowHandle) {
        TableRow row = (TableRow)rowHandle.getElement();
        return this.computeRowCount(row);
    }

    protected boolean hasParent() {
        return this.getElementHandle().getElement().isVirtualElement() || this.getElementHandle().getExtends() != null;
    }
}

