/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.command;

import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.i18n.ModelMessages;

public class PropertyNameException
extends SemanticException {
    private static final long serialVersionUID = 8269697054523876373L;
    protected String name;
    protected IStructure struct;
    public static final String DESIGN_EXCEPTION_PROPERTY_NAME_INVALID = "Error.PropertyNameException.PROPERTY_NOT_VALID";
    public static final String DESIGN_EXCEPTION_MEMBER_NAME_INVALID = "Error.PropertyNameException.MEMBER_NOT_VALID";

    public PropertyNameException(DesignElement obj, String propName) {
        super(obj, DESIGN_EXCEPTION_PROPERTY_NAME_INVALID);
        this.name = propName;
    }

    public PropertyNameException(DesignElement obj, IStructure struct, String memberName) {
        super(obj, DESIGN_EXCEPTION_MEMBER_NAME_INVALID);
        this.name = memberName;
        this.struct = struct;
    }

    public String getPropertyName() {
        return this.name;
    }

    public String getMemberName() {
        return this.name;
    }

    public String getLocalizedMessage() {
        String errorCode = this.getErrorCode();
        if (errorCode == DESIGN_EXCEPTION_PROPERTY_NAME_INVALID) {
            String elementName = this.element == null ? "" : this.element.getFullName();
            return ModelMessages.getMessage(DESIGN_EXCEPTION_PROPERTY_NAME_INVALID, new String[]{this.name, elementName});
        }
        if (errorCode == DESIGN_EXCEPTION_MEMBER_NAME_INVALID) {
            String structName = this.struct == null ? "" : this.struct.getStructName();
            return ModelMessages.getMessage(DESIGN_EXCEPTION_MEMBER_NAME_INVALID, new String[]{this.name, structName});
        }
        return "";
    }
}

