/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.simpleapi;

import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.PropertyNameException;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.api.simpleapi.IAction;

public class ActionImpl
implements IAction {
    private ActionHandle action;
    private ReportItemHandle handle;

    public ActionImpl(ActionHandle action, ReportItemHandle handle) {
        this.action = action;
        this.handle = handle;
    }

    public String getURI() {
        return this.action.getURI();
    }

    public String getTargetWindow() {
        return this.action.getTargetWindow();
    }

    public String getLinkType() {
        return this.action.getLinkType();
    }

    public void setLinkType(String type) throws SemanticException {
        this.checkAction();
        this.action.setLinkType(type);
    }

    public void setFormatType(String type) throws SemanticException {
        this.checkAction();
        this.action.setFormatType(type);
    }

    public String getFormatType() {
        return this.action.getFormatType();
    }

    public void setTargetWindow(String window) throws SemanticException {
        this.checkAction();
        this.action.setTargetWindow(window);
    }

    public void setURI(String uri) throws SemanticException {
        this.checkAction();
        this.action.setURI(uri);
    }

    public String getReportName() {
        return this.action.getReportName();
    }

    public void setReportName(String reportName) throws SemanticException {
        this.checkAction();
        this.action.setReportName(reportName);
    }

    public String getTargetBookmark() {
        return this.action.getTargetBookmark();
    }

    public void setTargetBookmark(String bookmark) throws SemanticException {
        this.checkAction();
        this.action.setTargetBookmark(bookmark);
    }

    private void checkAction() throws SemanticException {
        if (this.action != null) {
            return;
        }
        Action a = new Action();
        if (this.handle instanceof LabelHandle) {
            ((LabelHandle)this.handle).setAction(a);
            this.action = ((LabelHandle)this.handle).getActionHandle();
        } else if (this.handle instanceof ImageHandle) {
            ((ImageHandle)this.handle).setAction(a);
            this.action = ((ImageHandle)this.handle).getActionHandle();
        } else if (this.handle instanceof DataItemHandle) {
            ((DataItemHandle)this.handle).setAction(a);
            this.action = ((DataItemHandle)this.handle).getActionHandle();
        } else {
            throw new PropertyNameException(this.handle == null ? null : this.handle.getElement(), "action");
        }
    }
}

