/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.ArrayList;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.elements.ICssStyleSheetOperation;
import org.eclipse.birt.report.model.elements.OdaDataSource;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.ScalarParameter;
import org.eclipse.birt.report.model.elements.ScriptDataSet;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.parser.AbstractPropertyState;
import org.eclipse.birt.report.model.parser.CompatibleBoundColumnState;
import org.eclipse.birt.report.model.parser.CompatibleGroupBoundColumnsState;
import org.eclipse.birt.report.model.parser.CompatibleOdaDriverPropertyStructureListState;
import org.eclipse.birt.report.model.parser.CompatibleRenameListPropertyState;
import org.eclipse.birt.report.model.parser.DesignParserException;
import org.eclipse.birt.report.model.parser.ExtendedPropertyState;
import org.eclipse.birt.report.model.parser.IncludedCssStyleSheetListState;
import org.eclipse.birt.report.model.parser.IncludedLibrariesStructureListState;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.RecoverableError;
import org.eclipse.birt.report.model.parser.SimpleStructureListState;
import org.eclipse.birt.report.model.parser.StructureState;
import org.eclipse.birt.report.model.parser.UserPropertyListState;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ListPropertyState
extends AbstractPropertyState {
    private static final int USER_PROPERTIES_PROP = "userProperties".toLowerCase().hashCode();
    private static final int INCLUDE_SCRIPTS_PROP = "includeScripts".toLowerCase().hashCode();
    private static final int LIBRARIES_PROP = "libraries".toLowerCase().hashCode();
    private static final int INCLUDE_LIBRARIES_PROP = "includeLibraries".toLowerCase().hashCode();
    private static final int BOUND_DATA_COLUMNS_PROP = "boundDataColumns".toLowerCase().hashCode();
    private static final int PARAM_BOUND_DATA_COLUMNS_PROP = "boundDataColumns".toLowerCase().hashCode();
    private static final int PRIVATE_DRIVER_PROPERTIES_PROP = "privateDriverProperties".toLowerCase().hashCode();
    private static final int PUBLIC_DRIVER_PROPERTIES_PROP = "publicDriverProperties".toLowerCase().hashCode();
    private static final int RESULT_SET_PROP = "resultSet".toLowerCase().hashCode();
    ArrayList list = new ArrayList();
    PropertyDefn propDefn = null;

    ListPropertyState(ModuleParserHandler theHandler, DesignElement element) {
        super(theHandler, element);
    }

    ListPropertyState(ModuleParserHandler theHandler, DesignElement element, PropertyDefn propDefn, IStructure struct) {
        super(theHandler, element);
        this.propDefn = propDefn;
        this.struct = struct;
    }

    protected void setName(String name) {
        super.setName(name);
        this.propDefn = this.struct != null ? (PropertyDefn)this.struct.getDefn().getMember(name) : this.element.getPropertyDefn(name);
    }

    public void parseAttrs(Attributes attrs) throws XMLParserException {
        super.parseAttrs(attrs);
        if (StringUtil.isBlank(this.name)) {
            return;
        }
        if (this.struct instanceof Action) {
            if ("drillThroughParamBindings".equals(this.name)) {
                this.name = "paramBindings";
            } else if ("drillThroughSearch".equals(this.name)) {
                this.name = "search";
            }
        }
        this.propDefn = this.struct != null ? (PropertyDefn)this.struct.getDefn().getMember(this.name) : this.element.getPropertyDefn(this.name);
        if (!"userProperties".equals(this.name)) {
            if (this.propDefn == null) {
                if ("publicDriverProperties".equals(this.name)) {
                    return;
                }
                if (this.element instanceof Module && "includeLibraries".equalsIgnoreCase(this.name)) {
                    return;
                }
                if (this.element instanceof ScriptDataSet && "resultSet".equalsIgnoreCase(this.name)) {
                    return;
                }
                if (this.handler.versionNumber > 3000000 && this.handler.versionNumber <= 3020100 && "boundDataColumns".equals(this.name) && this.element instanceof GroupElement) {
                    return;
                }
                DesignParserException e = new DesignParserException(new String[]{this.name}, "Error.DesignParserException.UNDEFINED_PROPERTY");
                RecoverableError.dealUndefinedProperty(this.handler, e);
                this.valid = false;
            } else if (16 != this.propDefn.getTypeCode()) {
                DesignParserException e = new DesignParserException("Error.DesignParserException.WRONG_STRUCTURE_LIST_TYPE");
                this.handler.getErrorHandler().semanticError((Exception)((Object)e));
                this.valid = false;
            }
        }
    }

    public AbstractParseState startElement(String tagName) {
        if (tagName.equalsIgnoreCase("structure")) {
            return new StructureState(this.handler, this.element, this.propDefn, this.list);
        }
        if (tagName.equalsIgnoreCase("ex-property")) {
            return new ExtendedPropertyState(this.handler, this.element, this.propDefn, this.list);
        }
        return super.startElement(tagName);
    }

    public void end() throws SAXException {
        if (this.struct != null) {
            PropertyDefn memberDefn = (PropertyDefn)this.struct.getDefn().getMember(this.name);
            this.struct.setProperty(memberDefn, this.list);
        } else {
            this.element.setProperty(this.name, (Object)this.list);
        }
    }

    protected AbstractParseState generalJumpTo() {
        if (USER_PROPERTIES_PROP == this.nameValue) {
            UserPropertyListState state = new UserPropertyListState(this.handler, this.element);
            ((AbstractPropertyState)state).setName(this.name);
            return state;
        }
        if (this.element instanceof Module) {
            if (INCLUDE_SCRIPTS_PROP == this.nameValue) {
                SimpleStructureListState state = new SimpleStructureListState(this.handler, this.element);
                state.setName(this.name);
                state.setMemberName("fileName");
                return state;
            }
            if (LIBRARIES_PROP == this.nameValue || INCLUDE_LIBRARIES_PROP == this.nameValue) {
                IncludedLibrariesStructureListState state = new IncludedLibrariesStructureListState(this.handler, this.element);
                ((AbstractPropertyState)state).setName("libraries");
                return state;
            }
        }
        if (PARAM_BOUND_DATA_COLUMNS_PROP == this.nameValue && this.element instanceof ScalarParameter) {
            CompatibleBoundColumnState state = new CompatibleBoundColumnState(this.handler, this.element);
            state.setName(this.name);
            return state;
        }
        if (BOUND_DATA_COLUMNS_PROP == this.nameValue && this.element instanceof ReportItem) {
            CompatibleBoundColumnState state = new CompatibleBoundColumnState(this.handler, this.element);
            state.setName(this.name);
            return state;
        }
        if (this.element instanceof ICssStyleSheetOperation && ("cssStyleSheets".equalsIgnoreCase(this.name) || "cssStyleSheets".equalsIgnoreCase(this.name))) {
            IncludedCssStyleSheetListState state = new IncludedCssStyleSheetListState(this.handler, this.element);
            ((AbstractPropertyState)state).setName("cssStyleSheets");
            return state;
        }
        return super.generalJumpTo();
    }

    protected AbstractParseState versionConditionalJumpTo() {
        if (this.element instanceof OdaDataSource) {
            if ((PRIVATE_DRIVER_PROPERTIES_PROP == this.nameValue || PUBLIC_DRIVER_PROPERTIES_PROP == this.nameValue) && this.handler.isVersion(0)) {
                CompatibleOdaDriverPropertyStructureListState state = new CompatibleOdaDriverPropertyStructureListState(this.handler, this.element);
                state.setName(this.name);
                return state;
            }
        } else if (this.handler.versionNumber < 3020000 && BOUND_DATA_COLUMNS_PROP == this.nameValue && this.element instanceof ReportItem) {
            CompatibleBoundColumnState state = new CompatibleBoundColumnState(this.handler, this.element);
            state.setName(this.name);
            return state;
        }
        if (this.handler.versionNumber > 3000000 && this.handler.versionNumber <= 3020100 && "boundDataColumns".equals(this.name) && this.element instanceof GroupElement) {
            CompatibleGroupBoundColumnsState state = new CompatibleGroupBoundColumnsState(this.handler, this.element.getContainer(), (GroupElement)this.element);
            state.setName(this.name);
            return state;
        }
        if (this.handler.versionNumber < 3020400 && this.element instanceof ScriptDataSet && RESULT_SET_PROP == this.nameValue) {
            CompatibleRenameListPropertyState state = new CompatibleRenameListPropertyState(this.handler, this.element, this.name);
            state.setName("resultSetHints");
            return state;
        }
        return super.versionConditionalJumpTo();
    }
}

