/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.DesignSession;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.namespace.ModuleNameHelper;
import org.eclipse.birt.report.model.core.namespace.NameExecutor;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.NamePropertyType;
import org.eclipse.birt.report.model.parser.ModuleParserErrorHandler;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.eclipse.birt.report.model.util.XMLParserHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public abstract class ModuleParserHandler
extends XMLParserHandler {
    protected DesignSession session = null;
    protected Module module = null;
    protected String fileName = null;
    int versionNumber = 0;
    boolean isCurrentVersion = false;
    protected boolean markLineNumber = true;
    protected HashMap tempLineNumbers = null;
    protected HashMap tempValue = new HashMap();
    protected List unhandleIDElements = new ArrayList();
    private List unnamedReportItems = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.parser.ModuleParserHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    protected ModuleParserHandler(DesignSession theSession, String fileName) {
        super(new ModuleParserErrorHandler());
        this.session = theSession;
        this.fileName = fileName;
    }

    String getFileName() {
        return this.fileName;
    }

    public boolean isVersion(int toCompare) {
        return this.versionNumber == toCompare;
    }

    public Module getModule() {
        return this.module;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.errorHandler.setCurrentElement(qName);
        AbstractParseState newState = this.topState.startElement(qName);
        newState.parseAttrs(atts);
        AbstractParseState jumpToState = newState.jumpTo();
        if (jumpToState != null) {
            this.pushState(jumpToState);
            return;
        }
        newState.setElementName(qName);
        this.pushState(newState);
    }

    public void endDocument() throws SAXException {
        ModuleOption options;
        super.endDocument();
        this.tempValue = null;
        if (this.versionNumber < 3021300) {
            List handledExceptions = this.handleInvalidName(this.getErrorHandler().getErrors());
            this.getErrorHandler().getErrors().removeAll(handledExceptions);
        }
        this.module.getAllExceptions().addAll(this.getErrorHandler().getErrors());
        List libraries = this.module.getAllLibraries();
        Iterator<Object> iter = libraries.iterator();
        while (iter.hasNext()) {
            Exception fatalException;
            Library library = (Library)iter.next();
            if (library.isValid() || (fatalException = ModelUtil.getFirstFatalException(library.getAllExceptions())) == null) continue;
            XMLParserException exception = this.errorHandler.semanticError(fatalException);
            this.module.getAllExceptions().add(exception);
        }
        if (!this.module.getAllErrors().isEmpty() || this.module.getFatalException() != null) {
            this.module.setValid(false);
            ArrayList allExceptions = new ArrayList();
            allExceptions.addAll(this.module.getAllExceptions());
            allExceptions.addAll(this.errorHandler.getWarnings());
            DesignFileException exception = new DesignFileException(this.module.getFileName(), allExceptions);
            throw new SAXException((Exception)((Object)exception));
        }
        if (!this.unhandleIDElements.isEmpty()) {
            this.handleID();
            this.unhandleIDElements = null;
        }
        if (!this.unnamedReportItems.isEmpty() && this.versionNumber <= 3021200) {
            this.handleUnnamedReportItems();
        }
        if (this.versionNumber <= 3021300 && StringUtil.isBlank(this.module.getNamespace())) {
            ((ModuleNameHelper)this.module.getNameHelper()).clearCachedLevels();
        }
        if (this.markLineNumber && this.tempLineNumbers != null) {
            iter = this.tempLineNumbers.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                this.module.addLineNo(entry.getKey(), (Integer)entry.getValue());
            }
            this.tempLineNumbers = null;
        }
        if ((options = this.module.getOptions()) == null || options.useSemanticCheck()) {
            this.module.semanticCheck(this.module);
        }
        if (this.errorHandler.getWarnings() != null) {
            this.module.getAllExceptions().addAll(this.errorHandler.getWarnings());
        }
    }

    public void setVersionNumber(int versionNumber) {
        this.versionNumber = versionNumber;
    }

    private void handleID() {
        int i = 0;
        while (i < this.unhandleIDElements.size()) {
            DesignElement element = (DesignElement)this.unhandleIDElements.get(i);
            if (element.getExtendsElement() == null) {
                if (element.getRoot() == this.module) {
                    if (!$assertionsDisabled && element.getID() != 0L) {
                        throw new AssertionError();
                    }
                    element.setID(this.module.getNextID());
                    this.module.addElementID(element);
                }
            } else {
                this.module.manageId(element, true);
            }
            ++i;
        }
    }

    private void handleUnnamedReportItems() {
        int i = 0;
        while (i < this.unnamedReportItems.size()) {
            DesignElement element = (DesignElement)this.unnamedReportItems.get(i);
            ModelUtil.addElement2NameSpace(this.module, element);
            ++i;
        }
    }

    private List handleInvalidName(List exceptions) {
        ArrayList<Exception> handledExceptions = new ArrayList<Exception>();
        ArrayList<DesignElement> processElements = new ArrayList<DesignElement>();
        int i = 0;
        while (i < exceptions.size()) {
            Exception exception;
            Exception tmpObj = (Exception)exceptions.get(i);
            if (tmpObj instanceof XMLParserException && (exception = ((XMLParserException)tmpObj).getException()) instanceof NameException) {
                NameException nameException = (NameException)((Object)exception);
                DesignElement tmpElement = nameException.getElement();
                if (tmpElement.getName() != null && nameException.getErrorCode() == "Error.NameException.INVALID_NAME") {
                    String newName;
                    String oldName = nameException.getName();
                    if (!oldName.equals(newName = NamePropertyType.validateName(oldName))) {
                        tmpElement.setName(newName);
                        int ns = ((ElementDefn)tmpElement.getDefn()).getNameSpaceID();
                        if (ns != -1) {
                            new NameExecutor(tmpElement).getNameSpace(this.module).rename(tmpElement, oldName, newName);
                        }
                        processElements.add(tmpElement);
                        handledExceptions.add(tmpObj);
                    }
                } else if (processElements.contains(tmpElement)) {
                    handledExceptions.add(tmpObj);
                }
            }
            ++i;
        }
        return handledExceptions;
    }

    protected final void initLineNumberMarker(ModuleOption options) {
        if (!$assertionsDisabled && this.module == null) {
            throw new AssertionError();
        }
        if (options == null || options.markLineNumber()) {
            this.markLineNumber = true;
            this.module.initLineNoMap();
            this.tempLineNumbers = new HashMap();
        } else {
            this.markLineNumber = false;
        }
    }

    final void addUnnamedReportItem(DesignElement element) {
        if (!$assertionsDisabled && !(element instanceof ReportItem)) {
            throw new AssertionError();
        }
        if (!this.unnamedReportItems.contains(element)) {
            this.unnamedReportItems.add(element);
        }
    }

    static class ModuleLexicalHandler
    implements LexicalHandler {
        ModuleParserHandler handler = null;

        ModuleLexicalHandler(ModuleParserHandler handler) {
            this.handler = handler;
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
        }

        public void endCDATA() throws SAXException {
            AbstractParseState tmpState = this.handler.topState;
            tmpState.setIsCDataSection(true);
        }

        public void endDTD() throws SAXException {
        }

        public void endEntity(String name) throws SAXException {
        }

        public void startCDATA() throws SAXException {
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        public void startEntity(String name) throws SAXException {
        }
    }
}

