/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.event;

import org.eclipse.birt.chart.event.StructureType;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.MarkerLine;
import org.eclipse.birt.chart.model.component.MarkerRange;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.layout.Block;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.layout.TitleBlock;
import org.eclipse.emf.ecore.EObject;

public class StructureSource {
    private Object source;
    private StructureType type;

    public StructureSource(Object source) {
        this.source = source;
        this.type = StructureType.UNKNOWN;
    }

    public StructureSource(Object source, StructureType type) {
        this.source = source;
        this.type = type;
    }

    public Object getSource() {
        return this.source;
    }

    public StructureType getType() {
        return this.type;
    }

    public static StructureSource createSeries(Series se) {
        return new StructureSource(se, StructureType.SERIES);
    }

    public static StructureSource createPlot(Plot pt) {
        return new StructureSource(pt, StructureType.PLOT);
    }

    public static StructureSource createTitle(TitleBlock tb) {
        return new StructureSource(tb, StructureType.TITLE);
    }

    public static StructureSource createChartBlock(Block block) {
        return new StructureSource(block, StructureType.CHART_BLOCK);
    }

    public static StructureSource createUnknown(EObject o) {
        return new StructureSource(o, StructureType.UNKNOWN);
    }

    public static StructureSource createAxis(Axis ax) {
        return new StructureSource(ax, StructureType.AXIS);
    }

    public static StructureSource createLegend(Legend lg) {
        return new StructureSource(lg, StructureType.LEGEND);
    }

    public static StructureSource createMarkerLine(MarkerLine ml) {
        return new StructureSource(ml, StructureType.MARKER_LINE);
    }

    public static StructureSource createMarkerRange(MarkerRange mr) {
        return new StructureSource(mr, StructureType.MARKER_RANGE);
    }
}

