/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.xml.i18n.Messages;
import org.eclipse.datatools.enablement.oda.xml.util.ColumnInfo;
import org.eclipse.datatools.enablement.oda.xml.util.SaxParserUtil;
import org.eclipse.datatools.enablement.oda.xml.util.TableInfo;

public class RelationInformation {
    public static final String CONST_TABLE_DELIMITER = "#-#";
    public static final String CONST_TABLE_COLUMN_DELIMITER = "#:#";
    public static final String CONST_COLUMN_METAINFO_DELIMITER = ";";
    public static final String CONST_COLUMN_DELIMITER = ",";
    private HashMap tableInfos = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.datatools.enablement.oda.xml.util.RelationInformation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public RelationInformation(String relationString) throws OdaException {
        this.initialize(relationString.trim());
    }

    private void initialize(String relationString) throws OdaException {
        if (relationString == null || relationString.length() == 0) {
            throw new OdaException(Messages.getString("RelationInformation.InputStringCannotBeNull"));
        }
        String[] tables = relationString.split(CONST_TABLE_DELIMITER);
        int i = 0;
        while (i < tables.length) {
            ArrayList filterColumnInfos = new ArrayList();
            String[] temp = tables[i].trim().split(CONST_TABLE_COLUMN_DELIMITER);
            if (!$assertionsDisabled && temp.length != 3) {
                throw new AssertionError();
            }
            String tableName = temp[0].trim();
            String tableRawRoot = temp[1].substring(1, temp[1].length() - 1).trim();
            TableInfo tableInfo = new TableInfo(tableName, tableRawRoot);
            String[] columns = temp[2].trim().split(CONST_COLUMN_DELIMITER);
            int j = 0;
            while (j < columns.length) {
                String trimedColumn = columns[j].trim();
                String[] columnInfos = trimedColumn.substring(1, trimedColumn.length() - 1).split(CONST_COLUMN_METAINFO_DELIMITER);
                String columnXpath = null;
                columnXpath = columnInfos.length == 3 ? columnInfos[2] : "";
                int m = 0;
                while (m < columnInfos.length) {
                    columnInfos[m] = columnInfos[m].trim();
                    ++m;
                }
                String originalColumnXpath = columnXpath;
                HashMap map = null;
                if (columnXpath.matches(".*\\Q[@\\E.*\\Q=\\E.*")) {
                    map = RelationInformation.populateFilterInfo(filterColumnInfos, tableInfo, columns, columnXpath, originalColumnXpath);
                    columnXpath = columnXpath.replaceAll("\\Q[@\\E.*\\Q=\\E.*\\Q]\\E", "[*]").replaceAll("\\Q][*]\\E", "]");
                } else if (columnXpath.matches(".*\\Q[@\\E.*\\Q]\\E.*")) {
                    columnXpath = columnXpath.replaceAll("\\Q[@\\E.*\\Q]\\E", "").trim();
                }
                tableInfo.addColumn(new ColumnInfo(j + 1, columnInfos[0], columnInfos[1], tableInfo.getRootPath(), columnXpath, originalColumnXpath, map));
                ++j;
            }
            j = 0;
            while (j < filterColumnInfos.size()) {
                tableInfo.addColumn((ColumnInfo)filterColumnInfos.get(j));
                ++j;
            }
            if (tableRawRoot.matches(".*\\Q[@\\E.*\\Q=\\E.*")) {
                String tableRootWithFilter = SaxParserUtil.processParentAxis(tableRawRoot);
                String value = RelationInformation.getFilterValue(tableRootWithFilter);
                String filterColumnXpath = tableRootWithFilter.replaceAll("\\Q=\\E.*", "]");
                String filterOriginalColumnXpath = tableRawRoot.replaceAll("\\Q=\\E.*", "]");
                String tempColumnName = SaxParserUtil.createTableRootTempColumnNameForFilter();
                tableInfo.addFilter(tempColumnName, value);
                tableInfo.addColumn(new ColumnInfo(columns.length + filterColumnInfos.size() + 1, tempColumnName, "String", filterColumnXpath, null, filterOriginalColumnXpath, null));
            }
            this.tableInfos.put(temp[0].trim(), tableInfo);
            ++i;
        }
    }

    private static HashMap populateFilterInfo(List filterColumnInfos, TableInfo tableInfo, String[] columns, String columnXpath, String originalColumnXpath) throws OdaException {
        HashMap<String, String> map = null;
        String value = RelationInformation.getFilterValue(columnXpath);
        String filterOriginalColumnXpath = originalColumnXpath.replaceAll("\\Q=\\E.*", "]");
        String filterColumnXpath = columnXpath.replaceAll("\\Q=\\E.*", "]");
        String tempColumnName = SaxParserUtil.createTempColumnName(filterColumnInfos.size() + 1);
        map = new HashMap<String, String>();
        map.put(tempColumnName, value);
        filterColumnInfos.add(new ColumnInfo(columns.length + filterColumnInfos.size() + 1, tempColumnName, "String", tableInfo.getRootPath(), filterColumnXpath, filterOriginalColumnXpath, null));
        return map;
    }

    static String getFilterValue(String columnXpath) throws OdaException {
        String value = columnXpath.replaceAll(".*\\Q[@\\E.*\\Q=\\E", "").trim();
        if (!((value = value.replaceAll("\\Q]\\E.*", "").trim()).startsWith("'") && value.endsWith("'") || value.startsWith("\"") && value.endsWith("\""))) {
            throw new OdaException(Messages.getString("RelationInformation.InvalidFilterDefinition"));
        }
        value = value.substring(1, value.length() - 1);
        return value;
    }

    public String getTableColumnPath(String tableName, String columnName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? "" : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getPath(columnName == null ? "" : columnName.trim());
        }
        return null;
    }

    public String getTableOriginalColumnPath(String tableName, String columnName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? "" : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getOriginalPath(columnName == null ? "" : columnName.trim());
        }
        return null;
    }

    public int getTableNestedColumnBackRefNumber(String tableName, String columnName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? "" : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getBackRefNumber(columnName == null ? "" : columnName.trim());
        }
        return -1;
    }

    public int getTableColumnForwardRefNumber(String tableName, String columnName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? "" : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getForwardRefNumber(columnName == null ? "" : columnName.trim());
        }
        return -1;
    }

    public String getTableColumnType(String tableName, String columnName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? "" : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getType(columnName == null ? "" : columnName.trim());
        }
        return null;
    }

    public String[] getTableColumnNames(String tableName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? "" : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getColumnNames();
        }
        return new String[0];
    }

    String[] getTableRealColumnNames(String tableName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? "" : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getRealColumnNames();
        }
        return new String[0];
    }

    public String[] getTableComplexNestedXMLColumnNames(String tableName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? "" : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getComplexNestXMLColumnNames();
        }
        return new String[0];
    }

    public String[] getTableSimpleNestedXMLColumnNames(String tableName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? "" : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getSimpleNestXMLColumnNames();
        }
        return new String[0];
    }

    public String getTableRootPath(String tableName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? "" : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getRootPath();
        }
        return null;
    }

    public String getTableOriginalRootPath(String tableName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? "" : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getOriginalRootPath();
        }
        return null;
    }

    public HashMap getTableFilter(String tableName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? "" : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getFilter();
        }
        return null;
    }

    public Iterator getTableNames() {
        return this.tableInfos.keySet().iterator();
    }

    public HashMap getTableColumnFilter(String tableName, String columnName) {
        return ((TableInfo)this.tableInfos.get(tableName)).getColumnFilters(columnName);
    }

    public List getTableFilterColumns(String tableName) {
        return ((TableInfo)this.tableInfos.get(tableName)).getFilterColumns();
    }
}

