/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.internal.computations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.chart.computation.Point;
import org.eclipse.birt.chart.computation.Rectangle;

public class Polygon {
    private List points = new ArrayList();

    public void add(double x, double y) {
        this.add(new Point(x, y));
    }

    public void add(Point p) {
        this.points.add(p);
    }

    public Point getPoint(int index) {
        return (Point)this.points.get(index);
    }

    public List getPoints() {
        return this.points;
    }

    public Rectangle getBounds() {
        double xmin = Double.MAX_VALUE;
        double ymin = Double.MAX_VALUE;
        double xmax = -1.7976931348623157E308;
        double ymax = -1.7976931348623157E308;
        int i = 0;
        while (i < this.points.size()) {
            double x = this.getPoint(i).getX();
            double y = this.getPoint(i).getY();
            if (x < xmin) {
                xmin = x;
            }
            if (x > xmax) {
                xmax = x;
            }
            if (y < ymin) {
                ymin = y;
            }
            if (y > ymax) {
                ymax = y;
            }
            ++i;
        }
        return new Rectangle(xmin, ymin, xmax - xmin, ymax - ymin);
    }

    private boolean testInside(int count, double[] xa, double[] ya, double x, double y) {
        boolean c = false;
        int i = 0;
        int j = count - 1;
        while (i < count) {
            if ((ya[i] <= y && y < ya[j] || ya[j] <= y && y < ya[i]) && x < (xa[j] - xa[i]) * (y - ya[i]) / (ya[j] - ya[i]) + xa[i]) {
                c = !c;
            }
            j = i++;
        }
        return c;
    }

    private boolean testWithinLine(Point p) {
        boolean c = false;
        int i = 0;
        int j = this.points.size() - 1;
        while (!c && i < this.points.size()) {
            c = this.testWithinLine((Point)this.points.get(i), (Point)this.points.get(j), p);
            j = i++;
        }
        return c;
    }

    private boolean testWithinLine(Point pStart, Point pEnd, Point p) {
        boolean c;
        boolean bl = c = (p.x >= pStart.x && p.x <= pEnd.x || p.x <= pStart.x && p.x >= pEnd.x) && (p.y >= pStart.y && p.y <= pEnd.y || p.y <= pStart.y && p.y >= pEnd.y);
        if (c) {
            if (pEnd.x == pStart.x && pEnd.x == p.x) {
                return true;
            }
            if ((pEnd.x - pStart.x) * (pEnd.x - p.x) == 0.0) {
                return false;
            }
            c = (pEnd.y - pStart.y) / (pEnd.x - pStart.x) == (pEnd.y - p.y) / (pEnd.x - p.x);
        }
        return c;
    }

    private boolean testLineIntersect(Point p1, Point p2, Point q1, Point q2) {
        return this.ccw(p1, p2, q1) != this.ccw(p1, p2, q2) && this.ccw(q1, q2, p1) != this.ccw(q1, q2, p2);
    }

    private boolean ccw(Point a, Point b, Point c) {
        double dy2 = c.y - b.y;
        double dx1 = b.x - a.x;
        double gradient1 = dy2 * dx1;
        double dy1 = b.y - a.y;
        double dx2 = c.x - b.x;
        double gradient2 = dy1 * dx2;
        if (gradient1 == gradient2) {
            return dx1 * dx2 >= 0.0 && dy1 * dy2 >= 0.0;
        }
        return gradient1 > gradient2;
    }

    public boolean intersects(Polygon poly) {
        block13: {
            block12: {
                Point pt;
                if (poly == null) {
                    return false;
                }
                if (this.points.size() <= 2 || poly.points.size() <= 2) break block12;
                boolean started = false;
                boolean diff = false;
                boolean oldDiff = false;
                int count = this.points.size();
                double[] xa = new double[count];
                double[] ya = new double[count];
                int i = 0;
                while (i < count) {
                    pt = this.getPoint(i);
                    xa[i] = pt.getX();
                    ya[i] = pt.getY();
                    ++i;
                }
                Iterator itr = poly.getPoints().iterator();
                while (itr.hasNext()) {
                    pt = (Point)itr.next();
                    diff = this.testInside(count, xa, ya, pt.getX(), pt.getY());
                    if (!started) {
                        started = true;
                        oldDiff = diff;
                    }
                    if (diff != oldDiff) {
                        return true;
                    }
                    oldDiff = diff;
                }
                if (diff) {
                    return true;
                }
                if (this.getPoints().size() <= 0) break block13;
                count = poly.getPoints().size();
                xa = new double[count];
                ya = new double[count];
                i = 0;
                while (i < count) {
                    pt = poly.getPoint(i);
                    xa[i] = pt.getX();
                    ya[i] = pt.getY();
                    ++i;
                }
                itr = this.points.iterator();
                while (itr.hasNext()) {
                    pt = (Point)itr.next();
                    if (!this.testInside(count, xa, ya, pt.getX(), pt.getY())) continue;
                    return true;
                }
                break block13;
            }
            if (this.points.size() == 2 || poly.points.size() == 2) {
                List line = this.points;
                List pg = poly.points;
                if (line.size() > 2) {
                    line = poly.points;
                    pg = this.points;
                }
                Point lp1 = (Point)line.get(0);
                Point lp2 = (Point)line.get(1);
                int i = 0;
                while (i < pg.size()) {
                    if (i == pg.size() - 1 ? this.testLineIntersect(lp1, lp2, (Point)pg.get(i), (Point)pg.get(0)) : this.testLineIntersect(lp1, lp2, (Point)pg.get(i), (Point)pg.get(i + 1))) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    public boolean contains(Point p) {
        int count = this.points.size();
        double[] xa = new double[count];
        double[] ya = new double[count];
        int i = 0;
        while (i < count) {
            Point pt = this.getPoint(i);
            xa[i] = pt.getX();
            ya[i] = pt.getY();
            ++i;
        }
        return this.testInside(count, xa, ya, p.getX(), p.getY()) || this.testWithinLine(p);
    }
}

