/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.aggregation;

import java.util.HashMap;
import org.eclipse.birt.core.framework.FrameworkException;
import org.eclipse.birt.core.framework.IConfigurationElement;
import org.eclipse.birt.core.framework.IExtension;
import org.eclipse.birt.core.framework.IExtensionPoint;
import org.eclipse.birt.core.framework.IExtensionRegistry;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.data.engine.aggregation.BuiltInAggregationFactory;
import org.eclipse.birt.data.engine.api.aggregation.IAggregation;
import org.eclipse.birt.data.engine.core.DataException;

public class AggregationFactory {
    private static final String ATTRIBUTE_AGGREGATION_CLASS = "aggregationClass";
    private static final String ATTRIBUTE_AGGREGATION_NAME = "name";
    private static final String EXTENSION_POINT = "org.eclipse.birt.data.aggregation";
    private static final String ELEMENT_AGGREGATIONS = "Aggregations";
    private static final String ELEMENT_AGGREGATION = "Aggregation";
    private static AggregationFactory instance;
    private static HashMap aggregations;
    private static HashMap aggrAdapterMap;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.aggregation.AggregationFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        instance = null;
        aggregations = null;
        aggrAdapterMap = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AggregationFactory getInstance() throws DataException {
        if (instance != null) return instance;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.aggregation.AggregationFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (instance != null) return instance;
            instance = new AggregationFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void destroyInstance() {
        instance = null;
        aggregations = null;
        aggrAdapterMap = null;
    }

    private AggregationFactory() throws DataException {
        this.populateAggregations();
    }

    private void populateAggregations() throws DataException {
        aggregations = new HashMap();
        aggrAdapterMap = new HashMap();
        AggregationFactory.populateAggrAdapterMap();
        this.populateBuiltInAggregations();
        this.populateExtendedAggregations();
    }

    private static void populateAggrAdapterMap() {
        aggrAdapterMap.put("sum", "SUM");
        aggrAdapterMap.put("count", "COUNT");
        aggrAdapterMap.put("min", "MIN");
        aggrAdapterMap.put("max", "MAX");
        aggrAdapterMap.put("average", "AVE");
        aggrAdapterMap.put("weighted-avg", "WEIGHTEDAVE");
        aggrAdapterMap.put("stddev", "STDDEV");
        aggrAdapterMap.put("first", "FIRST");
        aggrAdapterMap.put("last", "LAST");
        aggrAdapterMap.put("mode", "MODE");
        aggrAdapterMap.put("moving-ave", "MOVINGAVE");
        aggrAdapterMap.put("median", "MEDIAN");
        aggrAdapterMap.put("variance", "VARIANCE");
        aggrAdapterMap.put("running-sum", "RUNNINGSUM");
        aggrAdapterMap.put("irr", "IRR");
        aggrAdapterMap.put("mirr", "MIRR");
        aggrAdapterMap.put("npv", "NPV");
        aggrAdapterMap.put("running-npv", "RUNNINGNPV");
        aggrAdapterMap.put("count-distinct", "COUNTDISTINCT");
        aggrAdapterMap.put("running-count", "RUNNINGCOUNT");
        aggrAdapterMap.put("is-top-n", "ISTOPN");
        aggrAdapterMap.put("is-bottom-n", "ISBOTTOMN");
        aggrAdapterMap.put("is-top-n-percent", "ISTOPNPERCENT");
        aggrAdapterMap.put("is-bottom-n-percent", "ISBOTTOMNPERCENT");
        aggrAdapterMap.put("percent-rank", "PERCENTRANK");
        aggrAdapterMap.put("percentile", "PERCENTILE");
        aggrAdapterMap.put("quartile", "QUARTILE");
        aggrAdapterMap.put("percent-sum", "PERCENTSUM");
        aggrAdapterMap.put("rank", "RANK");
    }

    private void populateBuiltInAggregations() {
        String[] builtInAggrNames = BuiltInAggregationFactory.getInstance().getAggregationNames();
        int i = 0;
        while (i < builtInAggrNames.length) {
            aggregations.put(builtInAggrNames[i], BuiltInAggregationFactory.getInstance().getAggregation(builtInAggrNames[i]));
            ++i;
        }
    }

    private void populateExtendedAggregations() throws DataException {
        IExtensionRegistry extReg = Platform.getExtensionRegistry();
        IExtensionPoint extPoint = extReg.getExtensionPoint(EXTENSION_POINT);
        if (extPoint == null) {
            return;
        }
        IExtension[] exts = extPoint.getExtensions();
        if (exts == null) {
            return;
        }
        int e = 0;
        while (e < exts.length) {
            IConfigurationElement[] configElems = exts[e].getConfigurationElements();
            if (configElems != null) {
                int i = 0;
                while (i < configElems.length) {
                    if (configElems[i].getName().equals(ELEMENT_AGGREGATIONS)) {
                        IConfigurationElement[] subElems = configElems[i].getChildren(ELEMENT_AGGREGATION);
                        int j = 0;
                        while (j < subElems.length) {
                            String name = subElems[j].getAttribute(ATTRIBUTE_AGGREGATION_NAME);
                            try {
                                if (aggregations.put(name.toUpperCase().trim(), subElems[j].createExecutableExtension(ATTRIBUTE_AGGREGATION_CLASS)) != null) {
                                    throw new DataException("date.engine.DuplicateAggregationName", name);
                                }
                            }
                            catch (FrameworkException frameworkException) {
                                DataException ep = new DataException("data.engine.CannotInstantiateAggregationFactory", name);
                                throw ep;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            ++e;
        }
    }

    public IAggregation getAggregation(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        IAggregation aggr = (IAggregation)aggregations.get(name.toUpperCase());
        if (aggr == null) {
            String buildInAggrName = (String)aggrAdapterMap.get(name);
            aggr = (IAggregation)aggregations.get(buildInAggrName);
        }
        return aggr;
    }
}

