/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.dscache;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.data.engine.api.querydefn.ComputedColumn;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.DataSetCacheManager;
import org.eclipse.birt.data.engine.executor.IDataSetCacheObject;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.executor.ResultObject;
import org.eclipse.birt.data.engine.executor.dscache.CacheUtilFactory;
import org.eclipse.birt.data.engine.executor.dscache.ILoadUtil;
import org.eclipse.birt.data.engine.executor.dscache.ISaveUtil;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.odaconsumer.ResultSet;
import org.eclipse.birt.data.engine.odi.ICustomDataSet;
import org.eclipse.birt.data.engine.odi.IDataSetPopulator;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

public class DataSetResultCache {
    private IResultClass rsMeta;
    private ResultSet odaDataSet;
    private ICustomDataSet customDataSet;
    private IDataSetPopulator populator;
    private int cacheCount;
    private ISaveUtil saveUtil;
    private boolean isSaved;
    private ILoadUtil loadUtil;
    private boolean isLoad;
    private List addedTempComputedColumn;
    private int realColumnCount;
    private DataEngineSession session;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.executor.dscache.DataSetResultCache");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public DataSetResultCache(ResultSet odaDataSet, IResultClass rsMeta, DataEngineSession session) {
        if (!$assertionsDisabled && odaDataSet == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && rsMeta == null) {
            throw new AssertionError();
        }
        this.odaDataSet = odaDataSet;
        this.init(rsMeta, session);
    }

    public DataSetResultCache(IDataSetPopulator populator, IResultClass rsMeta, DataEngineSession session) {
        if (!$assertionsDisabled && populator == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && rsMeta == null) {
            throw new AssertionError();
        }
        this.populator = populator;
        this.init(rsMeta, session);
    }

    public DataSetResultCache(ICustomDataSet customDataSet, IResultClass rsMeta, DataEngineSession session) {
        if (!$assertionsDisabled && customDataSet == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && rsMeta == null) {
            throw new AssertionError();
        }
        this.customDataSet = customDataSet;
        this.init(rsMeta, session);
    }

    private void init(IResultClass rsMeta, DataEngineSession session) {
        this.rsMeta = rsMeta;
        this.isLoad = false;
        this.isSaved = false;
        this.session = session;
        this.cacheCount = this.getCacheCount();
    }

    public DataSetResultCache(DataEngineSession session) {
        this.isLoad = true;
        this.session = session;
    }

    public void setTempComputedColumn(List addedTempComputedColumn) {
        this.addedTempComputedColumn = addedTempComputedColumn;
    }

    public IResultObject fetch() throws DataException {
        if (!this.isLoad) {
            if (this.cacheCount <= 0) {
                if (this.odaDataSet != null) {
                    return this.odaDataSet.fetch();
                }
                if (this.customDataSet != null) {
                    return this.customDataSet.fetch();
                }
                return this.populator.next();
            }
            if (!this.isSaved) {
                this.cacheDataSet();
                this.isSaved = true;
            }
            return this.loadObject();
        }
        return this.loadObject();
    }

    private void cacheDataSet() throws DataException {
        int index = 0;
        IResultObject resultObject = null;
        this.saveInit();
        do {
            if ((resultObject = this.odaDataSet != null ? this.odaDataSet.fetch() : (this.customDataSet != null ? this.customDataSet.fetch() : this.populator.next())) == null) continue;
            this.saveUtil.saveObject(resultObject);
            if (++index >= this.cacheCount) break;
        } while (resultObject != null);
        this.saveClose();
    }

    public IResultClass getResultClass() throws DataException {
        if (this.isLoad && this.rsMeta == null) {
            this.rsMeta = this.loadResultClass();
            if (this.addedTempComputedColumn != null && this.addedTempComputedColumn.size() > 0) {
                this.processResultClass();
            }
        }
        return this.rsMeta;
    }

    private void processResultClass() throws DataException {
        ArrayList<ResultFieldMetadata> metadataList = new ArrayList<ResultFieldMetadata>();
        this.realColumnCount = 0;
        ResultFieldMetadata metadata = null;
        int i = 0;
        i = 0;
        while (i < this.rsMeta.getFieldCount()) {
            if (!this.isTempComputedColumn(this.rsMeta.getFieldName(i + 1))) {
                metadata = new ResultFieldMetadata(0, this.rsMeta.getFieldName(i + 1), this.rsMeta.getFieldLabel(i + 1), this.rsMeta.getFieldValueClass(i + 1), this.rsMeta.getFieldNativeTypeName(i + 1), this.rsMeta.isCustomField(i + 1));
                metadata.setAlias(this.rsMeta.getFieldAlias(i + 1));
                metadataList.add(metadata);
                ++this.realColumnCount;
            }
            ++i;
        }
        ComputedColumn tempComputedColumn = null;
        i = 0;
        while (i < this.addedTempComputedColumn.size()) {
            tempComputedColumn = (ComputedColumn)this.addedTempComputedColumn.get(i);
            metadata = new ResultFieldMetadata(0, tempComputedColumn.getName(), null, DataType.getClass((int)tempComputedColumn.getDataType()), null, true);
            metadataList.add(metadata);
            ++i;
        }
        this.rsMeta = new ResultClass(metadataList);
    }

    private boolean isTempComputedColumn(String name) {
        return name.matches("\\Q_{$TEMP_GROUP_\\E\\d*\\Q$}_\\E") || name.matches("\\Q_{$TEMP_SORT_\\E\\d*\\Q$}_\\E") || name.matches("\\Q_{$TEMP_FILTER_\\E\\d*\\Q$}_\\E");
    }

    public void close() throws DataException {
        if (this.loadUtil != null) {
            this.loadUtil.close();
            this.loadUtil = null;
        }
    }

    private void saveInit() {
        this.saveUtil = CacheUtilFactory.createSaveUtil(this.getCacheObject(), this.rsMeta);
    }

    private void saveClose() throws DataException {
        if (this.saveUtil != null) {
            this.saveUtil.close();
            this.saveUtil = null;
        }
    }

    private IResultObject loadObject() throws DataException {
        IResultObject cacheObject;
        if (this.loadUtil == null) {
            this.loadUtil = CacheUtilFactory.createLoadUtil(this.getCacheObject(), this.session);
        }
        if ((cacheObject = this.loadUtil.loadObject()) == null) {
            return cacheObject;
        }
        if (this.addedTempComputedColumn != null && this.addedTempComputedColumn.size() > 0) {
            ResultObject resultObject = new ResultObject(this.getResultClass(), this.getAllObjects(cacheObject));
            return resultObject;
        }
        return cacheObject;
    }

    private Object[] getAllObjects(IResultObject cacheObject) throws DataException {
        Object[] objects = new Object[this.realColumnCount + this.addedTempComputedColumn.size()];
        int i = 0;
        while (i < this.realColumnCount) {
            objects[i] = cacheObject.getFieldValue(i + 1);
            ++i;
        }
        return objects;
    }

    private IResultClass loadResultClass() throws DataException {
        if (this.loadUtil == null) {
            this.loadUtil = CacheUtilFactory.createLoadUtil(this.getCacheObject(), this.session);
        }
        return this.loadUtil.loadResultClass();
    }

    private DataSetCacheManager getDataSetCacheManager() {
        return this.session.getDataSetCacheManager();
    }

    private int getCacheCount() {
        return this.getDataSetCacheManager().getCacheRowCount();
    }

    private IDataSetCacheObject getCacheObject() {
        return this.getDataSetCacheManager().getCacheObject();
    }
}

