/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import com.ibm.icu.util.ULocale;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.ITOCTree;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.TOCNode;
import org.eclipse.birt.report.engine.api.impl.ParameterAttribute;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentConstants;
import org.eclipse.birt.report.engine.api.impl.ReportRunnable;
import org.eclipse.birt.report.engine.internal.document.IPageHintReader;
import org.eclipse.birt.report.engine.internal.document.PageHintReader;
import org.eclipse.birt.report.engine.internal.document.v4.InstanceIDComparator;
import org.eclipse.birt.report.engine.internal.executor.doc.Fragment;
import org.eclipse.birt.report.engine.ir.EngineIRReader;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.presentation.IPageHint;
import org.eclipse.birt.report.engine.presentation.PageSection;
import org.eclipse.birt.report.engine.toc.TOCBuilder;
import org.eclipse.birt.report.engine.toc.TOCTree;

public class ReportDocumentReader
implements IReportDocument,
ReportDocumentConstants {
    private static Logger logger;
    private IReportEngine engine;
    private IDocArchiveReader archive;
    private ReportRunnable reportRunnable;
    private Map moduleOptions;
    private String docVersion;
    private int coreVersion = -1;
    private HashMap parameters;
    private HashMap globalVariables;
    private HashMap bookmarks;
    private IPageHintReader pageHintReader;
    private TOCTree tocTree;
    private HashMap reportletsIndexById;
    private HashMap reportletsIndexByBookmark;
    private String systemId;
    private int checkpoint = 0;
    private long pageCount;
    private boolean sharedArchive;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.api.impl.ReportDocumentReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public ReportDocumentReader(IReportEngine engine, IDocArchiveReader archive, boolean sharedArchive) throws EngineException {
        this(null, engine, archive, sharedArchive);
    }

    public ReportDocumentReader(IReportEngine engine, IDocArchiveReader archive) throws EngineException {
        this(null, engine, archive, false);
    }

    public ReportDocumentReader(String systemId, IReportEngine engine, IDocArchiveReader archive) throws EngineException {
        this(systemId, engine, archive, false);
    }

    public ReportDocumentReader(String systemId, IReportEngine engine, IDocArchiveReader archive, boolean sharedArchive) throws EngineException {
        this.engine = engine;
        this.archive = archive;
        this.systemId = systemId;
        this.sharedArchive = sharedArchive;
        this.moduleOptions = new HashMap();
        this.moduleOptions.put("semanticCheck", Boolean.FALSE);
        try {
            archive.open();
        }
        catch (Exception e) {
            throw new EngineException("Failed to open the report document", e);
        }
        try {
            this.doRefresh();
        }
        catch (EngineException ee) {
            try {
                archive.close();
            }
            catch (Exception exception) {}
            throw ee;
        }
    }

    void setModuleOptions(Map options) {
        this.moduleOptions = new HashMap();
        this.moduleOptions.putAll(options);
        Object semanticCheck = this.moduleOptions.get("semanticCheck");
        if (semanticCheck == null) {
            this.moduleOptions.put("semanticCheck", Boolean.FALSE);
        }
    }

    public IDocArchiveReader getArchive() {
        return this.archive;
    }

    public String getVersion() {
        return this.docVersion;
    }

    public void refresh() {
        if (this.checkpoint == -1) {
            return;
        }
        try {
            this.doRefresh();
        }
        catch (EngineException ee) {
            logger.log(Level.SEVERE, "Failed to refresh", (Throwable)((Object)ee));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doRefresh() throws EngineException {
        try {
            Object lock = this.archive.lock("/core");
            RAInputStream in = this.archive.getStream("/core");
            try {
                DataInputStream di = new DataInputStream((InputStream)in);
                this.checkVersion(di);
                if (this.coreVersion == -1) {
                    this.doOldRefresh(di);
                } else {
                    if (this.coreVersion != 0) throw new Exception("unsupported document:" + this.docVersion + "  core stream version: " + this.coreVersion);
                    this.doRefreshV0(di);
                }
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                in.close();
                this.archive.unlock(lock);
                throw throwable;
            }
            {
                Object var4_8 = null;
                in.close();
                this.archive.unlock(lock);
                return;
            }
        }
        catch (EngineException ee) {
            throw ee;
        }
        catch (Exception ex) {
            throw new EngineException("document refresh failed", ex);
        }
    }

    protected void doRefreshV0(DataInputStream di) throws Exception {
        ReportDocumentCoreInfo documentInfo = new ReportDocumentCoreInfo();
        documentInfo.checkpoint = 0;
        documentInfo.pageCount = 0L;
        documentInfo.checkpoint = IOUtil.readInt((InputStream)di);
        documentInfo.pageCount = IOUtil.readLong((DataInputStream)di);
        if (documentInfo.checkpoint == this.checkpoint) {
            return;
        }
        String orgSystemId = IOUtil.readString((DataInputStream)di);
        documentInfo.systemId = this.systemId == null ? orgSystemId : this.systemId;
        Map originalParameters = IOUtil.readMap((DataInputStream)di);
        documentInfo.parameters = this.convertToCompatibleParameter(originalParameters);
        documentInfo.globalVariables = (HashMap)IOUtil.readMap((DataInputStream)di);
        this.checkpoint = documentInfo.checkpoint;
        this.pageCount = documentInfo.pageCount;
        this.systemId = documentInfo.systemId;
        this.globalVariables = documentInfo.globalVariables;
        this.parameters = documentInfo.parameters;
        if (documentInfo.checkpoint == -1) {
            this.bookmarks = this.readMap(di);
            this.tocTree = new TOCTree();
            TOCBuilder.read(this.tocTree, di);
            this.reportletsIndexById = this.readMap(di);
            this.reportletsIndexByBookmark = this.readMap(di);
        }
    }

    private HashMap readMap(DataInputStream di) throws Exception {
        HashMap<String, Long> map = new HashMap<String, Long>();
        long count = IOUtil.readLong((DataInputStream)di);
        long i = 0L;
        while (i < count) {
            String bookmark = IOUtil.readString((DataInputStream)di);
            long pageNumber = IOUtil.readLong((DataInputStream)di);
            map.put(bookmark, new Long(pageNumber));
            ++i;
        }
        return map;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doOldRefresh(DataInputStream coreStream) throws EngineException {
        try {
            ReportDocumentCoreInfo documentInfo = new ReportDocumentCoreInfo();
            documentInfo.checkpoint = 0;
            documentInfo.pageCount = 0L;
            if (!this.archive.exists("/checkpoint")) {
                documentInfo.checkpoint = -1;
                this.initializePageHintReader();
                if (this.pageHintReader != null) {
                    documentInfo.pageCount = this.pageHintReader.getTotalPage();
                }
            } else {
                block9: {
                    RAInputStream in = this.archive.getStream("/checkpoint");
                    try {
                        DataInputStream di = new DataInputStream((InputStream)in);
                        documentInfo.checkpoint = IOUtil.readInt((InputStream)di);
                        documentInfo.pageCount = IOUtil.readLong((DataInputStream)di);
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        if (in == null) throw throwable;
                        in.close();
                        throw throwable;
                    }
                    {
                        Object var5_8 = null;
                        if (in == null) break block9;
                    }
                    in.close();
                }
                if (documentInfo.checkpoint == this.checkpoint) {
                    return;
                }
            }
            String orgSystemId = IOUtil.readString((DataInputStream)coreStream);
            documentInfo.systemId = this.systemId == null ? orgSystemId : this.systemId;
            Map originalParameters = IOUtil.readMap((DataInputStream)coreStream);
            documentInfo.parameters = this.convertToCompatibleParameter(originalParameters);
            documentInfo.globalVariables = (HashMap)IOUtil.readMap((DataInputStream)coreStream);
            this.checkpoint = documentInfo.checkpoint;
            this.pageCount = documentInfo.pageCount;
            this.systemId = documentInfo.systemId;
            this.globalVariables = documentInfo.globalVariables;
            this.parameters = documentInfo.parameters;
            return;
        }
        catch (Exception ex) {
            throw new EngineException("document refresh failed", ex);
        }
    }

    private HashMap convertToCompatibleParameter(Map parameters) {
        if (parameters == null) {
            return null;
        }
        HashMap result = new HashMap();
        Iterator iterator = parameters.entrySet().iterator();
        while (iterator.hasNext()) {
            Object[] values;
            Map.Entry entry = iterator.next();
            Object key = entry.getKey();
            Object valueObj = entry.getValue();
            ParameterAttribute paramAttr = null;
            if (valueObj instanceof ParameterAttribute) {
                paramAttr = (ParameterAttribute)valueObj;
            } else if (valueObj instanceof Object[] && (values = (Object[])valueObj).length == 2) {
                Object value = values[0];
                String displayText = (String)values[1];
                paramAttr = new ParameterAttribute(value, displayText);
            }
            if (paramAttr == null) {
                paramAttr = new ParameterAttribute(valueObj, null);
            }
            result.put(key, paramAttr);
        }
        return result;
    }

    protected void checkVersion(DataInputStream di) throws IOException, EngineException {
        String tag = IOUtil.readString((DataInputStream)di);
        this.docVersion = IOUtil.readString((DataInputStream)di);
        if ("CORE_VERSION_0".equals(this.docVersion)) {
            this.coreVersion = Integer.parseInt("CORE_VERSION_0".substring("CORE_VERSION_".length()));
            this.docVersion = IOUtil.readString((DataInputStream)di);
        }
        String[] supportedVersions = new String[]{"1.2.1", "2.1.0", "2.1.3-2.2RC0"};
        if ("reportdocument".equals(tag)) {
            int i = 0;
            while (i < supportedVersions.length) {
                if (supportedVersions[i].equals(this.docVersion)) {
                    return;
                }
                ++i;
            }
        }
        throw new EngineException("unsupport report document tag" + tag + " version " + this.docVersion);
    }

    public void close() {
        try {
            if (this.pageHintReader != null) {
                this.pageHintReader.close();
            }
            this.pageHintReader = null;
            if (!this.sharedArchive) {
                this.archive.close();
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Failed to close the archive", e);
        }
    }

    public InputStream getDesignStream() {
        try {
            return this.archive.getStream("/design");
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Failed to open the design!", ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IReportRunnable getReportRunnable() {
        if (this.reportRunnable != null) {
            return this.reportRunnable;
        }
        ReportDocumentReader reportDocumentReader = this;
        synchronized (reportDocumentReader) {
            if (this.reportRunnable != null) {
                return this.reportRunnable;
            }
            String name = null;
            name = this.systemId == null ? this.archive.getName() : this.systemId;
            InputStream stream = this.getDesignStream();
            if (stream == null) return this.reportRunnable;
            try {
                try {
                    this.reportRunnable = (ReportRunnable)this.engine.openReportDesign(name, stream, this.moduleOptions);
                    stream.close();
                    try {
                        stream = this.archive.getStream("/design.ir");
                        EngineIRReader reader = new EngineIRReader();
                        Report reportIR = reader.read(stream);
                        reader.link(reportIR, this.reportRunnable.getReport());
                        this.reportRunnable.setReportIR(reportIR);
                    }
                    catch (IOException ioex) {
                        logger.log(Level.FINE, "Failed to load the engine IR", ioex);
                    }
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "Failed to get the report runnable", ex);
                }
                Object var6_10 = null;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                try {
                    if (stream == null) throw throwable;
                    stream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            if (stream == null) return this.reportRunnable;
            stream.close();
            return this.reportRunnable;
        }
    }

    public Map getParameterValues() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.parameters != null) {
            Iterator iterator = this.parameters.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String name = (String)entry.getKey();
                ParameterAttribute value = (ParameterAttribute)entry.getValue();
                result.put(name, value.getValue());
            }
        }
        return result;
    }

    public Map getParameterDisplayTexts() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.parameters != null) {
            Iterator iterator = this.parameters.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String name = (String)entry.getKey();
                ParameterAttribute value = (ParameterAttribute)entry.getValue();
                result.put(name, value.getDisplayText());
            }
        }
        return result;
    }

    public long getPageCount() {
        return this.pageCount;
    }

    public IPageHint getPageHint(long pageNumber) {
        this.initializePageHintReader();
        if (this.pageHintReader != null) {
            try {
                return this.pageHintReader.getPageHint(pageNumber);
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "Failed to load page hint " + pageNumber, ex);
            }
        }
        return null;
    }

    public long getPageNumber(String bookmark) {
        if (!this.isComplete()) {
            return -1L;
        }
        this.intializeBookmarks();
        Object number = this.bookmarks.get(bookmark);
        if (number instanceof Number) {
            return ((Number)number).intValue();
        }
        return -1L;
    }

    public List getBookmarks() {
        if (!this.isComplete()) {
            return null;
        }
        this.intializeBookmarks();
        ArrayList<String> list = new ArrayList<String>();
        Set bookmarkSet = this.bookmarks.keySet();
        Iterator iterator = bookmarkSet.iterator();
        while (iterator.hasNext()) {
            String bookmark = (String)iterator.next();
            if (bookmark == null || bookmark.startsWith("__TOC")) continue;
            list.add(bookmark);
        }
        return list;
    }

    public long getBookmark(String bookmark) {
        if (!this.isComplete()) {
            return -1L;
        }
        this.intializeBookmarks();
        Long pageNumber = (Long)this.bookmarks.get(bookmark);
        if (pageNumber == null) {
            return 0L;
        }
        return pageNumber;
    }

    public ITOCTree getTOCTree(String format, ULocale locale) {
        if (!this.isComplete()) {
            return null;
        }
        this.intializeTOC();
        TOCTree result = new TOCTree(this.tocTree.getTOCRoot(), format, locale, ((ReportRunnable)this.getReportRunnable()).getReport());
        return result;
    }

    public TOCNode findTOC(String tocNodeId) {
        if (!this.isComplete()) {
            return null;
        }
        this.intializeTOC();
        ITOCTree tree = this.getTOCTree("all", ULocale.getDefault());
        return tree.findTOC(tocNodeId);
    }

    public List findTOCByName(String tocName) {
        if (!this.isComplete()) {
            return null;
        }
        this.intializeTOC();
        ITOCTree tree = this.getTOCTree("all", ULocale.getDefault());
        return tree.findTOCByValue(tocName);
    }

    public List getChildren(String tocNodeId) {
        if (!this.isComplete()) {
            return null;
        }
        TOCNode node = this.findTOC(tocNodeId);
        if (node != null) {
            return node.getChildren();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void intializeTOC() {
        if (this.tocTree != null) {
            return;
        }
        if (this.coreVersion != -1) {
            return;
        }
        ReportDocumentReader reportDocumentReader = this;
        synchronized (reportDocumentReader) {
            if (this.tocTree != null) {
                return;
            }
            this.tocTree = new TOCTree();
            if (!this.archive.exists("/toc")) return;
            RAInputStream in = null;
            try {
                try {
                    in = this.archive.getStream("/toc");
                    DataInputStream input = new DataInputStream((InputStream)in);
                    TOCBuilder.read(this.tocTree, input);
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "Failed to load the TOC", ex);
                }
                Object var4_7 = null;
                if (in == null) return;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            in.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void intializeBookmarks() {
        if (this.bookmarks != null) {
            return;
        }
        if (this.coreVersion != -1) {
            return;
        }
        ReportDocumentReader reportDocumentReader = this;
        synchronized (reportDocumentReader) {
            if (this.bookmarks != null) {
                return;
            }
            this.bookmarks = new HashMap();
            if (!this.archive.exists("/bookmark")) {
                return;
            }
            RAInputStream in = null;
            try {
                try {
                    in = this.archive.getStream("/bookmark");
                    DataInputStream di = new DataInputStream((InputStream)in);
                    long count = IOUtil.readLong((DataInputStream)di);
                    long i = 0L;
                    while (i < count) {
                        String bookmark = IOUtil.readString((DataInputStream)di);
                        long pageNumber = IOUtil.readLong((DataInputStream)di);
                        this.bookmarks.put(bookmark, new Long(pageNumber));
                        ++i;
                    }
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "failed to load the bookmarks", ex);
                }
                Object var11_11 = null;
                if (in == null) return;
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {}
            catch (Exception exception) {}
            in.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializePageHintReader() {
        if (this.pageHintReader != null) {
            return;
        }
        ReportDocumentReader reportDocumentReader = this;
        synchronized (reportDocumentReader) {
            if (this.pageHintReader != null) {
                return;
            }
            try {
                this.pageHintReader = new PageHintReader(this);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "can't open the page hint stream", ex);
            }
        }
    }

    public String getName() {
        return this.archive.getName();
    }

    public Map getGlobalVariables(String option) {
        return this.globalVariables;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public long getPageNumber(InstanceID iid) {
        if (!this.isComplete()) {
            return -1L;
        }
        if ("1.0.0".equals(this.getVersion())) {
            return -1L;
        }
        this.initializePageHintReader();
        if (this.pageHintReader == null) {
            return -1L;
        }
        int version = this.pageHintReader.getVersion();
        try {
            if (version == 0) {
                long offset = this.getInstanceOffset(iid);
                if (offset == -1L) {
                    return -1L;
                }
                long totalPage = this.pageHintReader.getTotalPage();
                long pageNumber = 1L;
                while (pageNumber <= totalPage) {
                    IPageHint hint = this.pageHintReader.getPageHint(pageNumber);
                    PageSection section = hint.getSection(0);
                    if (offset >= section.startOffset) {
                        return pageNumber;
                    }
                    ++pageNumber;
                }
            } else if (version == 1) {
                long offset = this.getInstanceOffset(iid);
                if (offset == -1L) {
                    return -1L;
                }
                long totalPage = this.pageHintReader.getTotalPage();
                long pageNumber = 1L;
                while (pageNumber <= totalPage) {
                    IPageHint hint = this.pageHintReader.getPageHint(pageNumber);
                    int sectionCount = hint.getSectionCount();
                    int i = 0;
                    while (i < sectionCount) {
                        PageSection section = hint.getSection(i);
                        if (section.startOffset <= offset && offset <= section.endOffset) {
                            return pageNumber;
                        }
                        ++i;
                    }
                    ++pageNumber;
                }
            } else if (version == 2 || version == 3) {
                long totalPage = this.pageHintReader.getTotalPage();
                long pageNumber = 1L;
                while (pageNumber <= totalPage) {
                    IPageHint hint = this.pageHintReader.getPageHint(pageNumber);
                    int sectionCount = hint.getSectionCount();
                    Fragment fragment = new Fragment(new InstanceIDComparator());
                    int i = 0;
                    while (i < sectionCount) {
                        PageSection section = hint.getSection(i);
                        fragment.addFragment(section.starts, section.ends);
                        ++i;
                    }
                    if (fragment.inFragment(iid)) {
                        return pageNumber;
                    }
                    ++pageNumber;
                }
            }
        }
        catch (IOException iOException) {}
        return -1L;
    }

    public long getInstanceOffset(InstanceID iid) {
        if (!this.isComplete()) {
            return -1L;
        }
        if (iid == null) {
            return -1L;
        }
        this.initializeReportlet();
        long offset = this.getOffset(this.reportletsIndexById, iid.toUniqueString());
        if (offset == -1L) {
            offset = this.getOffset(this.reportletsIndexById, iid.toString());
        }
        return offset;
    }

    public long getBookmarkOffset(String bookmark) {
        if (!this.isComplete()) {
            return -1L;
        }
        if (bookmark == null) {
            return -1L;
        }
        this.initializeReportlet();
        return this.getOffset(this.reportletsIndexByBookmark, bookmark);
    }

    private long getOffset(Map index, String key) {
        if ("1.0.0".equals(this.getVersion())) {
            return -1L;
        }
        Long offset = (Long)index.get(key);
        if (offset != null) {
            return offset;
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeReportlet() {
        if (this.reportletsIndexById != null) {
            return;
        }
        if (this.coreVersion != -1) {
            return;
        }
        ReportDocumentReader reportDocumentReader = this;
        synchronized (reportDocumentReader) {
            if (this.reportletsIndexById != null) {
                return;
            }
            this.reportletsIndexById = new HashMap();
            this.reportletsIndexByBookmark = new HashMap();
            this.loadReportletStream(this.reportletsIndexById, "/reportlet");
            this.loadReportletStream(this.reportletsIndexByBookmark, "/reportletBookmarks");
        }
    }

    /*
     * Exception decompiling
     */
    private void loadReportletStream(Map index, String streamName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 132->136)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isComplete() {
        return this.checkpoint == -1;
    }

    protected class ReportDocumentCoreInfo {
        HashMap globalVariables;
        HashMap parameters;
        String systemId;
        int checkpoint;
        long pageCount;

        protected ReportDocumentCoreInfo() {
        }
    }
}

