/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.content.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.content.IContentVisitor;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.impl.ContainerContent;
import org.eclipse.birt.report.engine.ir.ListItemDesign;

public class ListContent
extends ContainerContent
implements IListContent {
    Boolean headerRepeat;
    protected static final short FIELD_HEADER_REPEAT = 1300;

    public ListContent(IReportContent report) {
        super(report);
    }

    public int getContentType() {
        return 13;
    }

    public Object accept(IContentVisitor visitor, Object value) {
        return visitor.visitList(this, value);
    }

    public void setHeaderRepeat(boolean headerRepeat) {
        if (this.generateBy instanceof ListItemDesign && ((ListItemDesign)this.generateBy).isRepeatHeader() == headerRepeat) {
            this.headerRepeat = null;
            return;
        }
        this.headerRepeat = headerRepeat;
    }

    public boolean isHeaderRepeat() {
        if (this.headerRepeat != null) {
            return this.headerRepeat;
        }
        if (this.generateBy instanceof ListItemDesign) {
            return ((ListItemDesign)this.generateBy).isRepeatHeader();
        }
        return false;
    }

    public IListBandContent getHeader() {
        return this.getListBand(1);
    }

    protected IListBandContent getListBand(int type) {
        if (this.children == null) {
            return null;
        }
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            IListBandContent listBand;
            Object child = iter.next();
            if (!(child instanceof IListBandContent) || (listBand = (IListBandContent)child).getBandType() != type) continue;
            return listBand;
        }
        return null;
    }

    protected void writeFields(DataOutputStream out) throws IOException {
        super.writeFields(out);
        if (this.headerRepeat != null) {
            IOUtil.writeShort((OutputStream)out, (short)1300);
            IOUtil.writeBool((OutputStream)out, (boolean)this.headerRepeat);
        }
    }

    protected void readField(int version, int filedId, DataInputStream in) throws IOException {
        switch (filedId) {
            case 1300: {
                this.headerRepeat = IOUtil.readBool((InputStream)in);
                break;
            }
            default: {
                super.readField(version, filedId, in);
            }
        }
    }

    public boolean needSave() {
        if (this.headerRepeat != null) {
            return true;
        }
        return super.needSave();
    }
}

