/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data.dte;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.engine.adapter.ModelDteApiAdapter;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.data.dte.QueryResultSet;
import org.eclipse.birt.report.engine.data.dte.ReportQueryBuilder;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.ICubeResultSet;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.olap.CubeHandle;

public abstract class AbstractDataEngine
implements IDataEngine {
    protected DataRequestSession dteSession;
    protected ExecutionContext context;
    protected HashMap queryIDMap = new HashMap();
    protected HashMap cachedQueryIdMap = new HashMap();
    protected Map appContext;
    protected String reportArchName = null;
    private ModelDteApiAdapter adapter = null;
    protected static Logger logger;
    protected static final String VERSION_1 = "__version__1";
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.birt.report.engine.data.dte.AbstractDataEngine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.report.engine.data.IDataEngine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
    }

    public AbstractDataEngine(ExecutionContext context) {
        this.context = context;
        this.adapter = new ModelDteApiAdapter(context, context.getSharedScope());
    }

    public void defineDataSet(DataSetHandle dataSet) {
        try {
            this.adapter.defineDataSet(dataSet, this.dteSession);
        }
        catch (BirtException e) {
            logger.log(Level.SEVERE, e.getMessage());
        }
    }

    public void prepare(Report report, Map appContext) {
        ReportDesignHandle rptHandle = report.getReportDesign();
        List dataSetList = rptHandle.getAllDataSets();
        int i = 0;
        while (i < dataSetList.size()) {
            DataSetHandle dataset = (DataSetHandle)dataSetList.get(i);
            try {
                this.adapter.defineDataSet(dataset, this.dteSession);
            }
            catch (BirtException be) {
                logger.log(Level.SEVERE, be.getMessage(), be);
                this.context.addException((DesignElementHandle)dataset, be);
            }
            ++i;
        }
        List cubeList = rptHandle.getAllCubes();
        int i2 = 0;
        while (i2 < cubeList.size()) {
            CubeHandle cube = (CubeHandle)cubeList.get(i2);
            if (cube.clientsIterator().hasNext()) {
                try {
                    this.dteSession.defineCube(cube);
                }
                catch (BirtException be) {
                    logger.log(Level.SEVERE, be.getMessage(), be);
                    this.context.addException((DesignElementHandle)cube, be);
                }
            }
            ++i2;
        }
        new ReportQueryBuilder(report, this.context).build();
        this.doPrepareQuery(report, appContext);
    }

    protected abstract void doPrepareQuery(Report var1, Map var2);

    public IBaseResultSet execute(IDataQueryDefinition query) {
        return this.execute(null, query, false);
    }

    public IBaseResultSet execute(IBaseResultSet parent, IDataQueryDefinition query, boolean useCache) {
        if (query instanceof ISubqueryDefinition) {
            if (parent == null) {
                return null;
            }
            if (parent instanceof ICubeResultSet) {
                this.context.addException(new EngineException("Incorrect parent resultSet for subQuery:" + ((ISubqueryDefinition)query).getName()));
            }
            return this.doExecuteSubQuery((QueryResultSet)parent, query);
        }
        if (query instanceof IQueryDefinition || query instanceof ICubeQueryDefinition) {
            return this.doExecuteQuery(parent, query, useCache);
        }
        return null;
    }

    protected abstract IBaseResultSet doExecuteQuery(IBaseResultSet var1, IDataQueryDefinition var2, boolean var3);

    protected IBaseResultSet doExecuteSubQuery(QueryResultSet parent, IDataQueryDefinition query) {
        if (!$assertionsDisabled && !(query instanceof ISubqueryDefinition)) {
            throw new AssertionError();
        }
        try {
            ISubqueryDefinition subQuery = (ISubqueryDefinition)query;
            String subQueryName = subQuery.getName();
            IResultIterator parentRI = parent.getResultIterator();
            IResultIterator ri = parentRI.getSecondaryIterator(subQueryName, this.context.getSharedScope());
            if (!$assertionsDisabled && ri == null) {
                throw new AssertionError();
            }
            QueryResultSet resultSet = new QueryResultSet(parent, subQuery, ri);
            return resultSet;
        }
        catch (BirtException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            this.context.addException(e);
            return null;
        }
    }

    public void close(IBaseResultSet rs) {
    }

    public void shutdown() {
        this.dteSession.shutdown();
    }

    public Object evaluate(IBaseExpression expr) {
        if (expr == null) {
            return null;
        }
        if (expr instanceof IScriptExpression) {
            return this.context.evaluate(((IScriptExpression)expr).getText());
        }
        if (expr instanceof IConditionalExpression) {
            return this.context.evaluateCondExpr((IConditionalExpression)expr);
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public Object evaluate(String expr) {
        return this.context.evaluate(expr);
    }

    public DataRequestSession getDTESession() {
        return this.dteSession;
    }

    protected String getTempDir(ExecutionContext context) {
        EngineConfig config;
        IReportEngine engine = context.getEngine();
        if (engine != null && (config = engine.getConfig()) != null) {
            return config.getTempDir();
        }
        return null;
    }

    protected IBaseQueryResults getCachedQueryResult(IDataQueryDefinition query) throws BirtException {
        String rsetId = String.valueOf(this.cachedQueryIdMap.get(query));
        return this.dteSession.getQueryResults(rsetId);
    }
}

