/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data.dte;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBasePreparedQuery;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.olap.api.ICubeQueryResults;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.engine.data.dte.AbstractDataEngine;
import org.eclipse.birt.report.engine.data.dte.CubeResultSet;
import org.eclipse.birt.report.engine.data.dte.DteMetaInfoIOUtil;
import org.eclipse.birt.report.engine.data.dte.QueryResultSet;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.ICubeResultSet;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;
import org.eclipse.birt.report.engine.ir.Report;
import org.mozilla.javascript.Scriptable;

public class DataGenerationEngine
extends AbstractDataEngine {
    protected HashMap queryMap = new HashMap();
    private DataOutputStream dos;

    public DataGenerationEngine(ExecutionContext context, IDocArchiveWriter writer) throws Exception {
        super(context);
        DataSessionContext dteSessionContext = new DataSessionContext(1, null, context.getSharedScope());
        dteSessionContext.setDocumentWriter(writer);
        DataEngineContext dteEngineContext = dteSessionContext.getDataEngineContext();
        dteEngineContext.setLocale(context.getLocale());
        String tempDir = this.getTempDir(context);
        if (tempDir != null) {
            dteEngineContext.setTmpdir(tempDir);
        }
        this.dteSession = DataRequestSession.newSession((DataSessionContext)dteSessionContext);
        this.dos = new DataOutputStream((OutputStream)writer.createRandomAccessStream("/Data/hierarchy"));
        DteMetaInfoIOUtil.startMetaInfo(this.dos);
    }

    protected void doPrepareQuery(Report report, Map appContext) {
        this.appContext = appContext;
        this.queryIDMap.putAll(report.getQueryIDs());
        int i = 0;
        while (i < report.getQueries().size()) {
            IDataQueryDefinition queryDef = (IDataQueryDefinition)report.getQueries().get(i);
            try {
                IBasePreparedQuery preparedQuery = this.dteSession.prepare(queryDef, appContext);
                this.queryMap.put(queryDef, preparedQuery);
            }
            catch (BirtException be) {
                logger.log(Level.SEVERE, be.getMessage());
                this.context.addException(be);
            }
            ++i;
        }
    }

    protected IBaseResultSet doExecuteQuery(IBaseResultSet resultSet, IDataQueryDefinition query, boolean useCache) {
        if (query instanceof IQueryDefinition) {
            return this.doExecuteQuery(resultSet, (IQueryDefinition)query, useCache);
        }
        if (query instanceof ICubeQueryDefinition) {
            return this.doExecuteCube(resultSet, (ICubeQueryDefinition)query, useCache);
        }
        return null;
    }

    protected IQueryResultSet doExecuteQuery(IBaseResultSet resultSet, IQueryDefinition query, boolean useCache) {
        IBasePreparedQuery pQuery = (IBasePreparedQuery)this.queryMap.get(query);
        if (pQuery == null) {
            return null;
        }
        try {
            String queryID = (String)this.queryIDMap.get(query);
            Scriptable scope = this.context.getSharedScope();
            String pRsetId = null;
            String rowId = "-1";
            IBaseQueryResults dteResults = null;
            QueryResultSet curRSet = null;
            if (resultSet == null) {
                if (useCache) {
                    dteResults = this.getCachedQueryResult((IDataQueryDefinition)query);
                }
                if (dteResults == null) {
                    dteResults = this.dteSession.execute(pQuery, null, scope);
                    if (query.cacheQueryResults()) {
                        this.cachedQueryIdMap.put(query, dteResults.getID());
                    }
                }
                curRSet = new QueryResultSet(this, this.context, query, (IQueryResults)dteResults);
            } else {
                pRsetId = resultSet.getQueryResults().getID();
                rowId = resultSet.getRawID();
                if (useCache) {
                    dteResults = this.getCachedQueryResult((IDataQueryDefinition)query);
                }
                if (dteResults == null) {
                    dteResults = this.dteSession.execute(pQuery, resultSet.getQueryResults(), scope);
                    if (query.cacheQueryResults()) {
                        this.cachedQueryIdMap.put(query, dteResults.getID());
                    }
                }
                curRSet = new QueryResultSet(this, this.context, resultSet, query, (IQueryResults)dteResults);
            }
            this.storeDteMetaInfo(pRsetId, rowId, queryID, dteResults.getID());
            return curRSet;
        }
        catch (BirtException be) {
            logger.log(Level.SEVERE, be.getMessage());
            this.context.addException(be);
            return null;
        }
    }

    protected ICubeResultSet doExecuteCube(IBaseResultSet resultSet, ICubeQueryDefinition query, boolean useCache) {
        if (useCache) {
            String rsetId = String.valueOf(this.cachedQueryIdMap.get(query));
            query.setQueryResultsID(rsetId);
        } else {
            query.setQueryResultsID(null);
        }
        IBasePreparedQuery pQuery = null;
        try {
            pQuery = this.dteSession.prepare((IDataQueryDefinition)query, this.appContext);
        }
        catch (BirtException be) {
            logger.log(Level.SEVERE, be.getMessage());
            this.context.addException(be);
        }
        if (pQuery == null) {
            return null;
        }
        try {
            IBaseQueryResults dteResults;
            String queryID = (String)this.queryIDMap.get(query);
            Scriptable scope = this.context.getSharedScope();
            String pRsetId = null;
            String rowId = "-1";
            CubeResultSet curRSet = null;
            if (resultSet == null) {
                dteResults = this.dteSession.execute(pQuery, null, scope);
                curRSet = new CubeResultSet(this, this.context, query, (ICubeQueryResults)dteResults);
            } else {
                pRsetId = resultSet.getQueryResults().getID();
                rowId = resultSet.getRawID();
                dteResults = this.dteSession.execute(pQuery, resultSet.getQueryResults(), scope);
                curRSet = new CubeResultSet(this, this.context, resultSet, query, (ICubeQueryResults)dteResults);
            }
            this.storeDteMetaInfo(pRsetId, rowId, queryID, dteResults.getID());
            if (query.cacheQueryResults()) {
                this.cachedQueryIdMap.put(query, dteResults.getID());
            }
            return curRSet;
        }
        catch (BirtException be) {
            logger.log(Level.SEVERE, be.getMessage());
            this.context.addException(be);
            return null;
        }
    }

    public void shutdown() {
        if (this.dos != null) {
            try {
                this.dos.close();
            }
            catch (IOException iOException) {}
            this.dos = null;
        }
        this.dteSession.shutdown();
    }

    private void storeDteMetaInfo(String pRsetId, String rowId, String queryId, String rsetId) {
        try {
            if (this.context.isExecutingMasterPage() && pRsetId == null) {
                rowId = String.valueOf(this.context.getPageNumber());
            }
            DteMetaInfoIOUtil.storeMetaInfo(this.dos, pRsetId, rowId, queryId, rsetId);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage());
            e.printStackTrace();
        }
    }
}

