/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.report.engine.api.DataID;
import org.eclipse.birt.report.engine.api.DataSetID;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.impl.Column;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.ICubeResultSet;
import org.eclipse.birt.report.engine.extension.IExecutorContext;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.ir.ActionDesign;
import org.eclipse.birt.report.engine.ir.ColumnDesign;
import org.eclipse.birt.report.engine.ir.DrillThroughActionDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportElementDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.VisibilityDesign;
import org.eclipse.birt.report.engine.ir.VisibilityRuleDesign;
import org.eclipse.birt.report.engine.script.internal.OnCreateScriptVisitor;
import org.eclipse.birt.report.engine.toc.TOCBuilder;
import org.eclipse.birt.report.engine.toc.TOCEntry;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;

public abstract class ReportItemExecutor
implements IReportItemExecutor {
    protected static Logger logger;
    protected ExecutorManager manager;
    protected int type;
    protected IReportContent report;
    protected ExecutionContext context;
    protected ReportItemDesign design;
    protected IContent content;
    protected IQueryResultSet rset;
    protected TOCEntry tocEntry;
    protected OnCreateScriptVisitor onCreateVisitor;
    protected IExecutorContext executorContext;
    protected Object handle;
    protected ReportItemExecutor parent;
    protected long uniqueId;
    protected InstanceID instanceId;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.executor.ReportItemExecutor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.report.engine.executor.ReportItemExecutor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
    }

    protected ReportItemExecutor(ExecutorManager manager, int type) {
        this.manager = manager;
        this.type = type;
        this.context = manager.context;
        this.report = this.context.getReportContent();
        this.onCreateVisitor = new OnCreateScriptVisitor(this.context);
        this.executorContext = null;
        this.parent = null;
        this.handle = null;
        this.design = null;
        this.content = null;
        this.rset = null;
        this.tocEntry = null;
        this.uniqueId = 0L;
        this.instanceId = null;
    }

    public void setContext(IExecutorContext context) {
        this.executorContext = context;
    }

    public void setModelObject(Object handle) {
        this.handle = handle;
        if (handle instanceof ReportItemDesign) {
            this.design = (ReportItemDesign)handle;
        }
        if (handle instanceof ReportElementHandle) {
            ReportElementHandle element = (ReportElementHandle)handle;
            Report report = this.context.getReport();
            this.design = report.findDesign(element);
        }
    }

    public void setParent(IReportItemExecutor parent) {
        if (!$assertionsDisabled && !(parent instanceof ReportItemExecutor)) {
            throw new AssertionError();
        }
        this.parent = (ReportItemExecutor)parent;
    }

    public IExecutorContext getContext() {
        return this.manager.getExecutorContext();
    }

    public Object getModelObject() {
        return this.handle;
    }

    public IReportItemExecutor getParent() {
        return this.parent;
    }

    public boolean hasNextChild() {
        return false;
    }

    public IReportItemExecutor getNextChild() {
        return null;
    }

    public void close() {
        this.executorContext = null;
        this.parent = null;
        this.handle = null;
        this.content = null;
        this.rset = null;
        this.tocEntry = null;
        this.uniqueId = 0L;
        this.instanceId = null;
        this.design = null;
        this.manager.releaseExecutor(this.type, this);
    }

    IContent getParentContent() {
        if (this.parent != null) {
            return this.parent.getContent();
        }
        return null;
    }

    ReportItemDesign getDesign() {
        return this.design;
    }

    public IContent getContent() {
        return this.content;
    }

    void setContent(IContent content) {
        this.context.setContent(content);
        this.content = content;
    }

    Object evaluate(String expr) {
        return this.context.evaluate(expr);
    }

    Object evaluate(IConditionalExpression expr) {
        return this.context.evaluateCondExpr(expr);
    }

    protected void processBookmark(ReportItemDesign item, IContent itemContent) {
        Object tmp;
        String toc;
        Object tmp2;
        String bookmark = item.getBookmark();
        if (bookmark != null && (tmp2 = this.evaluate(bookmark)) != null && !tmp2.equals("")) {
            itemContent.setBookmark(tmp2.toString());
        }
        if ((toc = item.getTOC()) != null && (tmp = this.evaluate(toc)) != null) {
            itemContent.setTOC(tmp);
        }
    }

    protected void processAction(ReportItemDesign item, IContent itemContent) {
        if (!$assertionsDisabled && itemContent == null) {
            throw new AssertionError();
        }
        ActionDesign action = item.getAction();
        if (action != null) {
            switch (action.getActionType()) {
                case 1: {
                    if (!$assertionsDisabled && action.getHyperlink() == null) {
                        throw new AssertionError();
                    }
                    Object value = this.evaluate(action.getHyperlink());
                    if (value == null) break;
                    IHyperlinkAction obj = this.report.createActionContent();
                    obj.setHyperlink(value.toString(), action.getTargetWindow());
                    itemContent.setHyperlinkAction(obj);
                    break;
                }
                case 2: {
                    if (!$assertionsDisabled && action.getBookmark() == null) {
                        throw new AssertionError();
                    }
                    Object value = this.evaluate(action.getBookmark());
                    if (value == null || value.equals("")) break;
                    IHyperlinkAction obj = this.report.createActionContent();
                    obj.setBookmark(value.toString());
                    itemContent.setHyperlinkAction(obj);
                    break;
                }
                case 3: {
                    Object value;
                    if (!$assertionsDisabled && action.getDrillThrough() == null) {
                        throw new AssertionError();
                    }
                    DrillThroughActionDesign drill = action.getDrillThrough();
                    String bookmark = null;
                    String bookmarkExpr = drill.getBookmark();
                    if (bookmarkExpr != null && (value = this.evaluate(drill.getBookmark())) != null) {
                        bookmark = value.toString();
                    }
                    boolean isBookmark = drill.isBookmark();
                    HashMap paramsVal = new HashMap();
                    Map params = drill.getParameters();
                    if (params != null) {
                        Iterator paramsDesignIte = params.entrySet().iterator();
                        while (paramsDesignIte.hasNext()) {
                            Map.Entry entry = paramsDesignIte.next();
                            Object valueObj = entry.getValue();
                            Object paramValue = null;
                            if (valueObj != null) {
                                String valueExpr = valueObj.toString();
                                paramValue = this.evaluate(valueExpr);
                            }
                            paramsVal.put(entry.getKey(), paramValue);
                        }
                    }
                    String reportName = drill.getReportName();
                    String format = drill.getFormat();
                    IHyperlinkAction obj = this.report.createActionContent();
                    obj.setDrillThrough(bookmark, isBookmark, reportName, paramsVal, null, action.getTargetWindow(), format, action.getTargetFileType());
                    itemContent.setHyperlinkAction(obj);
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }
    }

    protected void processVisibility(ReportItemDesign design, IContent content) {
        VisibilityDesign visibility = design.getVisibility();
        if (visibility != null) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < visibility.count()) {
                VisibilityRuleDesign rule = visibility.getRule(i);
                String expr = rule.getExpression();
                Object result = null;
                if (expr != null) {
                    result = this.evaluate(expr);
                }
                if (result == null || !(result instanceof Boolean)) {
                    this.context.addException(new EngineException("The following visibility expression does not evaluate to a legal boolean value: {0}", rule.getExpression()));
                } else {
                    boolean isHidden = (Boolean)result;
                    if (isHidden) {
                        buffer.append(rule.getFormat());
                        buffer.append(",");
                    }
                }
                ++i;
            }
            if (buffer.length() != 0) {
                buffer.setLength(buffer.length() - 1);
                content.getStyle().setVisibleFormat(buffer.toString());
            }
        }
    }

    protected void processColumnVisibility(ColumnDesign design, Column column) {
        VisibilityDesign visibility = design.getVisibility();
        if (visibility != null) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < visibility.count()) {
                VisibilityRuleDesign rule = visibility.getRule(i);
                String expr = rule.getExpression();
                Object result = null;
                if (expr != null) {
                    result = this.evaluate(expr);
                }
                if (result == null || !(result instanceof Boolean)) {
                    this.context.addException(new EngineException("The following visibility expression does not evaluate to a legal boolean value: {0}", rule.getExpression()));
                } else {
                    boolean isHidden = (Boolean)result;
                    if (isHidden) {
                        buffer.append(rule.getFormat());
                        buffer.append(",");
                    }
                }
                ++i;
            }
            if (buffer.length() != 0) {
                buffer.setLength(buffer.length() - 1);
                column.setVisibleFormat(buffer.toString());
            }
        }
    }

    protected DataID getDataID() {
        IBaseResultSet[] rsets;
        if (this.parent != null && (rsets = this.parent.getQueryResults()) != null && rsets.length > 0 && rsets[0] != null) {
            if (rsets[0] instanceof IQueryResultSet) {
                IQueryResultSet rset = (IQueryResultSet)rsets[0];
                DataSetID dataSetID = rset.getID();
                long position = rset.getRowIndex();
                return new DataID(dataSetID, position);
            }
            if (rsets[0] instanceof ICubeResultSet) {
                ICubeResultSet rset = (ICubeResultSet)rsets[0];
                DataSetID dataSetID = rset.getID();
                String cellId = rset.getCellIndex();
                return new DataID(dataSetID, cellId);
            }
        }
        return null;
    }

    protected long generateUniqueID() {
        if (this.parent != null) {
            return this.parent.uniqueId++;
        }
        return this.manager.generateUniqueID();
    }

    protected long getElementId() {
        if (this.design != null) {
            return this.design.getID();
        }
        if (this.handle != null && this.handle instanceof DesignElementHandle) {
            return ((DesignElementHandle)this.handle).getID();
        }
        return -1L;
    }

    protected InstanceID getInstanceID() {
        if (this.instanceId == null) {
            InstanceID pid = this.parent == null ? null : this.parent.getInstanceID();
            long uid = this.generateUniqueID();
            long id = this.getElementId();
            DataID dataId = this.getDataID();
            this.instanceId = new InstanceID(pid, uid, id, dataId);
        }
        return this.instanceId;
    }

    protected void initializeContent(ReportElementDesign design, IContent content) {
        IContent parent = this.getParentContent();
        if (parent != null) {
            content.setParent(parent);
        }
        InstanceID id = this.getInstanceID();
        content.setInstanceID(id);
        content.setGenerateBy(design);
    }

    TOCEntry getParentTOCEntry() {
        if (this.parent instanceof ReportItemExecutor) {
            ReportItemExecutor parentExecutor = this.parent;
            if (parentExecutor.tocEntry != null) {
                return parentExecutor.tocEntry;
            }
            return parentExecutor.getParentTOCEntry();
        }
        return null;
    }

    protected void startTOCEntry(IContent content) {
        TOCBuilder tocBuilder = this.context.getTOCBuilder();
        if (tocBuilder != null && content != null) {
            TOCEntry parentTOCEntry = this.getParentTOCEntry();
            String hiddenFormats = content.getStyle().getVisibleFormat();
            Object tocValue = content.getTOC();
            if (tocValue != null) {
                long elementId = this.getElementId();
                String bookmark = content.getBookmark();
                this.tocEntry = tocBuilder.startEntry(parentTOCEntry, tocValue, bookmark, hiddenFormats, elementId);
                String tocId = this.tocEntry.getNode().getNodeID();
                if (bookmark == null) {
                    content.setBookmark(tocId);
                }
                return;
            }
            if (hiddenFormats != null) {
                this.tocEntry = tocBuilder.startDummyEntry(parentTOCEntry, hiddenFormats);
            }
        }
    }

    protected void finishTOCEntry() {
        TOCBuilder tocBuilder = this.context.getTOCBuilder();
        if (tocBuilder != null && this.tocEntry != null) {
            tocBuilder.closeEntry(this.tocEntry);
        }
    }

    protected void startGroupTOCEntry(IGroupContent group) {
        TOCBuilder tocBuilder = this.context.getTOCBuilder();
        if (tocBuilder != null) {
            TOCEntry entry = this.getParentTOCEntry();
            String hiddenFormats = group.getStyle().getVisibleFormat();
            long elementId = this.getElementId();
            this.tocEntry = tocBuilder.startGroupEntry(entry, group.getTOC(), group.getBookmark(), hiddenFormats, elementId);
            String tocId = this.tocEntry.getNode().getNodeID();
            if (group.getBookmark() == null) {
                group.setBookmark(tocId);
            }
        }
    }

    protected void finishGroupTOCEntry() {
        TOCBuilder tocBuilder = this.context.getTOCBuilder();
        if (tocBuilder != null) {
            tocBuilder.closeGroupEntry(this.tocEntry);
        }
    }

    void setResultSet(IQueryResultSet rset) {
        this.rset = rset;
    }

    IQueryResultSet getResultSet() {
        return this.rset;
    }

    public IBaseResultSet[] getQueryResults() {
        if (this.rset != null) {
            return new IBaseResultSet[]{this.rset};
        }
        return null;
    }

    IBaseResultSet getParentResultSet() {
        IReportItemExecutor pExecutor = this.parent;
        while (pExecutor != null) {
            IBaseResultSet[] rsets = pExecutor.getQueryResults();
            if (rsets != null && rsets.length > 0) {
                return rsets[0];
            }
            pExecutor = pExecutor.getParent();
        }
        return null;
    }

    protected void restoreResultSet() {
        this.context.setResultSet(this.getParentResultSet());
    }

    protected void handleOnCreate(IContent content) {
        if (content.getGenerateBy() != null) {
            this.onCreateVisitor.onCreate(content);
        }
    }
}

