/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html;

import org.eclipse.birt.report.engine.content.IBandContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.layout.ILayoutManager;
import org.eclipse.birt.report.engine.layout.html.HTMLAbstractLM;
import org.eclipse.birt.report.engine.layout.html.HTMLBlockStackingLM;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutManagerFactory;

public class HTMLGroupLM
extends HTMLBlockStackingLM {
    boolean isFirstLayout = true;

    public HTMLGroupLM(HTMLLayoutManagerFactory factory) {
        super(factory);
    }

    public int getType() {
        return 8;
    }

    public void initialize(HTMLAbstractLM parent, IContent content, IReportItemExecutor executor, IContentEmitter emitter) {
        super.initialize(parent, content, executor, emitter);
        this.isFirstLayout = true;
    }

    protected void repeatHeader() {
        if (!this.isFirstLayout) {
            IGroupContent group = (IGroupContent)this.content;
            IBandContent header = group.getHeader();
            if (group.isHeaderRepeat() && header != null) {
                boolean pageBreak = this.context.allowPageBreak();
                boolean isEmpty = this.context.isPageEmpty();
                this.context.setPageEmpty(true);
                this.context.setAllowPageBreak(false);
                this.engine.layout((ILayoutManager)this, header, this.emitter);
                this.context.setAllowPageBreak(pageBreak);
                this.context.setPageEmpty(isEmpty);
                this.context.continueContent(null);
            }
        }
        this.isFirstLayout = false;
    }

    protected boolean layoutChildren() {
        this.repeatHeader();
        boolean hasNext = super.layoutChildren();
        if (hasNext) {
            this.context.addLayoutHint(this.content, !hasNext);
        }
        return hasNext;
    }
}

