/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import org.eclipse.birt.report.engine.content.IBandContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IElement;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.dom.DOMReportItemExecutor;
import org.eclipse.birt.report.engine.layout.IBlockStackingLayoutManager;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.content.ListContainerExecutor;
import org.eclipse.birt.report.engine.layout.pdf.PDFGroupLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFRegionLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;

public class PDFListGroupLM
extends PDFGroupLM
implements IBlockStackingLayoutManager {
    protected boolean needRepeat = false;

    public PDFListGroupLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContent content, IReportItemExecutor executor) {
        super(context, parent, content, executor);
    }

    protected IListBandContent getHeader() {
        return (IListBandContent)((IGroupContent)this.content).getHeader();
    }

    protected IReportItemExecutor createExecutor() {
        return new ListContainerExecutor(this.content, this.executor);
    }

    protected void repeatHeader() {
        if (this.isFirst) {
            return;
        }
        if (!(this.needRepeat && this.isRepeatHeader() && this.isCurrentDetailBand())) {
            return;
        }
        IListBandContent band = this.getHeader();
        if (band == null) {
            return;
        }
        DOMReportItemExecutor headerExecutor = new DOMReportItemExecutor(band);
        headerExecutor.execute();
        ContainerArea headerArea = (ContainerArea)AreaFactory.createLogicContainer(this.content.getReportContent());
        headerArea.setAllocatedWidth(this.parent.getCurrentMaxContentWidth());
        PDFRegionLM regionLM = new PDFRegionLM(this.context, headerArea, (IContent)band, (IReportItemExecutor)headerExecutor);
        boolean allowPB = this.context.allowPageBreak();
        this.context.setAllowPageBreak(false);
        regionLM.layout();
        this.context.setAllowPageBreak(allowPB);
        if (headerArea.getAllocatedHeight() < this.getCurrentMaxContentHeight()) {
            this.addArea(headerArea, false, this.pageBreakAvoid);
            ++this.repeatCount;
        }
        this.needRepeat = false;
    }

    protected void createRoot() {
        if (this.root == null) {
            this.root = (ContainerArea)AreaFactory.createBlockContainer(this.content);
        }
    }

    protected void initialize() {
        if (this.root == null && this.keepWithCache.isEmpty() && !this.isFirst) {
            this.repeatCount = 0;
            this.needRepeat = true;
        }
        super.initialize();
    }

    protected boolean isCurrentDetailBand() {
        if (this.child != null) {
            IContent c = this.child.getContent();
            if (c != null) {
                IBandContent band;
                if (c instanceof IGroupContent) {
                    return true;
                }
                IElement p = c.getParent();
                if (p instanceof IBandContent && (band = (IBandContent)p).getBandType() == 0) {
                    return true;
                }
            }
        } else {
            return true;
        }
        return false;
    }
}

