/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import org.eclipse.birt.report.engine.api.script.eventhandler.IDynamicTextEventHandler;
import org.eclipse.birt.report.engine.api.script.instance.IDynamicTextInstance;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.element.DynamicText;
import org.eclipse.birt.report.engine.script.internal.instance.DynamicTextInstance;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.TextDataHandle;

public class DynamicTextScriptExecutor
extends ScriptExecutor {
    static /* synthetic */ Class class$0;

    public static void handleOnPrepare(TextDataHandle textDataHandle, ExecutionContext context) {
        try {
            DynamicText text = new DynamicText(textDataHandle);
            IDynamicTextEventHandler eh = DynamicTextScriptExecutor.getEventHandler(textDataHandle, context);
            if (eh != null) {
                eh.onPrepare(text, context.getReportContext());
            }
        }
        catch (Exception e) {
            DynamicTextScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnCreate(IContent content, ExecutionContext context) {
        try {
            ReportItemDesign textItemDesign = (ReportItemDesign)content.getGenerateBy();
            IDynamicTextInstance text = DynamicTextScriptExecutor.createDynamicTextInstance(content, context);
            if (DynamicTextScriptExecutor.handleJS(text, textItemDesign.getOnCreate(), context).didRun()) {
                return;
            }
            IDynamicTextEventHandler eh = DynamicTextScriptExecutor.getEventHandler(textItemDesign, context);
            if (eh != null) {
                eh.onCreate(text, context.getReportContext());
            }
        }
        catch (Exception e) {
            DynamicTextScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnRender(IContent content, ExecutionContext context) {
        try {
            ReportItemDesign textItemDesign = (ReportItemDesign)content.getGenerateBy();
            IDynamicTextInstance text = DynamicTextScriptExecutor.createDynamicTextInstance(content, context);
            if (DynamicTextScriptExecutor.handleJS(text, textItemDesign.getOnRender(), context).didRun()) {
                return;
            }
            IDynamicTextEventHandler eh = DynamicTextScriptExecutor.getEventHandler(textItemDesign, context);
            if (eh != null) {
                eh.onRender(text, context.getReportContext());
            }
        }
        catch (Exception e) {
            DynamicTextScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnPageBreak(IContent content, ExecutionContext context) {
        try {
            ReportItemDesign textItemDesign = (ReportItemDesign)content.getGenerateBy();
            IDynamicTextInstance text = DynamicTextScriptExecutor.createDynamicTextInstance(content, context);
            if (DynamicTextScriptExecutor.handleJS(text, textItemDesign.getOnPageBreak(), context).didRun()) {
                return;
            }
            IDynamicTextEventHandler eh = DynamicTextScriptExecutor.getEventHandler(textItemDesign, context);
            if (eh != null) {
                eh.onPageBreak(text, context.getReportContext());
            }
        }
        catch (Exception e) {
            DynamicTextScriptExecutor.addException(context, e);
        }
    }

    private static IDynamicTextInstance createDynamicTextInstance(IContent content, ExecutionContext context) {
        return new DynamicTextInstance(content, context);
    }

    private static IDynamicTextEventHandler getEventHandler(ReportItemDesign design, ExecutionContext context) {
        TextDataHandle handle = (TextDataHandle)design.getHandle();
        if (handle == null) {
            return null;
        }
        return DynamicTextScriptExecutor.getEventHandler(handle, context);
    }

    private static IDynamicTextEventHandler getEventHandler(TextDataHandle handle, ExecutionContext context) {
        IDynamicTextEventHandler eh = null;
        try {
            eh = (IDynamicTextEventHandler)DynamicTextScriptExecutor.getInstance((DesignElementHandle)handle, context);
        }
        catch (ClassCastException e) {
            String string = handle.getEventHandlerClass();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.api.script.eventhandler.IDynamicTextEventHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            DynamicTextScriptExecutor.addClassCastException(context, e, string, clazz);
        }
        return eh;
    }
}

