/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("org.eclipse.cosmos.provisional.dr.ps.components.widget.PropertiesContainer");
dojo.require("dijit.layout.ContentPane");
dojo.require("dijit.TitlePane");
dojo.require("dojox.grid.Grid");
dojo.require("dojox.grid._data.model");


dojo.declare(
	// class
	"org.eclipse.cosmos.provisional.dr.ps.components.widget.SimplePropertiesTable",
	// superclass	
	[dojox.Grid],
	
	// member variables/functions
	{
		widgetClass:'cosmos:SimplePropertiesTable',
		create: function(params, srcNodeRef) {
			//need to delay creation 
			var queryHandler = null;
			var initParam = null;
			//lets check if the contextMap has any query handlers
			if (((typeof(params.contextMap)) != 'undefined') && (params.contextMap != null)){
				initParam = params.dataMap[params.contextMap.nodeClass];
				if ((initParam) && ((typeof(initParam['queryHandler']))!='undefined')){
			    	queryHandler = params.UIContext.createObject(initParam['queryHandler']);					
				}
				else{			
					//classes can contain multiple tags
					var nodeClasses = params.contextMap.nodeClass.split(" ");
					//check the first tag since this is the tag that will contain where the data came from
						initParam = params.dataMap[nodeClasses[0]];
						dojo.mixin(params, initParam);
						if ((initParam) && ((typeof(initParam['queryHandler']))!='undefined')){
					    	queryHandler = params.UIContext.createObject(initParam['queryHandler']);					
						}
				}
				//if the contextMap has a store use that... should try to add query object to get it from the store
				if (typeof(params.contextMap.store) != 'undefined'){
					this.model=new dojox.grid.data.Table(null, params.contextMap.store);														
					return org.eclipse.cosmos.provisional.dr.ps.components.widget.SimplePropertiesTable.superclass.create.apply(this, arguments);
				}
			}
			if (queryHandler == null){
				if (params.initQueryHandler != null)
					queryHandler=new org.eclipse.cosmos.provisional.dr.ps.components.utility.BasicQuery({queryHandler: params.initQueryHandler});
			}

			if (queryHandler != null){
				var self = this;
				var funcArgs = arguments;
				//maybe tagged context data contains configuration options for this widget
				if (initParam != null)
					dojo.mixin(funcArgs[0], initParam);
				params.UIContext.submitQuery({queryObject:queryHandler, item:params.contextMap,
											onItem: function(data){
														self.model=new dojox.grid.data.Table(null, data);														
														org.eclipse.cosmos.provisional.dr.ps.components.widget.SimplePropertiesTable.superclass.create.apply(self, funcArgs);
				  									}
										  }); 
				
			}
		}
	}
);

dojo.declare(
	// class
	"org.eclipse.cosmos.provisional.dr.ps.components.widget.PropertiesContainer",
	// superclass	
	[org.eclipse.cosmos.provisional.dr.ps.components.widget.SimplePropertiesTable],
	
	// member variables/functions
	{
		widgetClass:'cosmos:PropertiesContainer',
	    createContainerWidget:function(data, parent, containerId, indent){
			for (var i=0;i < data.length;i++){
				var div = document.createElement("div");			
				parent.appendChild(div);
				if ((typeof(this.UIContext) != "undefined") && (typeof(data[i].value)!="undefined")){
					var styleProp = this.UIContext.getStyleProperties(data[i].value.type);
				}
				if ((typeof(styleProp) != 'undefined') && (styleProp.clazz)){		
						div = document.createElement("div");			
						this.containerNode.appendChild(div);
						try{
							var containerNode = this.containerNode;
							if (!(this.UIContext.createWidget(data[i], data[i].value, function(widget){
									if (widget == null){
										continerNode.removeChild(div);							
									}
								}, div))){
								customWidget = null;
							}				
						}catch(e){
							customWidget = null;
							this.containerNode.removeChild(div);
						}
					}
				else{
					//render title pane drop down properties table					
					var properties = data[i].properties;
					if (typeof(data[i].properties) != 'undefined'){
						var propTable = document.createElement("table");
						div.appendChild(propTable);
						this.containers.push(new org.eclipse.cosmos.provisional.dr.ps.components.widget.Property({store: data[i].properties, indent:((indent+1)*20)}, propTable));
					}
					var lc = new dijit.TitlePane({indent:(indent*20),open:false, sizeMin:33, sizeShare:33, title:data[i].name, labelNodeClass:this.tableLabelNodeClass, containerNodeClass:"tpcontent"}, div);
					this.containers.push(lc);
					if (typeof(data[i].childProperties) != 'undefined')					
						this.createContainerWidget(data[i].childProperties, lc.containerNode, containerId+i+"_n_", indent+1);
					//to do render simple table
				}
			}	    
	    }
	}
);

dojo.declare("org.eclipse.cosmos.provisional.dr.ps.components.widget.Property", 
	[dijit._Widget, dijit._Templated, dijit._Container], 
	{
    indent: 0,
	templateString:"<div dojoAttachPoint=\"propertyNode\" class=\"cosmosProperty\"></div>", 
	templateCssString:".cosmosProperty {font-size:0.8em;padding:2px;border:1px solid #ccc;	background: #ccc;margin-left:${this.indent}px}\n", 
	templateCssPath:dojo.moduleUrl("org.eclipse.cosmos.provisional.dr.ps.components.widget", "templates/PropertyTemplate.css"),
	store:[],  
	postCreate:function () {
		if (this.store instanceof dojo.data.ItemFileWriteStore){
			this.store = this.store._jsonData;
		}
	    if (this.store){	        
			for (i=0;i < this.store.length;i++){
				p = document.createElement("div");	
				this.propertyNode.appendChild(p);
				p.appendChild(document.createTextNode(this.store[i].name+" : "+this.store[i].value));
			}
		}
	
		if (this.propertyNodeClass) {
			dojo.html.addClass(this.propertyNode, this.propertyNodeClass);
		}
		
	}
}
);