/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryRelItemTree");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.widget.Navigator");


dojo.declare(
	// class
	"org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryRelItemTree",

	// superclass	
	[org.eclipse.cosmos.provisional.dr.ps.components.widget.Navigator],
	
	// member variables/functions
	{
		singleClickEdit: true,
	    contextMenuFactory: null,
		create: function(params, srcNodeRef) {
			if ((params.contextMap) && (params.contextMap.menuFactory)){
				params.menuFactory = params.contextMap.menuFactory;														
			}
			if ((params.contextMap) && (params.contextMap.store)){
				params.store =  params.contextMap.store[0];
				params.store.UIContext = params.UIContext;														
				org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryRelItemTree.superclass.create.apply(this, arguments);
			}
			else{
					org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryRelItemTree.superclass.create.apply(this, arguments);
			}
		},	    
		postCreate: function(){
			org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryRelItemTree.superclass.postCreate.apply(this, arguments);
			this.contextMenuFactory = new org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryRelItemTreeMenu();
			this.contextMenuFactory.store = this.menuFactory;
		},
		deleteTreeNode:function(treeNode){
			org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryRelItemTree.superclass.deleteTreeNode.apply(this, arguments);
			//need to publish that the node was deleted
			for (var i=0;i < this.publish.length;i++){
		 	    //lets clone the information we're going to send to another widget since we don't want the other
		 	    //widget modifying our content
				var cloneMap = new Object();
		 	    dojo.mixin(cloneMap,treeNode.item);
		 	    //let tag the data we're going to send so that the consumer of this data knows where the data came from
		 	    cloneMap.nodeClass = this.attachPoint + " nodedeleted" ;
				dojo.publish(this.publish[i], [{contextMap:cloneMap}]);
			}
			
		},				
		createContextMenu: function(e){
			var menu = this.menu;
			this.menu.getChildren().forEach(function(i){menu.removeChild(i);});
			var tn = dijit.getEnclosingWidget(e.target);
			this.contextMenuFactory.sourceObject=this;		
			this.contextMenuFactory.UIContext = this.UIContext;		
			this.contextMenuFactory.createContextMenu(this.menu,tn,tn.item.nodeClass);
			this.contextMenuFactory.nodeFactory = this.contextMap.nodeFactory;
			
		}
	}
	
);	


dojo.declare(
		   "org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryRelItemTreeMenu",
			// superclass	
			org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryMenu,
			{
				widgetClass:'cosmos:QueryRelItemTreeMenu',
				builder: null,
				factory: null,
				addTreeNode:function(store, nodeClass, parentClass, childMenuItem){
			   		var _self = this;
			   		this.nodeFactory.createNode(nodeClass, parentClass,function(node, childrenNodes){
				   		var parentObj = store.tree.addTreeNode(node, store.item);
						if  (childrenNodes){
							for (var z = 0 ; z < childrenNodes.length; z++){
				   				store.tree.addTreeNode(childrenNodes[z], parentObj);
							}
						}
			   		});
		   		},
				createContextMenu:function(menu, store, className){
			   var queryValue = store.item.nodeClass;
			   if (dojo.isArray(store.item.nodeClass)){
				   queryValue = store.item.nodeClass[0];
			   }
			   		var _self = this;			
					this.store.fetch({
						   query: {nodeClass: queryValue},
						   queryOptions:{deep:true},
						   onComplete:function(items, request){
							   if (items.length > 0){
								   //there should only be one item in the menu store
								   if ((items[0].children) && (items[0].children.length >0)){
									   for (var i = 0; i < items[0].children.length; i++){
										   var childMenuItem = items[0].children[i];
										   if ((childMenuItem.nodeClass == 'delete') || (childMenuItem.nodeClass == 'reldelete')){
												menu.addChild(new dijit.MenuItem({onClick:function(){
													store.tree.deleteTreeNode(store.item);
												},
												label:childMenuItem.title +" "+queryValue
												}));											   
										   }
										   else{
											   if (childMenuItem.menuRules){
													store.tree.store.fetch({
														query: {object:queryValue+"*"},
														queryOptions:{deep:true},
													   onComplete:function(items, request){
															   if (items.length == 0){
																	menu.addChild(new dijit.MenuItem({childMenuItem:childMenuItem, onClick:function(){
																		_self.addTreeNode(store, this.childMenuItem.nodeClass, queryValue, this.childMenuItem);
																	},
																	label:childMenuItem.title
																	}));
															   }
															   else{
																   var found = false
																   for (var y = 0; y < items.length; y++){
																	   for (var x = 0; x < childMenuItem.menuRules.length; x++){
																		   if (items[y].nodeClass == childMenuItem.menuRules[x]){
																			   found = true;
																		   }
																	   }
																   }
																   if (!found){
																		menu.addChild(new dijit.MenuItem({childMenuItem:childMenuItem, onClick:function(){
																			_self.addTreeNode(store, this.childMenuItem.nodeClass, queryValue, this.childMenuItem);
																		},
																		label:childMenuItem.title
																		}));
																   }
															   }
														}
													});														
											   }
											   else{
													menu.addChild(new dijit.MenuItem({childMenuItem:childMenuItem, onClick:function(){
														_self.addTreeNode(store, this.childMenuItem.nodeClass, queryValue, this.childMenuItem);
													},
													label:childMenuItem.title
													}));
											   }
										   }
									   }
								   }
							   }
						   }
						});
			   					   		
				}
			}
		); 




