/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.databuilders;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cosmos.rm.validation.internal.artifacts.ReferenceDescriptor;
import org.eclipse.cosmos.rm.validation.internal.databuilders.AbstractDataBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceExtractor
extends AbstractDataBuilder<List<ReferenceDescriptor>> {
    public static final String ID = "org.eclipse.cosmos.rm.validation.ReferenceExtractor";
    private boolean uriElementHit;
    private StringBuffer currentReference = new StringBuffer();
    private List<ReferenceDescriptor> references;
    private boolean aliasElementHit;
    private StringBuffer currentAlias = new StringBuffer();
    private List<String> aliases;
    private boolean isInstancesPhase = false;
    private int noAliasDocumentPosition = 0;

    public ReferenceExtractor() {
        this.references = new ArrayList<ReferenceDescriptor>();
        this.aliases = new ArrayList<String>();
        super.addEvent(1);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if ("http://www.w3.org/2008/01/sml-if".equals(uri) && "instances".equals(localName)) {
            this.isInstancesPhase = true;
        }
        if ("http://www.w3.org/2008/01/sml-if".equals(uri) && "document".equals(localName)) {
            this.aliases.clear();
        } else if ("http://www.w3.org/2008/01/sml-if".equals(uri) && "alias".equals(localName)) {
            this.aliasElementHit = true;
        } else if ("http://www.w3.org/2008/01/sml".equals(uri) && "uri".equals(localName)) {
            this.uriElementHit = true;
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if ("http://www.w3.org/2008/01/sml-if".equals(uri) && "data".equals(localName)) {
            if (this.isInstancesPhase && this.aliases.size() == 0) {
                ++this.noAliasDocumentPosition;
            }
        } else if (uri != null && "http://www.w3.org/2008/01/sml-if".equals(uri) && "alias".equals(localName)) {
            this.aliasElementHit = false;
            this.aliases.add(this.currentAlias.toString());
            this.currentAlias.setLength(0);
        } else if ("http://www.w3.org/2008/01/sml".equals(uri) && "uri".equals(localName)) {
            this.uriElementHit = false;
            this.references.add(new ReferenceDescriptor(this.getFilePath(), this.locator.getLineNumber(), this.currentReference.toString(), this.aliases, this.aliases.size() > 0 ? 0 : this.noAliasDocumentPosition));
            this.currentReference = new StringBuffer();
        } else if ("http://www.w3.org/2008/01/sml-if".equals(uri) && this.isInstancesPhase && "document".equals(localName)) {
            this.aliases = new ArrayList<String>();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String string;
        if (this.aliasElementHit) {
            string = new String(ch, start, length);
            if (this.currentAlias.length() > 0 && string.charAt(0) == '\n' && string.trim().length() > 0) {
                this.currentAlias.append(' ');
            }
            this.currentAlias.append(string.trim());
        }
        if (this.uriElementHit) {
            string = new String(ch, start, length);
            if (this.currentReference.length() > 0 && string.charAt(0) == '\n' && string.trim().length() > 0) {
                this.currentReference.append(' ');
            }
            this.currentReference.append(string.trim());
        }
    }

    @Override
    public List<ReferenceDescriptor> getDataStructure() {
        return this.references;
    }
}

