/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.reference;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.validation.internal.databuilders.IdentityDataBuilder;
import org.eclipse.cosmos.rm.validation.internal.reference.IReferenceExpression;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIReference
implements IReferenceExpression {
    private static final char[] RESERVED_CHARACTERS = new char[]{'$', '&', '+', ',', '/', ':', ';', '=', '?', '@', '-', '_', '.', '!', '*', '(', ')', '#', '[', ']', '%', '\'', '\\'};
    private URI base;
    private URI reference;
    private String documentReference;
    private boolean transformed;
    private List<String> documentAliases;
    private int documentPosition;

    public URIReference(String reference) throws URISyntaxException {
        if (reference == null) {
            throw new URISyntaxException(null, SMLValidationMessages.errorReferenceNullURI);
        }
        reference = this.trim(reference);
        reference = this.encodeCharacters(reference);
        this.reference = new URI(reference);
    }

    private String encodeCharacters(String uri) {
        if (uri == null) {
            return null;
        }
        char[] uriChars = uri.toCharArray();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < uriChars.length) {
            if (Character.isLetterOrDigit(uriChars[i]) || this.isCharacterReserved(uriChars[i])) {
                buffer.append(uriChars[i]);
            } else {
                buffer.append("%");
                buffer.append(this.convertToHex(uriChars[i] / 16));
                buffer.append(this.convertToHex(uriChars[i] % 16));
            }
            ++i;
        }
        return buffer.toString();
    }

    private char convertToHex(int dec) {
        return dec >= 0 && dec <= 9 ? String.valueOf(dec).toCharArray()[0] : (dec <= 15 ? (char)(65 + (dec - 10)) : (char)dec);
    }

    private int convertToDecimal(char ch) {
        return Character.isDigit(ch) ? Integer.parseInt(String.valueOf(ch)) : (ch >= 'A' && ch <= 'F' ? 10 + (ch - 65) : -1);
    }

    private String decodeCharacters(String uri) {
        int precentInx;
        if (uri == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int cursorInx = 0;
        int uriPartLength = uri.length();
        while (uriPartLength > cursorInx && (precentInx = uri.indexOf(37, cursorInx)) >= 0) {
            buffer.append(uri.substring(cursorInx, precentInx));
            if (uriPartLength > precentInx + 2) {
                char firstDigit = uri.charAt(precentInx + 1);
                char secondDigit = uri.charAt(precentInx + 2);
                int firstDecimalDigit = this.convertToDecimal(firstDigit);
                int secondDecimalDigit = this.convertToDecimal(secondDigit);
                if (firstDecimalDigit >= 0 && secondDecimalDigit >= 0) {
                    buffer.append((char)(firstDecimalDigit * 16 + secondDecimalDigit));
                } else {
                    buffer.append(37 + firstDigit + secondDigit);
                }
            }
            cursorInx = precentInx + 3;
        }
        if (uriPartLength > cursorInx) {
            buffer.append(uri.substring(cursorInx));
        }
        return buffer.toString();
    }

    private boolean isCharacterReserved(char c) {
        int i = 0;
        while (i < RESERVED_CHARACTERS.length) {
            if (c == RESERVED_CHARACTERS[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String trim(String str) {
        str = str.trim();
        str = str.replaceAll("\\n", "");
        str = str.replaceAll("\\r", "");
        return str;
    }

    @Override
    public String getDocumentReference() throws URISyntaxException {
        if (this.documentReference == null) {
            String fragment = this.reference.getFragment();
            String referenceStr = this.reference.toString();
            int fragmentInx = -1;
            if (fragment != null && fragment.length() > 0 && (fragmentInx = referenceStr.indexOf(fragment)) > 0) {
                referenceStr = referenceStr.substring(0, fragmentInx - 1);
            }
            this.documentReference = referenceStr;
            if (!this.isTransformed()) {
                this.transform();
            }
        }
        return this.decodeCharacters(this.documentReference);
    }

    public String getFragment() throws URISyntaxException {
        this.getDocumentReference();
        return this.reference == null ? null : this.decodeCharacters(this.reference.getFragment());
    }

    @Override
    public boolean isTransformed() {
        return this.transformed;
    }

    @Override
    public void transform() throws URISyntaxException {
        String identityBaseURI;
        this.transformed = true;
        if (this.base == null && (identityBaseURI = IdentityDataBuilder.retrieveBaseURI()) != null) {
            this.base = new URI(identityBaseURI);
            if (!this.defined(this.base.getPath())) {
                this.base = this.base.resolve("/");
            }
        }
        if (!this.defined(this.reference.getScheme())) {
            if (this.base == null) {
                return;
            }
            this.documentReference = this.base.resolve(this.reference).toString();
            String fragment = this.reference.getFragment();
            if (fragment != null) {
                this.documentReference = this.documentReference.substring(0, this.documentReference.length() - fragment.length() - 1);
            }
        }
    }

    private boolean defined(String field) {
        return field != null && field.length() > 0;
    }

    public Node retrieveDocumentDOM() throws URISyntaxException, SMLValidatorUtil.RemoteRetrievalException {
        String transformedReference = this.getDocumentReference();
        Map documentsMap = (Map)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.DocumentDOMBuilder");
        if (this.reference.getFragment() != null && this.reference.getPath().length() == 0 && this.reference.getScheme() == null) {
            if (this.documentAliases == null || this.documentAliases.size() == 0) {
                Object noAliasesDocuments = documentsMap.get("no_alias");
                if (noAliasesDocuments != null && noAliasesDocuments instanceof List) {
                    Node node = (Node)((List)noAliasesDocuments).get(this.documentPosition);
                    return node;
                }
            } else {
                Object doc = documentsMap.get(this.documentAliases.get(0));
                if (doc == null) {
                    return null;
                }
                return (Node)doc;
            }
        }
        if (!this.reference.isAbsolute() && (this.base != null && !this.base.isAbsolute() || this.base == null)) {
            return null;
        }
        Object doc = documentsMap.get(transformedReference);
        if (doc != null) {
            return (Node)doc;
        }
        return SMLValidatorUtil.retrieveRemoteDocument(this.documentReference);
    }

    protected URI getReference() {
        return this.reference;
    }

    protected void setReference(URI reference) {
        this.reference = reference;
    }

    protected URI getBase() {
        return this.base;
    }

    protected void setBase(URI base) {
        this.base = base;
    }

    public List<String> getDocumentAliases() {
        return this.documentAliases;
    }

    public void setDocumentAliases(List<String> documentAliases) {
        this.documentAliases = documentAliases;
    }

    public int getDocumentPosition() {
        return this.documentPosition;
    }

    public void setDocumentPosition(int documentPosition) {
        this.documentPosition = documentPosition;
    }
}

