/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.reference;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.validation.internal.reference.AbstractScheme;
import org.eclipse.cosmos.rm.validation.internal.reference.BadExpressionException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPointerScheme
extends AbstractScheme {
    public static final String SCHEME = "xpointer";
    private static XPath xpath;

    @Override
    public Object evaluate(Object context) throws BadExpressionException {
        Object namespaceContext;
        if (xpath == null) {
            XPathFactory factory = XPathFactory.newInstance();
            if (factory == null) {
                throw new BadExpressionException(SMLValidationMessages.errorMissingXPathFactory);
            }
            xpath = factory.newXPath();
            if (xpath == null) {
                throw new BadExpressionException(SMLValidationMessages.errorMissingXPathInstance);
            }
        }
        if ((namespaceContext = SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.NamespaceContextBuilder")) instanceof NamespaceContext) {
            xpath.setNamespaceContext((NamespaceContext)namespaceContext);
        }
        ArrayList<NodeList> listOfNodeList = new ArrayList<NodeList>();
        try {
            XPathExpression xpathExpr;
            String xpathExpStr = this.getExpression();
            if (xpathExpStr != null) {
                xpathExpStr = xpathExpStr.replace('\ufffd', '\'');
            }
            if ((xpathExpr = xpath.compile(xpathExpStr)) == null) {
                throw new BadExpressionException(SMLValidationMessages.errorBadXPathExpression);
            }
            if (context instanceof Node) {
                this.evaluateXPathExpression(xpathExpr, (Node)context, listOfNodeList);
            } else if (context instanceof NodeList[]) {
                NodeList[] contextNodeList = (NodeList[])context;
                int i = 0;
                while (i < contextNodeList.length) {
                    int j = 0;
                    int nodeListCount = contextNodeList[i].getLength();
                    while (j < nodeListCount) {
                        this.evaluateXPathExpression(xpathExpr, contextNodeList[i].item(j), listOfNodeList);
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (XPathExpressionException xe) {
            throw new BadExpressionException(xe);
        }
        return listOfNodeList.toArray(new NodeList[listOfNodeList.size()]);
    }

    private void evaluateXPathExpression(XPathExpression xpathExpr, Node context, List<NodeList> listOfNodeList) throws XPathExpressionException {
        NodeList nodeList = (NodeList)xpathExpr.evaluate(context, XPathConstants.NODESET);
        if (nodeList != null) {
            listOfNodeList.add(nodeList);
        }
    }

    @Override
    public String getType() {
        return SCHEME;
    }
}

