/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.smlvalidators;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cosmos.rm.validation.internal.artifacts.ElementLocation;
import org.eclipse.cosmos.rm.validation.internal.common.AbstractValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.common.SMLIFIdentity;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.validation.internal.core.AbstractSMLValidator;
import org.eclipse.cosmos.rm.validation.internal.databuilders.DataBuilderRegistry;
import org.eclipse.cosmos.rm.validation.internal.databuilders.DocumentDOMBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.IdentityDataBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.RootElementAliasLookupBuilder;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseURIValidator
extends AbstractSMLValidator {
    protected DocumentDOMBuilder documentDOMBuilder;

    @Override
    public void initialize(Map<String, Object> validationAttribute) {
        super.initialize(validationAttribute);
        DataBuilderRegistry databuilderRegistry = DataBuilderRegistry.instance();
        databuilderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.IdentityDataBuilder", new IdentityDataBuilder());
        databuilderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.RootElementAliasLookupBuilder", new RootElementAliasLookupBuilder());
        databuilderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.DocumentDOMBuilder", new DocumentDOMBuilder());
    }

    @Override
    public boolean validate() {
        this.setTaskName(SMLValidationMessages.validationReferences);
        this.documentDOMBuilder = (DocumentDOMBuilder)DataBuilderRegistry.instance().getDataStructureBuilder("org.eclipse.cosmos.rm.validation.DocumentDOMBuilder");
        SMLIFIdentity identity = (SMLIFIdentity)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.IdentityDataBuilder");
        if (identity != null) {
            this.validateBaseURIValue(identity.getBaseURI());
            this.validateAliasesURI(identity.getBaseURI());
        }
        return true;
    }

    private void validateAliasesURI(String baseURI) {
        IValidationOutput<String, Object> output = this.getValidationOutput();
        Map aliases = (Map)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.DocumentDOMBuilder");
        if (aliases != null) {
            Iterator keys = aliases.keySet().iterator();
            ArrayList<URI> list = new ArrayList<URI>(aliases.keySet().size());
            while (keys.hasNext()) {
                String alias = (String)keys.next();
                if (alias.equals("no_alias")) continue;
                try {
                    ElementLocation elementLocation;
                    URI uri = new URI(alias);
                    if (uri.getFragment() != null) {
                        elementLocation = this.documentDOMBuilder.getLocation((Element)aliases.get(alias));
                        output.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(elementLocation.getFilePath(), elementLocation.getLineNumber(), NLS.bind((String)SMLValidationMessages.errorAliasHasFragment, (Object)alias)));
                    }
                    if (!uri.isAbsolute()) {
                        elementLocation = this.documentDOMBuilder.getLocation((Element)aliases.get(alias));
                        output.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(elementLocation.getFilePath(), elementLocation.getLineNumber(), NLS.bind((String)SMLValidationMessages.errorAliasRelative, (Object)alias)));
                    }
                    if (list.contains(uri)) {
                        elementLocation = this.documentDOMBuilder.getLocation((Element)aliases.get(alias));
                        output.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(elementLocation.getFilePath(), elementLocation.getLineNumber(), NLS.bind((String)SMLValidationMessages.errorDuplicateAlias, (Object)alias)));
                        continue;
                    }
                    list.add(uri);
                }
                catch (URISyntaxException uRISyntaxException) {
                    ElementLocation elementLocation = this.documentDOMBuilder.getLocation((Element)aliases.get(alias));
                    output.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(elementLocation.getFilePath(), elementLocation.getLineNumber(), NLS.bind((String)SMLValidationMessages.errorBadAliasURI, (Object)alias)));
                }
            }
        }
    }

    private void validateBaseURIValue(String baseURI) {
        if (baseURI == null) {
            return;
        }
        IValidationOutput<String, Object> output = this.getValidationOutput();
        try {
            URI uri = new URI(baseURI);
            if (!uri.isAbsolute()) {
                output.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, NLS.bind((String)SMLValidationMessages.errorBaseURIRelativeRef, (Object)baseURI)));
            } else if (uri.getFragment() != null) {
                output.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, NLS.bind((String)SMLValidationMessages.errorBaseURIHasFragment, (Object)baseURI)));
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            output.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, SMLValidationMessages.errorInvalidURI));
        }
    }
}

