/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.smlvalidators;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.eclipse.cosmos.rm.validation.internal.artifacts.ElementModel;
import org.eclipse.cosmos.rm.validation.internal.artifacts.ElementSchemaModel;
import org.eclipse.cosmos.rm.validation.internal.common.AbstractValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.validation.internal.core.AbstractSMLValidator;
import org.eclipse.cosmos.rm.validation.internal.databuilders.DataBuilderRegistry;
import org.eclipse.cosmos.rm.validation.internal.databuilders.DocumentDOMBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.ElementSourceBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.IDataBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.SMLValidatingBuilder;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaValidator
extends AbstractSMLValidator {
    private static final String VALIDATION_ERROR_PREFIX = "cvc";
    private Map<String, ElementModel> schemas;
    private IValidationOutput<String, Object> validationLogger;
    private boolean smlIfInput;
    private String input;
    private IDataBuilder<?> elementSourceBuilder;
    private ElementSchemaModel currentSchema;
    private ArrayList<ElementSchemaModel> instanceSchemas;

    @Override
    public boolean validate() {
        this.init();
        if (!this.validateSchemas()) {
            return false;
        }
        return this.validateInstances();
    }

    private void init() {
        this.setTaskName(SMLValidationMessages.validationSchema);
        this.validationLogger = this.getValidationOutput();
        this.elementSourceBuilder = DataBuilderRegistry.instance().getDataStructureBuilder("org.eclipse.cosmos.rm.validation.ElementSourceHandler");
        this.schemas = ((ElementSourceBuilder)this.elementSourceBuilder).getSchemas();
        this.instanceSchemas = new ArrayList();
    }

    private boolean validateInstances() {
        boolean success;
        block9: {
            success = true;
            try {
                ElementModel currentInstance2 = null;
                SAXParser newSaxParser = SMLValidatorUtil.createSAXParser(this.buildSchemaSource(), true, null, this.validationLogger);
                for (ElementModel currentInstance2 : ((ElementSourceBuilder)this.elementSourceBuilder).getInstances()) {
                    StringBuffer buffer = new StringBuffer(currentInstance2.getSource());
                    try {
                        newSaxParser.parse(new InputSource(new ByteArrayInputStream(buffer.toString().getBytes())), (DefaultHandler)new SMLValidatingBuilder());
                    }
                    catch (SAXParseException e) {
                        this.reportParsingError(currentInstance2, e);
                        success = false;
                        if (!this.shouldAbortOnError()) continue;
                        return success;
                    }
                }
            }
            catch (SAXException e) {
                this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, e.getLocalizedMessage()));
                success = false;
                if (this.shouldAbortOnError()) {
                    return success;
                }
            }
            catch (ParserConfigurationException e) {
                this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, e.getLocalizedMessage()));
                success = false;
                if (this.shouldAbortOnError()) {
                    return success;
                }
            }
            catch (IOException e) {
                this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, e.getLocalizedMessage()));
                success = false;
                if (!this.shouldAbortOnError()) break block9;
                return success;
            }
        }
        return success;
    }

    private boolean validateSchemas() {
        boolean success = true;
        this.currentSchema = null;
        Iterator<ElementModel> iterator = this.schemas.values().iterator();
        while (iterator.hasNext()) {
            try {
                this.validateSchema((ElementSchemaModel)iterator.next());
            }
            catch (SAXNotRecognizedException e1) {
                e1.printStackTrace();
            }
            catch (SAXNotSupportedException e1) {
                e1.printStackTrace();
            }
            catch (ParserConfigurationException e1) {
                e1.printStackTrace();
            }
            catch (SAXParseException e1) {
                this.reportParsingError(this.currentSchema, e1);
                success = false;
                if (!this.shouldAbortOnError()) continue;
                return success;
            }
            catch (SAXException e1) {
                this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, e1.getLocalizedMessage()));
                success = false;
                if (!this.shouldAbortOnError()) continue;
                return success;
            }
            catch (IOException e) {
                success = false;
                e.printStackTrace();
            }
        }
        return success;
    }

    private void validateSchema(ElementSchemaModel schema) throws SAXException, IOException, ParserConfigurationException {
        if (schema.hasBeenValidated()) {
            return;
        }
        ArrayList<ElementModel> schemasForValidating = new ArrayList<ElementModel>();
        this.instanceSchemas.add(schema);
        for (String prereq : schema.getPrerequisiteNamespaces()) {
            ElementSchemaModel prereqModel = (ElementSchemaModel)this.schemas.get(prereq);
            if (prereqModel == null) continue;
            schemasForValidating.add(prereqModel);
            this.validateSchema(prereqModel);
        }
        this.currentSchema = schema;
        InputStream xmlSchemaStream = null;
        try {
            ArrayList<InputStream> schemaSourcesList = new ArrayList<InputStream>();
            xmlSchemaStream = this.getClass().getClassLoader().getResourceAsStream("validation-resources/XMLSchema.xsd");
            schemaSourcesList.add(xmlSchemaStream);
            SAXParser schemaParser = SMLValidatorUtil.createSAXParser(this.primBuildSchemaSource(schemaSourcesList, schemasForValidating), true, null, this.validationLogger);
            schemaParser.parse(new InputSource(new ByteArrayInputStream(this.currentSchema.getSource().getBytes())), (DefaultHandler)new SMLValidatingBuilder());
        }
        finally {
            this.currentSchema.markValidated();
            xmlSchemaStream.close();
        }
    }

    private void reportParsingError(ElementModel currentInstance, SAXParseException e) {
        boolean validationError = currentInstance instanceof ElementSchemaModel || e.getMessage().startsWith(VALIDATION_ERROR_PREFIX);
        int lineNumber = -1;
        ElementModel errorLocation = null;
        if (validationError) {
            errorLocation = currentInstance;
            lineNumber = currentInstance.getLineNumber() + e.getLineNumber();
        } else {
            errorLocation = currentInstance;
            lineNumber = this.smlIfInput ? currentInstance.getLineNumber() : -1;
        }
        this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(errorLocation == null ? null : errorLocation.getFilePath(), lineNumber, e.getColumnNumber(), e.getLocalizedMessage()));
    }

    private InputStream[] buildSchemaSource() {
        Collection<ElementModel> collectionSchemas = this.schemas.values();
        ArrayList<ElementModel> sortedSchemas = new ArrayList<ElementModel>();
        for (ElementSchemaModel elementSchemaModel : collectionSchemas) {
            this.addSchema(sortedSchemas, elementSchemaModel);
        }
        return this.primBuildSchemaSource(null, sortedSchemas);
    }

    private void addSchema(List<ElementModel> sortedSchemas, ElementSchemaModel schemaElement) {
        if (sortedSchemas.contains(schemaElement)) {
            return;
        }
        List<String> importedSchemas = schemaElement.getImportedSchmas();
        int i = 0;
        int importCount = importedSchemas.size();
        while (i < importCount) {
            ElementSchemaModel importedElement = (ElementSchemaModel)this.schemas.get(importedSchemas.get(i));
            if (importedElement != null) {
                this.addSchema(sortedSchemas, importedElement);
            }
            ++i;
        }
        sortedSchemas.add(schemaElement);
    }

    private InputStream[] primBuildSchemaSource(List<InputStream> schemaSourcesList, Collection<ElementModel> localSchemas) {
        if (schemaSourcesList == null) {
            schemaSourcesList = new ArrayList<InputStream>();
        }
        for (ElementModel schemaModel : localSchemas) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(schemaModel.getSource());
            schemaSourcesList.add(new ByteArrayInputStream(buffer.toString().getBytes()));
        }
        return schemaSourcesList.toArray(new InputStream[schemaSourcesList.size()]);
    }

    @Override
    public void initialize(Map<String, Object> validationAttribute) {
        super.initialize(validationAttribute);
        this.smlIfInput = !(validationAttribute.get("validation.input.type") instanceof String) || !"value.sml.unit".equals(validationAttribute.get("validation.input.type"));
        this.input = (String)validationAttribute.get("validation.instance");
        DataBuilderRegistry builderRegistry = DataBuilderRegistry.instance();
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.DocumentDOMBuilder", new DocumentDOMBuilder());
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.ElementSourceHandler", new ElementSourceBuilder("value.environment.eclipse".equals(validationAttribute.get("attribute.environment")), this.smlIfInput ? this.input : null));
    }
}

