/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.repository.internal.operations;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.cosmos.rm.repository.core.ISMLRepository;
import org.eclipse.cosmos.rm.repository.exception.RepositoryOperationException;
import org.eclipse.cosmos.rm.repository.internal.RepositoryMessages;
import org.eclipse.cosmos.rm.repository.internal.SMLRepositoryUtil;
import org.eclipse.cosmos.rm.repository.internal.core.FileSystemSMLRepository;
import org.eclipse.cosmos.rm.repository.internal.core.MetadataProcessor;
import org.eclipse.cosmos.rm.repository.internal.operations.AbstractSMLOperation;
import org.eclipse.cosmos.rm.repository.internal.operations.SMLMainValidator;
import org.eclipse.cosmos.rm.repository.internal.resource.SMLFileMetadata;
import org.eclipse.cosmos.rm.repository.operations.ISMLValidateOperation;
import org.eclipse.cosmos.rm.repository.resource.ISMLDefinitionDocument;
import org.eclipse.cosmos.rm.repository.resource.ISMLDocument;
import org.eclipse.cosmos.rm.repository.resource.ISMLInstanceDocument;
import org.eclipse.osgi.util.NLS;

public class FileValidateOperation
extends AbstractSMLOperation
implements ISMLValidateOperation {
    private SMLMainValidator validator = new SMLMainValidator();
    private Collection<ISMLDocument> smlUnitsToValidate;
    private boolean status;
    private List<String> internalErrors = new ArrayList<String>();

    public FileValidateOperation(ISMLRepository repository) {
        super(repository);
    }

    public String getId() {
        return "org.eclipse.cosmos.rm.repository.operations.ISMLValidateOperation";
    }

    public void run() throws RepositoryOperationException {
        String[] REQUIRED_ATTRIBUTES = new String[]{"attribute.environment", "validation.instance", "validation.input.type"};
        Object[] arguments = this.getArguments();
        if (arguments.length != 1 && super.checkType(arguments[0].getClass(), Map.class)) {
            throw new RepositoryOperationException(RepositoryMessages.operationBadArguments);
        }
        Map argumentAttributes = (Map)arguments[0];
        int i = 0;
        while (i < REQUIRED_ATTRIBUTES.length) {
            if (argumentAttributes.get(REQUIRED_ATTRIBUTES[i]) == null) {
                throw new RepositoryOperationException(RepositoryMessages.operationBadArguments);
            }
            ++i;
        }
        this.smlUnitsToValidate = new ArrayList<ISMLDocument>();
        Map<String, Object> attributes = this.validator.getAttributes();
        attributes.put("validation.repository.root", this.getRepository().getProperty("root.directory", ""));
        for (String key : argumentAttributes.keySet()) {
            attributes.put(key, argumentAttributes.get(key));
        }
        StringTokenizer instances = new StringTokenizer((String)attributes.get("validation.instance"), ",");
        boolean smlifInputType = "value.sml.if".equals(attributes.get("validation.input.type"));
        SMLFileMetadata metadata = new SMLFileMetadata();
        this.status = true;
        int i2 = 0;
        while (instances.hasMoreTokens()) {
            if (smlifInputType) {
                attributes.put("validation.instance", instances.nextToken());
                this.status = this.validator.start() && this.status;
            } else {
                metadata.setId(instances.nextToken());
                ISMLDocument[] document = this.getRepository().fetchDocuments(metadata);
                if (document.length != 1) {
                    this.addInternalError(NLS.bind((String)RepositoryMessages.validateErrorMissingDocument, (Object)metadata.getId()));
                }
                this.addSMLUnit(document[0]);
            }
            ++i2;
        }
        if (!smlifInputType) {
            StringBuffer paths = new StringBuffer();
            for (ISMLDocument document : this.smlUnitsToValidate) {
                paths.append(SMLRepositoryUtil.getDocumentPath(document)).append(",");
            }
            if (paths.length() > 0) {
                paths.deleteCharAt(paths.length() - 1);
                attributes.put("validation.instance", paths.toString());
                if (this.getRepository() instanceof FileSystemSMLRepository) {
                    MetadataProcessor metadataProcessor = ((FileSystemSMLRepository)this.getRepository()).getMetadataProcessor();
                    attributes.put("validation.identity", metadataProcessor.getMetadataHandler().getIdentity());
                    attributes.put("validation.rule.bindings", metadataProcessor.getMetadataHandler().getAliasRuleBinding());
                    attributes.put("validation.aliases", metadataProcessor.getMetadataHandler().getFileAliasMap());
                }
                this.status = this.validator.start() && this.status;
            }
        }
    }

    private void addInternalError(String errorMessage) {
        this.internalErrors.add(errorMessage);
    }

    private void addInternalError(RepositoryOperationException e) {
        this.internalErrors.add(e.getLocalizedMessage());
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        this.internalErrors.add(sw.getBuffer().toString());
    }

    public String[] getInternalErrors() {
        return this.internalErrors.toArray(new String[this.internalErrors.size()]);
    }

    public boolean getStatus() {
        return this.status;
    }

    private void addSMLUnit(ISMLDocument document) {
        if (document == null || this.smlUnitsToValidate.contains(document)) {
            return;
        }
        this.smlUnitsToValidate.add(document);
        if (1 == document.getMetadata().getDocumentType()) {
            ISMLInstanceDocument instance = (ISMLInstanceDocument)document;
            try {
                ISMLDefinitionDocument[] definitions = instance.retrieveDefinitions();
                int i = 0;
                while (i < definitions.length) {
                    this.addSMLUnit(definitions[i]);
                    ++i;
                }
                ISMLDocument[] references = instance.retrieveReferences(new SMLFileMetadata());
                int i2 = 0;
                while (i2 < references.length) {
                    this.addSMLUnit(references[i2]);
                    ++i2;
                }
            }
            catch (RepositoryOperationException e) {
                this.addInternalError(e);
            }
        }
    }
}

