/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.repository.internal.operations;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.cosmos.rm.repository.internal.RepositoryMessages;
import org.eclipse.cosmos.rm.repository.internal.operations.ModelUnit;
import org.eclipse.cosmos.rm.validation.internal.artifacts.RuleBinding;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMLIFFileHandler
extends DefaultHandler {
    private boolean inData;
    private boolean inDefinitions;
    private boolean inAlias;
    private boolean inBaseURI;
    private boolean inDescription;
    private boolean inName;
    private boolean inDisplayName;
    private boolean inDocumentAlias;
    private boolean inRuleAlias;
    private boolean inVersion;
    private boolean buildingModelUnit;
    private ModelUnit currentModel;
    private List<ModelUnit> modelUnits = new ArrayList<ModelUnit>();
    private List<RuleBinding> ruleBindingMappings = new ArrayList<RuleBinding>();
    private StringBuffer currentElementBuffer = new StringBuffer();
    private StringBuffer currentRuleAliasBuffer = new StringBuffer();
    private StringBuffer currentDocumentAliasBuffer = new StringBuffer();
    private String baseURI;
    private String name;
    private String description;
    private String displayName;
    private String version;
    private boolean firstElement;
    private Map<String, String> definitionFiles = new Hashtable<String, String>();
    private String currentTargetNamespace;

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String elementData = new String(ch, start, length);
        if (this.inData) {
            this.writeToModelUnitFile(elementData);
        }
        String trimmedElementData = elementData.trim();
        if (this.inAlias || this.inBaseURI || this.inName || this.inDisplayName || this.inVersion) {
            this.currentElementBuffer.append(trimmedElementData);
        } else if (this.inDocumentAlias) {
            this.currentDocumentAliasBuffer.append(trimmedElementData);
        } else if (this.inRuleAlias) {
            this.currentRuleAliasBuffer.append(trimmedElementData);
        }
        if (this.inDescription) {
            this.currentElementBuffer.append(elementData);
        }
        super.characters(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("definitions".equals(localName)) {
            this.inDefinitions = false;
        } else if ("data".equals(localName)) {
            this.inData = false;
            this.currentModel.stop();
            this.modelUnits.add(this.currentModel);
            this.currentModel = null;
        } else if ("locator".equals(localName)) {
            if (this.currentModel != null) {
                this.modelUnits.add(this.currentModel);
                this.currentModel = null;
            }
        } else if ("base".equals(localName)) {
            this.inBaseURI = false;
            this.baseURI = this.currentElementBuffer.toString().trim();
            this.currentElementBuffer = new StringBuffer();
        } else if ("name".equals(localName)) {
            this.inName = false;
            this.name = this.currentElementBuffer.toString().trim();
            this.currentElementBuffer = new StringBuffer();
        } else if ("displayName".equals(localName)) {
            this.inDisplayName = false;
            this.displayName = this.currentElementBuffer.toString().trim();
            this.currentElementBuffer = new StringBuffer();
        } else if ("version".equals(localName)) {
            this.inVersion = false;
            this.version = this.currentElementBuffer.toString().trim();
            this.currentElementBuffer = new StringBuffer();
        } else if ("description".equals(localName)) {
            this.inDescription = false;
            this.description = this.currentElementBuffer.toString();
            this.currentElementBuffer = new StringBuffer();
        } else if ("alias".equals(localName)) {
            this.inAlias = false;
            this.currentModel.addAlias(this.currentElementBuffer.toString().trim());
            this.currentElementBuffer = new StringBuffer();
        } else if ("ruleBinding".equals(localName)) {
            if (this.currentRuleAliasBuffer.length() > 0) {
                String docAlias = null;
                if (this.currentDocumentAliasBuffer.length() > 0) {
                    docAlias = this.currentDocumentAliasBuffer.toString().trim();
                }
                String ruleAlias = this.currentRuleAliasBuffer.toString().trim();
                this.ruleBindingMappings.add(new RuleBinding(docAlias, ruleAlias));
            }
            this.currentDocumentAliasBuffer = new StringBuffer();
            this.currentRuleAliasBuffer = new StringBuffer();
        } else if ("ruleAlias".equals(localName)) {
            this.inRuleAlias = false;
        } else if ("documentAlias".equals(localName)) {
            this.inDocumentAlias = false;
        }
        if (this.inData) {
            this.writeToModelUnitFile("</" + qName + ">");
        }
        super.endElement(uri, localName, qName);
    }

    public String getModelLocation() {
        if (this.baseURI == null) {
            return "";
        }
        String result = this.baseURI;
        if (result.startsWith("http://")) {
            int nextSlash = (result = result.substring("http://".length())).indexOf(47);
            result = nextSlash == -1 ? "" : String.valueOf(result.substring(nextSlash)) + File.separatorChar;
        }
        return result;
    }

    public List<ModelUnit> getModelUnits() {
        return this.modelUnits;
    }

    public boolean inModelUnit() {
        return this.buildingModelUnit;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("documentAlias".equals(localName)) {
            this.inDocumentAlias = true;
        } else if ("ruleAlias".equals(localName)) {
            this.inRuleAlias = true;
        } else if ("definitions".equals(localName)) {
            this.inDefinitions = true;
        } else if ("base".equals(localName)) {
            this.inBaseURI = true;
        } else if ("name".equals(localName)) {
            this.inName = true;
        } else if ("displayName".equals(localName)) {
            this.inDisplayName = true;
        } else if ("version".equals(localName)) {
            this.inVersion = true;
        } else if ("description".equals(localName)) {
            this.inDescription = true;
        } else if ("document".equals(localName)) {
            this.currentModel = new ModelUnit(this.inDefinitions ? 0 : 1);
            this.currentModel.start();
        } else {
            if ("locator".equals(localName)) {
                String remoteDocUrlString = attributes.getValue("http://www.w3.org/1999/xlink", "href");
                URL remoteDocUrl = null;
                try {
                    remoteDocUrl = new URL(remoteDocUrlString);
                }
                catch (MalformedURLException malformedURLException) {
                    this.currentModel = null;
                    throw new SAXException(NLS.bind((String)RepositoryMessages.importErrorInvalidLocatorURL, (Object)remoteDocUrlString));
                }
                String localFileName = remoteDocUrl.getFile();
                this.currentModel.setFileName(localFileName);
                try {
                    this.retrieveRemoteDocument(remoteDocUrlString);
                }
                catch (SMLValidatorUtil.RemoteRetrievalException remoteRetrievalException) {
                    this.currentModel = null;
                    throw new SAXException(NLS.bind((String)RepositoryMessages.importErrorMissingFileAtLocatorURL, (Object)remoteDocUrlString));
                }
            }
            if ("alias".equals(localName)) {
                this.inAlias = true;
            }
        }
        if (this.inData) {
            this.buildingModelUnit = true;
            boolean isfirstInstanceElement = this.firstElement && !this.inDefinitions;
            Hashtable<String, String> prefixes = isfirstInstanceElement ? new Hashtable<String, String>() : null;
            String schemaURIPrefix = null;
            this.writeToModelUnitFile("<" + qName);
            if (attributes != null) {
                int i = 0;
                while (i < attributes.getLength()) {
                    String aName = attributes.getQName(i);
                    this.writeToModelUnitFile(" ");
                    this.writeToModelUnitFile(String.valueOf(aName) + "=\"" + attributes.getValue(i) + "\"");
                    if (isfirstInstanceElement && "http://www.w3.org/2001/XMLSchema".equals(attributes.getValue(i))) {
                        schemaURIPrefix = attributes.getQName(i).replaceAll(attributes.getLocalName(i), "");
                    }
                    ++i;
                }
            }
            if (this.firstElement) {
                String file;
                this.currentModel.setFilePrefix(localName);
                if (this.inDefinitions) {
                    this.currentTargetNamespace = attributes.getValue("targetNamespace");
                    if (this.currentTargetNamespace != null) {
                        String[] namespaceTokens = this.currentTargetNamespace.split("\\W");
                        if (namespaceTokens.length > 0) {
                            this.currentModel.setFilePrefix(namespaceTokens[namespaceTokens.length - 1]);
                        }
                        this.currentModel.setFileName(this.currentModel.getFileName());
                        this.definitionFiles.put(this.currentTargetNamespace, this.currentModel.getFileName());
                    }
                } else if (uri != null && (file = this.definitionFiles.get(uri)) != null) {
                    String prefix;
                    String string = prefix = schemaURIPrefix == null ? this.findUnboundPrefix(prefixes) : schemaURIPrefix;
                    if (schemaURIPrefix == null) {
                        this.writeToModelUnitFile(" xmlns:" + prefix + "=\"" + "http://www.w3.org/2001/XMLSchema-instance" + "\"");
                    }
                    String currentFileName = this.currentModel.getFileName();
                    int currentInx = 0;
                    String relativePath = "";
                    while ((currentInx = currentFileName.indexOf(47, currentInx + 1)) > 0) {
                        relativePath = String.valueOf(relativePath) + "../";
                    }
                    this.writeToModelUnitFile(" " + prefix + ":" + "schemaLocation" + "=\"" + uri + " " + relativePath + file + "\"");
                }
                this.firstElement = false;
            }
            this.writeToModelUnitFile(">");
        }
        if ("data".equals(localName)) {
            this.inData = true;
            this.firstElement = true;
        }
        super.startElement(uri, localName, qName, attributes);
    }

    private String findUnboundPrefix(Map<String, String> prefixes) {
        String prefix = "xsi";
        while (prefixes.get(prefix) != null) {
            prefix = String.valueOf(prefix) + "i";
        }
        return prefix;
    }

    private void retrieveRemoteDocument(String remoteDocUrlString) throws SMLValidatorUtil.RemoteRetrievalException {
        IOException exception = null;
        try {
            String line;
            URL locator = new URL(remoteDocUrlString);
            InputStream stream = locator.openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            while ((line = reader.readLine()) != null) {
                this.currentModel.appendToContents(String.valueOf(line) + "\n");
            }
            reader.close();
            return;
        }
        catch (MalformedURLException e) {
            exception = e;
        }
        catch (IOException e) {
            exception = e;
        }
        throw new SMLValidatorUtil.RemoteRetrievalException((Exception)exception);
    }

    private void writeToModelUnitFile(String string) {
        this.currentModel.appendToContents(string);
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getVersion() {
        return this.version;
    }

    public List<RuleBinding> getRuleBindingMappings() {
        return this.ruleBindingMappings;
    }
}

