/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.repository.internal.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.cosmos.dc.cmdbf.services.internal.CMDBfInternalUtility;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IItemConvertible;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.INodes;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.QueryOutputArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IInstanceId;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IItem;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRecord;
import org.eclipse.cosmos.rm.repository.core.ISMLRepository;
import org.eclipse.cosmos.rm.repository.exception.RepositoryOperationException;
import org.eclipse.cosmos.rm.repository.internal.resource.SMLFileDocument;
import org.eclipse.cosmos.rm.repository.internal.resource.SMLFileMetadata;
import org.eclipse.cosmos.rm.repository.resource.ISMLDefinitionDocument;
import org.eclipse.cosmos.rm.repository.resource.ISMLDocument;
import org.eclipse.cosmos.rm.repository.resource.ISMLInstanceDocument;
import org.eclipse.cosmos.rm.repository.resource.ISMLMetadata;
import org.eclipse.cosmos.rm.validation.internal.artifacts.ReferenceDescriptor;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.validation.internal.databuilders.ReferenceExtractor;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMLFileInstanceDocument
extends SMLFileDocument
implements ISMLInstanceDocument,
Comparable<SMLFileDocument>,
IItemConvertible {
    private List<ReferenceDescriptor> references;

    public SMLFileInstanceDocument(ISMLRepository repository) {
        super(repository);
    }

    @Override
    public ISMLDocument[] retrieveReferences(ISMLMetadata metadata) throws RepositoryOperationException {
        if (this.getMetadata() == null || this.getMetadata().getId() == null) {
            return new ISMLDocument[0];
        }
        File document = new File(this.getMetadata().getId());
        if (this.references == null || super.getLastModifiedDate() != document.lastModified()) {
            if (!document.exists()) {
                return new ISMLDocument[0];
            }
            ReferenceExtractor referenceExtractor = new ReferenceExtractor();
            try {
                SMLValidatorUtil.saxParseDocument((InputStream)new FileInputStream(document), (DefaultHandler)referenceExtractor);
            }
            catch (Exception e) {
                throw new RepositoryOperationException(e.getLocalizedMessage(), e);
            }
            this.references = referenceExtractor.getDataStructure();
        }
        String[] smlURIs = new String[this.references.size()];
        int i = 0;
        while (i < smlURIs.length) {
            smlURIs[i] = this.references.get(i).getReference();
            ++i;
        }
        i = 0;
        while (i < smlURIs.length) {
            int anchor = smlURIs[i].indexOf(35);
            if (anchor > 0) {
                smlURIs[i] = smlURIs[i].substring(0, anchor);
            }
            smlURIs[i] = smlURIs[i].trim();
            ++i;
        }
        SMLFileMetadata queryMetadata = new SMLFileMetadata();
        queryMetadata.setAliases(smlURIs);
        TreeSet<ISMLDocument> references = new TreeSet<ISMLDocument>();
        ISMLDocument[] referencedDocuments = this.getRepository().fetchDocuments(queryMetadata);
        int i2 = 0;
        while (i2 < referencedDocuments.length) {
            references.add(referencedDocuments[i2]);
            ++i2;
        }
        queryMetadata.setAliases(null);
        i2 = 0;
        while (i2 < smlURIs.length) {
            queryMetadata.setId(smlURIs[i2]);
            referencedDocuments = this.getRepository().fetchDocuments(queryMetadata);
            if (referencedDocuments != null && referencedDocuments.length == 1) {
                references.add(referencedDocuments[0]);
            }
            ++i2;
        }
        if (referencedDocuments == null) {
            return new ISMLDocument[0];
        }
        ArrayList<ISMLDocument> finalDocumentList = new ArrayList<ISMLDocument>();
        for (ISMLDocument currentDocument : references) {
            ISMLMetadata documentMetadata = currentDocument.getMetadata();
            if (!this.isEqual(new String[]{metadata.getId(), metadata.getRootElementName()}, new String[]{documentMetadata.getId(), documentMetadata.getRootElementName()}) || !this.isEqual(metadata.getAliases(), documentMetadata.getAliases()) || !this.isEqual(metadata.getBoundRules(), documentMetadata.getBoundRules()) || !this.isEqual(metadata.getDocumentType(), documentMetadata.getDocumentType())) continue;
            finalDocumentList.add(currentDocument);
        }
        return finalDocumentList.toArray(new ISMLDocument[finalDocumentList.size()]);
    }

    private boolean isEqual(Map<String, ?> expected, Map<String, ?> actual) {
        if (expected == null) {
            return actual == null || actual.size() == 0;
        }
        if (expected.size() != actual.size()) {
            return false;
        }
        for (String currentKey : expected.keySet()) {
            if (expected.get(currentKey).equals(actual.get(currentKey))) continue;
            return false;
        }
        return true;
    }

    private boolean isEqual(int expected, int actual) {
        if (expected < 0) {
            return true;
        }
        return expected == actual;
    }

    private boolean isEqual(String[] expected, String[] actual) {
        if (expected == null || expected.length == 0) {
            return true;
        }
        boolean foundEntry = true;
        int j = 0;
        while (j < expected.length) {
            if (expected[j] != null) {
                foundEntry = false;
                if (actual != null) {
                    int j2 = 0;
                    while (j2 < actual.length) {
                        if (expected[j].equals(actual[j2])) {
                            foundEntry = true;
                            break;
                        }
                        ++j2;
                    }
                }
                if (!foundEntry) {
                    return false;
                }
            }
            ++j;
        }
        return true;
    }

    @Override
    public ISMLDefinitionDocument[] retrieveDefinitions() throws RepositoryOperationException {
        String schemaLocation = this.retrieveRootAttribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
        if (schemaLocation == null) {
            return new ISMLDefinitionDocument[0];
        }
        ArrayList<ISMLDocument> definitionDocumentsList = new ArrayList<ISMLDocument>();
        StringTokenizer tokenizer = new StringTokenizer(schemaLocation);
        while (tokenizer.hasMoreTokens()) {
            ISMLDocument[] definitionDocument;
            String filePath;
            tokenizer.nextToken();
            String definition = null;
            try {
                definition = tokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
            if (!definition.startsWith("/") && (filePath = this.getMetadata().getId()) != null) {
                int inx = filePath.lastIndexOf(47);
                if (inx >= 0) {
                    filePath = filePath.substring(0, inx + 1);
                }
                definition = String.valueOf(filePath) + definition;
            }
            if ((definitionDocument = this.getRepository().fetchDocuments(new SMLFileMetadata(definition, -1, null, null, null))) == null || definitionDocument.length != 1 || !(definitionDocument[0] instanceof ISMLDefinitionDocument)) continue;
            definitionDocumentsList.add(definitionDocument[0]);
        }
        return definitionDocumentsList.toArray(new ISMLDefinitionDocument[definitionDocumentsList.size()]);
    }

    @Override
    public int compareTo(SMLFileDocument arg0) {
        ISMLMetadata metadata = arg0.getMetadata();
        String id = this.getMetadata() == null ? null : this.getMetadata().getId();
        return id == null ? -1 : id.compareTo(metadata.getId());
    }

    public String toString() {
        return super.toString();
    }

    public IItem toItem(INodes parent) {
        IItem item = QueryOutputArtifactFactory.getInstance().createItem();
        try {
            Node node = this.getDOMDocument().getFirstChild();
            IRecord record = QueryOutputArtifactFactory.getInstance().createRecord((IGraphElement)item, this.getMetadata().getId());
            StringBuffer buffer = new StringBuffer();
            CMDBfInternalUtility.serializeNode((StringBuffer)buffer, (Node)node);
            record.setValueFromString(buffer.toString());
            NamedNodeMap attributes = node.getAttributes();
            if (attributes != null) {
                int i = 0;
                int attCount = attributes.getLength();
                while (i < attCount) {
                    Node currentAttribute = attributes.item(i);
                    String attLocalName = currentAttribute.getLocalName();
                    if (attLocalName.startsWith("xmlns")) {
                        String prefix;
                        String namespaceURI = currentAttribute.getNodeValue();
                        int colonInx = attLocalName.indexOf(58);
                        String string = prefix = colonInx < 0 ? null : attLocalName.substring(colonInx + 1);
                        if (namespaceURI != null && prefix != null) {
                            record.addNamespace(prefix, namespaceURI);
                        }
                    }
                    ++i;
                }
            }
            item.addRecord(record);
            IInstanceId instanceId = QueryOutputArtifactFactory.getInstance().createInstanceId("http://cosmos.org/rm/sml/repository", this.getMetadata().getId());
            item.addInstanceId(instanceId);
            return item;
        }
        catch (RepositoryOperationException repositoryOperationException) {
            return null;
        }
    }
}

