/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.smlif.internal.common;

import java.util.Hashtable;
import org.eclipse.cosmos.rm.repository.core.ISMLRepository;
import org.eclipse.cosmos.rm.repository.core.SMLRepositoryFactory;
import org.eclipse.cosmos.rm.repository.exception.MissingRepositoryException;
import org.eclipse.cosmos.rm.repository.exception.RepositoryConnectionException;
import org.eclipse.cosmos.rm.repository.internal.core.FileSystemSMLRepository;

public class SMLRepositoryManager {
    private static ISMLRepository repository;

    public static ISMLRepository getRepository() {
        if (repository == null || !repository.isConnection()) {
            try {
                repository = SMLRepositoryFactory.createRepository();
            }
            catch (MissingRepositoryException missingRepositoryException) {
                repository = new FileSystemSMLRepository();
            }
            try {
                Hashtable<String, Boolean> attributes = new Hashtable<String, Boolean>();
                attributes.put("suppress.connect.errors", Boolean.TRUE);
                repository.connect(attributes);
            }
            catch (RepositoryConnectionException e) {
                e.printStackTrace();
            }
        }
        return repository;
    }

    public static ISMLRepository getRepository(String context, boolean reuse) {
        if (!reuse && repository != null) {
            repository.disconnect();
        }
        ISMLRepository repository = SMLRepositoryManager.getRepository();
        context = context.replace('\\', '/');
        repository.setProperty("root.directory", context);
        return repository;
    }

    public static ISMLRepository getRepository(String context) {
        return SMLRepositoryManager.getRepository(context, true);
    }
}

