/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers.util;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.eclipse.hyades.logging.adapter.util.AbstractXPATHFilterExit;

public class ApacheAccessLogFilterExit
extends AbstractXPATHFilterExit {
    private SimpleDateFormat SDFformatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private SimpleDateFormat SDFparser = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss", Locale.US);

    public short parseSeverity(String record) {
        String searchStr = record;
        int quoteIndex = record.indexOf("\" ");
        while (quoteIndex != -1) {
            String num;
            int spaceIndex = (searchStr = searchStr.substring(quoteIndex + 1).trim()).indexOf(32);
            if (spaceIndex == -1) {
                spaceIndex = searchStr.length();
            }
            if ((num = searchStr.substring(0, spaceIndex)).length() == 3) {
                try {
                    Integer.parseInt(num);
                    switch (num.charAt(0)) {
                        case '4': {
                            return 40;
                        }
                        case '5': {
                            return 60;
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            quoteIndex = searchStr.indexOf("\" ");
        }
        return 10;
    }

    public String parseTime(String record) {
        int startIndex = record.indexOf("[");
        int endIndex = record.indexOf("]");
        StringBuffer currentTimeStamp = null;
        if (startIndex != -1 && endIndex != -1 && startIndex < endIndex) {
            int timeZoneIndex = record.indexOf(45, startIndex);
            if (!(timeZoneIndex != -1 && timeZoneIndex <= endIndex || (timeZoneIndex = record.indexOf(43, startIndex)) != -1 && timeZoneIndex <= endIndex)) {
                return null;
            }
            Date creationDate = this.SDFparser.parse(record.substring(startIndex + 1, timeZoneIndex).trim(), new ParsePosition(0));
            if (creationDate != null) {
                currentTimeStamp = new StringBuffer(this.SDFformatter.format(creationDate).trim());
                currentTimeStamp.replace(10, 11, "T");
                currentTimeStamp.append(".000000");
                currentTimeStamp.append(record.charAt(timeZoneIndex));
                currentTimeStamp.append(record.substring(timeZoneIndex + 1, timeZoneIndex + 3));
                currentTimeStamp.append(":");
                currentTimeStamp.append(record.substring(timeZoneIndex + 3, timeZoneIndex + 5));
                return currentTimeStamp.toString();
            }
        }
        return null;
    }
}

