/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.dmtoolkit.j2ee.delegates;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.cosmos.me.dmtoolkit.common.Utilities;
import org.eclipse.cosmos.me.dmtoolkit.common.ui.artifacts.IProjectConfig;
import org.eclipse.cosmos.me.dmtoolkit.common.ui.artifacts.IReferenceParameterTuple;
import org.eclipse.cosmos.me.dmtoolkit.j2ee.DMJ2EEPlugin;
import org.eclipse.cosmos.me.dmtoolkit.j2ee.util.J2EEUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataManagerFacetInstallDelegate
implements IDelegate {
    private IProjectConfig config;

    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        this.setConfig((IProjectConfig)config);
        monitor.beginTask("Generating data manager project", this.taskCount());
        try {
            this.copyBundles(project, monitor);
            this.copyBundleContents(project, monitor);
            this.copyResources(project, monitor);
            this.createDataManagerClass(project, monitor);
            this.createInitializerClass(project, monitor);
            this.createConfigProperties(project, monitor);
            this.createDomainEPR(project, monitor);
            this.copyMuseXML(project, monitor);
            this.copyRouterEntries(project, monitor);
            this.modifyWebXML(project, monitor);
        }
        finally {
            monitor.done();
        }
    }

    protected void modifyWebXML(IProject project, IProgressMonitor monitor) throws CoreException {
        IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
        IVirtualFolder vf = vc.getRootFolder().getFolder("WEB-INF");
        IFolder webInfFolder = (IFolder)vf.getUnderlyingFolder();
        IFile webXmlFile = webInfFolder.getFile("web.xml");
        BufferedReader reader = new BufferedReader(new InputStreamReader(webXmlFile.getContents()));
        String line = null;
        StringWriter writer = new StringWriter();
        try {
            while ((line = reader.readLine()) != null) {
                writer.write(String.valueOf(line) + "\n");
            }
            writer.close();
            reader.close();
            String newContents = this.makeWebXMLModifications(writer.toString());
            FileWriter fileForRewrite = new FileWriter(webXmlFile.getLocation().toOSString());
            fileForRewrite.write(newContents);
            fileForRewrite.close();
        }
        catch (IOException e) {
            throw DataManagerFacetInstallDelegate.createCoreException(e);
        }
        webXmlFile.refreshLocal(1, monitor);
        monitor.worked(1);
    }

    protected String makeWebXMLModifications(String originalSource) throws CoreException {
        String results = originalSource.replace("</display-name>", "</display-name>\n\t<context-param>\n\t\t<param-name>CosmosWebPort</param-name>\n\t\t<param-value>8080</param-value>\n\t</context-param>");
        results = results.replace("</welcome-file-list>", "</welcome-file-list>\n" + this.getListenerAndServletInfo());
        return results;
    }

    protected String getListenerAndServletInfo() throws CoreException {
        String[] substitutionMap = new String[]{"%INITIALIZER_CLASS%", String.valueOf(this.getConfig().getPackageName()) + "." + J2EEUtilities.getInitializerClassName(this.getConfig())};
        return J2EEUtilities.populateResourceTemplate(substitutionMap, "resources/webXmlTemplate.txt");
    }

    protected static String readLine(BufferedReader reader) throws CoreException {
        String line = null;
        try {
            line = reader.readLine();
        }
        catch (IOException e) {
            throw DataManagerFacetInstallDelegate.createCoreException(e);
        }
        return line;
    }

    protected static CoreException createCoreException(Exception e) {
        return new CoreException(DMJ2EEPlugin.createErrorStatus(e.getMessage(), e));
    }

    protected void copyMuseXML(IProject project, IProgressMonitor monitor) throws CoreException {
        Bundle bundle = DMJ2EEPlugin.getDefault().getBundle();
        IFolder webInfClasses = J2EEUtilities.getWebInfClassesDir(project);
        J2EEUtilities.copyFromPlugin(bundle, (IPath)new Path("resources/muse.xml"), webInfClasses);
        monitor.worked(1);
    }

    protected void copyRouterEntries(IProject project, IProgressMonitor monitor) throws CoreException {
        Bundle bundle = DMJ2EEPlugin.getDefault().getBundle();
        IFolder webInfClasses = J2EEUtilities.getWebInfClassesDir(project);
        IFolder routerEntriesDir = webInfClasses.getFolder("router-entries");
        routerEntriesDir.create(true, true, monitor);
        IFolder simpleResourceDir = routerEntriesDir.getFolder("SimpleResource");
        simpleResourceDir.create(true, true, monitor);
        J2EEUtilities.copyFromPlugin(bundle, (IPath)new Path("resources/resource-instance-1.xml"), simpleResourceDir);
        J2EEUtilities.copyFromPlugin(bundle, (IPath)new Path("resources/resource-instance-2.xml"), simpleResourceDir);
        J2EEUtilities.copyFromPlugin(bundle, (IPath)new Path("resources/resource-instance-3.xml"), simpleResourceDir);
        monitor.worked(1);
    }

    protected void createDomainEPR(IProject project, IProgressMonitor monitor) throws CoreException {
        String[] substitutionMap = new String[]{"%DOMAIN_URI%", this.getConfig().getEprUri(), "%REFERENCE_PARAMETERS%", this.getReferenceParameterString()};
        String domainEPRContents = J2EEUtilities.populateResourceTemplate(substitutionMap, "resources/domainEPRTemplate.txt");
        IFolder targetFolder = J2EEUtilities.getWebInfClassesDir(project);
        File propsFile = targetFolder.getLocation().append("domainEPR.xml").toFile();
        PrintWriter pw = null;
        try {
            try {
                pw = new PrintWriter(new FileWriter(propsFile));
                pw.write(domainEPRContents);
            }
            catch (FileNotFoundException e) {
                throw DataManagerFacetInstallDelegate.createCoreException(e);
            }
            catch (IOException e) {
                throw DataManagerFacetInstallDelegate.createCoreException(e);
            }
        }
        finally {
            pw.close();
        }
        monitor.worked(1);
    }

    protected String getReferenceParameterString() throws CoreException {
        if (this.getConfig().getReferenceParameters().size() == 0) {
            return "";
        }
        StringWriter xml = new StringWriter();
        xml.append("\n\t<wsa:ReferenceParameters>\n");
        for (IReferenceParameterTuple tuple : this.getConfig().getReferenceParameters()) {
            String[] substitutionMap = new String[]{"%PREFIX%", tuple.getPrefix(), "%NAMESPACE%", tuple.getNamespace(), "%PARAM_NAME%", tuple.getName(), "%PARAM_VALUE%", tuple.getValue()};
            String referenceParm = J2EEUtilities.populateResourceTemplate(substitutionMap, "resources/eprReferenceParameterTemplate.txt");
            xml.append("\t\t" + referenceParm);
        }
        xml.append("\t</wsa:ReferenceParameters>");
        return xml.toString();
    }

    protected void createInitializerClass(IProject project, IProgressMonitor monitor) throws CoreException {
        Utilities.createProjectClass((IProject)project, (IProjectConfig)this.getConfig(), (IProgressMonitor)monitor, (String)J2EEUtilities.getDataManagerInitializerContents(this.getConfig()), (String)J2EEUtilities.getInitializerClassName(this.getConfig()));
    }

    protected void createDataManagerClass(IProject project, IProgressMonitor monitor) throws CoreException {
        Utilities.createDataManagerClass((IProject)project, (IProjectConfig)this.getConfig(), (IProgressMonitor)monitor);
    }

    protected void createConfigProperties(IProject project, IProgressMonitor monitor) throws CoreException {
        Properties props = this.config.toProperties();
        IFolder targetFolder = J2EEUtilities.getWebInfClassesDir(project);
        File propsFile = targetFolder.getLocation().append("config.properties").toFile();
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(propsFile);
                props.store(fos, null);
            }
            catch (FileNotFoundException e) {
                throw DataManagerFacetInstallDelegate.createCoreException(e);
            }
            catch (IOException e) {
                throw DataManagerFacetInstallDelegate.createCoreException(e);
            }
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        monitor.worked(1);
    }

    protected int taskCount() {
        return this.fileCount() + 7;
    }

    protected void copyBundles(IProject project, IProgressMonitor monitor) throws CoreException {
        for (String bundleName : this.getBundlesToCopy()) {
            IFolder webInfLib = J2EEUtilities.getWebInfLibDir(project);
            J2EEUtilities.copyBundle(bundleName, webInfLib);
            monitor.worked(1);
        }
    }

    protected void copyResources(IProject project, IProgressMonitor monitor) throws CoreException {
        Bundle bundle = DMJ2EEPlugin.getDefault().getBundle();
        IFolder webInfLib = J2EEUtilities.getWebInfLibDir(project);
        for (String fileName : this.getResourcesToCopy()) {
            J2EEUtilities.copyFromPlugin(bundle, (IPath)new Path(fileName), webInfLib);
            monitor.worked(1);
        }
    }

    protected void copyBundleContents(IProject project, IProgressMonitor monitor) throws CoreException {
        IFolder webInfLib = J2EEUtilities.getWebInfLibDir(project);
        HashMap<String, String> bundleMap = this.getBundleContentsToCopy();
        for (String fileName : bundleMap.keySet()) {
            Bundle bundle = Platform.getBundle((String)((String)bundleMap.get(fileName)));
            J2EEUtilities.copyFromPlugin(bundle, (IPath)new Path(fileName), webInfLib);
            monitor.worked(1);
        }
    }

    protected int fileCount() {
        return this.getBundlesToCopy().size() + this.getResourcesToCopy().size() + this.getBundleContentsToCopy().size();
    }

    protected ArrayList<String> getBundlesToCopy() {
        String[] bundleList = new String[]{"org.apache.xerces", "org.apache.xml.resolver", "org.apache.muse.complete", "org.eclipse.cosmos.common", "org.eclipse.cosmos.dc.broker.client", "org.eclipse.cosmos.dc.dataManager.common", "org.eclipse.cosmos.dc.dataManager", "org.eclipse.cosmos.dc.management.domain.client", "org.eclipse.cosmos.me.management.common", "org.eclipse.cosmos.me.management.wsdm"};
        return new ArrayList<String>((Collection)Arrays.asList(bundleList));
    }

    protected ArrayList<String> getResourcesToCopy() {
        String[] resourceList = new String[]{"resources/muse-platform-mini-2.2.0.jar"};
        return new ArrayList<String>((Collection)Arrays.asList(resourceList));
    }

    protected HashMap<String, String> getBundleContentsToCopy() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("wsdl4j-1.6.1.jar", "wsdl4j");
        return map;
    }

    public IProjectConfig getConfig() {
        return this.config;
    }

    public void setConfig(IProjectConfig config) {
        this.config = config;
    }
}

