/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.dataManager.impl;

import java.util.Collection;
import java.util.Properties;
import org.apache.muse.core.Capability;
import org.apache.muse.util.uuid.RandomUuidFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.dm.muws.Description;
import org.apache.muse.ws.resource.WsResource;
import org.apache.muse.ws.resource.basefaults.BaseFault;
import org.eclipse.cosmos.dc.broker.client.BrokerClient;
import org.eclipse.cosmos.dc.dataManager.api.IDataManager;
import org.eclipse.cosmos.dc.dataManager.exception.DataManagerException;
import org.eclipse.cosmos.dc.management.domain.client.ManagementDomainClient;
import org.eclipse.cosmos.me.management.annotations.ComposableManagedCapabilitySet;
import org.eclipse.cosmos.me.management.annotations.ManagedFrameworkAutowire;
import org.eclipse.cosmos.me.management.annotations.ManagedProperty;
import org.eclipse.cosmos.me.management.binding.Binding;
import org.eclipse.cosmos.me.management.provisional.wsdm.PolicyAssertion;
import org.eclipse.cosmos.me.management.provisional.wsdm.PolicyAssertionProvider;
import org.eclipse.cosmos.me.management.provisional.wsdm.capabilities.impl.DescriptionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComposableManagedCapabilitySet(set={DescriptionImpl.class})
public abstract class AbstractDataManager
implements IDataManager,
PolicyAssertionProvider {
    @ManagedProperty(resourceID=true)
    private String identifier = "undefined";
    @ManagedFrameworkAutowire(name="WSDM")
    private Binding wsdmBinding;
    protected Properties config = null;
    private boolean initialized = false;
    private EndpointReference domainEpr = null;
    private String displayName = null;
    private String description = null;
    private EndpointReference dataManagerEPR = null;

    public void setWsdmBinding(Binding wsdmBinding) {
        this.wsdmBinding = wsdmBinding;
    }

    public String getIdentifier() {
        this.identifier = this.config != null ? this.config.getProperty("RESOURCE_ID") : RandomUuidFactory.getInstance().createUUID();
        return this.identifier;
    }

    public String getDisplayName() {
        if (this.displayName == null && this.config != null) {
            this.displayName = this.config.getProperty("DISPLAY_NAME");
        }
        return this.displayName;
    }

    public String getDescription() {
        if (this.description == null && this.config != null) {
            this.description = this.config.getProperty("DESCRIPTION");
        }
        return this.description;
    }

    public void setConfigProperties(Properties config) {
        this.config = config;
    }

    public void setManagementDomainEPR(EndpointReference domainEPR) {
        this.domainEpr = domainEPR;
    }

    protected String getConfigProperty(String key) {
        return this.config != null ? this.config.getProperty(key) : null;
    }

    private void initialize() throws DataManagerException {
        if (!this.initialized) {
            Object resourceObject = this.wsdmBinding.getBindingForObject((Object)this);
            WsResource resource = null;
            if (resourceObject == null || !(resourceObject instanceof WsResource)) {
                throw new DataManagerException("Unable to access WsResource object of data manager " + this.getClass().getSimpleName());
            }
            resource = (WsResource)resourceObject;
            this.dataManagerEPR = resource.getEndpointReference();
            System.out.println("Initializing " + this.getClass().getSimpleName());
            System.out.println(" at EPR: ");
            System.out.println(this.dataManagerEPR.toString());
            Capability c = resource.getCapability("http://docs.oasis-open.org/wsdm/muws/capabilities/Description");
            Description d = (Description)c;
            this.displayName = this.config.getProperty("DISPLAY_NAME");
            this.description = this.config.getProperty("DESCRIPTION");
            try {
                d.setCaption(new String[]{this.displayName});
                d.setDescription(new String[]{this.description});
            }
            catch (BaseFault e) {
                throw new DataManagerException("Error occurred during initialization: " + e.getMessage());
            }
            System.out.println("Initialization completed for " + this.displayName);
            System.out.println(" description: " + this.description);
        }
    }

    public void register() throws DataManagerException {
        this.initialize();
        System.out.println("Registering " + this.getClass().getSimpleName());
        System.out.println(" using domain: ");
        System.out.println(this.domainEpr.toString());
        System.out.println(" with COSMOS broker...");
        String[] brokerEPRs = null;
        try {
            ManagementDomainClient client = new ManagementDomainClient(this.domainEpr);
            brokerEPRs = client.getAllServices();
        }
        catch (Exception e) {
            throw new DataManagerException("Error occurred while getting broker EPR from management domain.", (Throwable)e);
        }
        if (brokerEPRs.length == 0) {
            throw new DataManagerException("Data manager is not registered because no brokers registered at the management domain. ");
        }
        int i = 0;
        while (i < brokerEPRs.length) {
            try {
                EndpointReference brokerEPR = new EndpointReference(XmlUtils.createDocument((String)brokerEPRs[i]).getDocumentElement());
                BrokerClient brokerClient = new BrokerClient(brokerEPR);
                brokerClient.add(this.dataManagerEPR, null);
                System.out.println("DataManager " + this.displayName + " successfully registered with Broker:");
                System.out.println(brokerEPR.toString());
            }
            catch (Exception e) {
                throw new DataManagerException("Error occurred during registration with data broker.", (Throwable)e);
            }
            ++i;
        }
    }

    public void deregister() throws DataManagerException {
        System.out.println("deregister MDR from broker");
    }

    public Collection<PolicyAssertion> getPolicyAssertions() {
        return null;
    }
}

