/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.dataManager.impl;

import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.servlet.ServletContextEvent;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.eclipse.cosmos.dc.dataManager.api.IDataManager;
import org.eclipse.cosmos.me.management.wsdm.web.WSDMServiceInitializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractDataManagerInitializer
extends WSDMServiceInitializer {
    private IDataManager dataMgrImpl;
    private Properties dmConfig;

    public void contextInitialized(ServletContextEvent event) {
        this.dataMgrImpl = this.getDataManagerInstance();
        super.contextInitialized(event);
        try {
            URL resource = Thread.currentThread().getContextClassLoader().getResource("config.properties");
            this.dmConfig = new Properties();
            this.dmConfig.load(resource.openStream());
            this.dataMgrImpl.setConfigProperties(this.dmConfig);
            String domainEprFile = (String)this.dmConfig.get("MGMT_DOMAIN_EPR_FILE");
            if (domainEprFile == null) {
                System.out.println("Warning: Data manager registration cannot be completed because EPR of management domain is not set.");
            } else {
                URL domainEprURL = Thread.currentThread().getContextClassLoader().getResource(domainEprFile);
                Document domainEprDoc = XmlUtils.createDocument((InputStream)domainEprURL.openStream());
                Element eprElement = domainEprDoc.getDocumentElement();
                EndpointReference domainEpr = new EndpointReference(eprElement);
                this.dataMgrImpl.setManagementDomainEPR(domainEpr);
            }
        }
        catch (Exception e) {
            System.out.println("Error occurred during initializing data manager.");
            e.printStackTrace();
        }
    }

    protected void managerInitialized() {
        try {
            this.getManager().manage((Object)this.dataMgrImpl);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        String autoreg = this.dmConfig.getProperty("AUTO_REGISTER");
        if (autoreg != null && autoreg.equalsIgnoreCase("YES")) {
            String maxRetries = this.dmConfig.getProperty("MAX_RETRIES");
            int retryCount = maxRetries != null ? Integer.parseInt(maxRetries) : 5;
            String retriesInterval = this.dmConfig.getProperty("RETRY_INTERVAL");
            int interval = retriesInterval != null ? Integer.parseInt(retriesInterval) * 1000 : 5000;
            int i = 0;
            while (i < retryCount) {
                try {
                    this.dataMgrImpl.register();
                    break;
                }
                catch (Exception exception) {
                    System.out.println(String.valueOf(this.dmConfig.getProperty("DISPLAY_NAME")) + ": ");
                    System.out.println("Tried to register data manager with broker, but registration failed. (attempt " + (i + 1) + ")");
                    try {
                        Thread.yield();
                        Thread.sleep(interval);
                    }
                    catch (InterruptedException interruptedException) {}
                    ++i;
                }
            }
        }
    }

    protected abstract IDataManager getDataManagerInstance();
}

