/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.samples.cmdbf.services.query;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.cosmos.samples.cmdbf.services.query.XMLRepository;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SchoolXMLHandler
extends DefaultHandler {
    private XMLRepository.Student currentStudent;
    private XMLRepository.Teacher currentTeacher;
    private XMLRepository.ClassSession currentClass;
    private List<XMLRepository.Student> enrolledStudents;
    private Map<String, XMLRepository.Student> students = new Hashtable<String, XMLRepository.Student>();
    private Map<String, XMLRepository.Teacher> teachers = new Hashtable<String, XMLRepository.Teacher>();
    private List<XMLRepository.ClassSession> classes = new ArrayList<XMLRepository.ClassSession>();

    public SchoolXMLHandler() {
        this.enrolledStudents = new ArrayList<XMLRepository.Student>();
    }

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if ("student".equals(name)) {
            this.currentStudent = new XMLRepository.Student();
        } else if ("teacher".equals(name) && this.currentClass == null) {
            this.currentTeacher = new XMLRepository.Teacher();
        } else if ("class".equals(name)) {
            this.currentClass = new XMLRepository.ClassSession();
            this.currentClass.name = attributes.getValue("name");
            this.currentClass.courseCode = attributes.getValue("courseCode");
        } else if ("identity".equals(name)) {
            XMLRepository.Identity identity = this.currentStudent != null ? this.currentStudent.identity : this.currentTeacher.identity;
            identity.firstName = attributes.getValue("firstName");
            identity.lastName = attributes.getValue("lastName");
            identity.id = attributes.getValue("id");
        } else if ("enrolledStudent".equals(name)) {
            this.enrolledStudents.add(this.students.get(attributes.getValue("idRef")));
        } else if ("teacher".equals(name)) {
            this.currentClass.teacher = this.teachers.get(attributes.getValue("idRef"));
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        if ("student".equals(name)) {
            this.students.put(this.currentStudent.identity.id, this.currentStudent);
            this.currentStudent = null;
        } else if ("teacher".equals(name) && this.currentClass == null) {
            this.teachers.put(this.currentTeacher.identity.id, this.currentTeacher);
            this.currentTeacher = null;
        } else if ("class".equals(name)) {
            this.currentClass.students = this.enrolledStudents.toArray(new XMLRepository.Student[this.enrolledStudents.size()]);
            this.classes.add(this.currentClass);
            this.currentClass = null;
            this.enrolledStudents.clear();
        }
    }

    public XMLRepository.Student[] getStudents() {
        return this.students.values().toArray(new XMLRepository.Student[this.students.size()]);
    }

    public XMLRepository.Teacher[] getTeachers() {
        return this.teachers.values().toArray(new XMLRepository.Teacher[this.teachers.size()]);
    }

    public XMLRepository.ClassSession[] getSchoolClasses() {
        return this.classes.toArray(new XMLRepository.ClassSession[this.classes.size()]);
    }
}

