/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.example.mdr.registration.internal.core;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.cosmos.dc.cmdbf.services.common.INotificationHandlerFactory;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.IQueryHandlerFactory;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IInstanceId;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRelationship;
import org.eclipse.cosmos.dc.mdr.registration.AbstractFederatingCMDB;
import org.eclipse.cosmos.example.mdr.registration.internal.query.CMDBQueryHandlerFactory;
import org.eclipse.cosmos.example.mdr.registration.internal.service.CMDBNotificationHandlerFactory;
import org.eclipse.cosmos.me.management.annotations.ManagedResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedResource
public class SampleFederatingCMDB
extends AbstractFederatingCMDB {
    private Map<String, Map<String, IGraphElement>> itemsMap = new Hashtable<String, Map<String, IGraphElement>>();
    private Map<String, Map<String, IGraphElement>> relationshipsMap = new Hashtable<String, Map<String, IGraphElement>>();
    private Map<IInstanceId, List<IRelationship>> relationshipsMapBySource = new Hashtable<IInstanceId, List<IRelationship>>();

    public SampleFederatingCMDB() {
        Hashtable<String, SampleFederatingCMDB> init = new Hashtable<String, SampleFederatingCMDB>();
        init.put("org.eclipse.cosmos.example.federating.cmdb.internal.core.ISampleCMDBConstants.DATA_PROVIDER", this);
        this.getQueryOperation().initialize(init);
        this.getRegistrationOperation().initialize(init);
        this.getDeregistrationOperation().initialize(init);
    }

    public INotificationHandlerFactory getNotificationHandlerFactory() {
        return CMDBNotificationHandlerFactory.getInstance();
    }

    public IQueryHandlerFactory getQueryHandlerFactory() {
        return CMDBQueryHandlerFactory.getInstance();
    }

    public Map<String, Map<String, IGraphElement>> retrieveItemsMap() {
        return this.itemsMap;
    }

    public Map<String, Map<String, IGraphElement>> retrieveRelationshipsMap() {
        return this.relationshipsMap;
    }

    public Map<IInstanceId, List<IRelationship>> retrieveRelationshipBySource() {
        return this.relationshipsMapBySource;
    }

    public void addElement(IGraphElement element, boolean isItem) {
        IInstanceId[] instanceIds = element.getInstanceIds();
        int i = 0;
        while (i < instanceIds.length) {
            IGraphElement graphElement;
            String mdrId = instanceIds[i].getMdrId().toString();
            String localId = instanceIds[i].getLocalId().toString();
            Map<String, Map<String, IGraphElement>> elements = isItem ? this.itemsMap : this.relationshipsMap;
            Map<String, IGraphElement> mdrElements = elements.get(mdrId);
            if (mdrElements == null) {
                mdrElements = new Hashtable<String, IGraphElement>();
                elements.put(mdrId, mdrElements);
            }
            if ((graphElement = mdrElements.get(localId)) == null) {
                mdrElements.put(localId, element);
            }
            if (!isItem) {
                IRelationship relationship = (IRelationship)element;
                IInstanceId sourceInstanceId = relationship.getSourceId();
                List<IRelationship> storedRelationships = this.relationshipsMapBySource.get(sourceInstanceId);
                if (storedRelationships == null) {
                    storedRelationships = new ArrayList<IRelationship>();
                    this.relationshipsMapBySource.put(sourceInstanceId, storedRelationships);
                }
                if (!storedRelationships.contains(relationship)) {
                    storedRelationships.add(relationship);
                }
            }
            ++i;
        }
    }

    public void removeElement(IGraphElement element, boolean isItem) {
        IInstanceId[] instanceIds = element.getInstanceIds();
        int i = 0;
        while (i < instanceIds.length) {
            Map<String, Map<String, IGraphElement>> elements;
            String mdrId = instanceIds[i].getMdrId().toString();
            String localId = instanceIds[i].getLocalId().toString();
            Map<String, Map<String, IGraphElement>> map = elements = isItem ? this.itemsMap : this.relationshipsMap;
            if ("*".equals(mdrId)) {
                elements.clear();
                if (!isItem) {
                    this.relationshipsMapBySource.clear();
                }
            } else {
                Map<String, IGraphElement> mdrElements = elements.get(mdrId);
                if (mdrElements != null) {
                    IGraphElement[] removedElements;
                    if ("*".equals(localId)) {
                        removedElements = mdrElements.values().toArray(new IGraphElement[mdrElements.size()]);
                        elements.remove(mdrId);
                    } else {
                        IGraphElement elementToBeRemoved = mdrElements.get(localId);
                        removedElements = new IGraphElement[]{elementToBeRemoved};
                        mdrElements.remove(localId);
                        if (mdrElements.isEmpty()) {
                            elements.remove(mdrId);
                        }
                    }
                    if (!isItem) {
                        int j = 0;
                        while (j < removedElements.length) {
                            IInstanceId sourceInsntanceId = ((IRelationship)removedElements[i]).getSourceId();
                            this.relationshipsMapBySource.remove(sourceInsntanceId);
                            ++j;
                        }
                    }
                }
            }
            ++i;
        }
    }
}

