/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.mdr.registration.common.internal;

import javax.xml.namespace.QName;
import org.apache.muse.util.xml.XmlUtils;
import org.eclipse.cosmos.dc.mdr.registration.common.internal.EndPointReferenceSerializer;
import org.eclipse.cosmos.dc.mdr.registration.common.internal.SerializerUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SelectiveRegistrationInputSerializer {
    private static SelectiveRegistrationInputSerializer instance;

    private SelectiveRegistrationInputSerializer() {
    }

    public static SelectiveRegistrationInputSerializer getInstance() {
        if (instance == null) {
            instance = new SelectiveRegistrationInputSerializer();
        }
        return instance;
    }

    public Element toXML(EndPointReferenceSerializer.MDRReference[] mdrIdentifiers, Element queryRequest) {
        Element request = XmlUtils.createElement((QName)new QName("selectiveRegistrationInput"));
        request.appendChild(EndPointReferenceSerializer.getInstance().toXML(mdrIdentifiers));
        Document document = request.getOwnerDocument();
        Node adoptedNode = document.adoptNode(queryRequest);
        if (adoptedNode == null) {
            adoptedNode = document.importNode(queryRequest, true);
        }
        request.appendChild(adoptedNode);
        return request;
    }

    public SelectiveRegistrationRequest fromXML(Element request) {
        Element root = SerializerUtil.findNode(request, "selectiveRegistrationInput");
        if (root == null) {
            return null;
        }
        NodeList children = root.getChildNodes();
        SelectiveRegistrationRequest requestPOJO = new SelectiveRegistrationRequest();
        boolean foundMdrId = false;
        boolean foundEPR = false;
        int i = 0;
        int childCount = children.getLength();
        while (i < childCount) {
            Node child = children.item(i);
            if (1 == child.getNodeType()) {
                if ("mdrAddresses".equals(child.getLocalName())) {
                    EndPointReferenceSerializer.MDRReference[] references = EndPointReferenceSerializer.getInstance().fromXML((Element)child);
                    if (references != null && references.length > 0) {
                        foundMdrId = true;
                        requestPOJO.setMDRReferences(references);
                    }
                } else if ("query".equals(child.getLocalName())) {
                    foundEPR = true;
                    requestPOJO.setQuery((Element)child);
                }
            }
            ++i;
        }
        if (!foundMdrId || !foundEPR) {
            return null;
        }
        return requestPOJO;
    }

    public static class SelectiveRegistrationRequest {
        private EndPointReferenceSerializer.MDRReference[] mdrReferences;
        private Element query;

        public EndPointReferenceSerializer.MDRReference[] getMDRReferences() {
            return this.mdrReferences;
        }

        public void setMDRReferences(EndPointReferenceSerializer.MDRReference[] mdrReferencees) {
            this.mdrReferences = mdrReferencees;
        }

        public Element getQuery() {
            return this.query;
        }

        public void setQuery(Element query) {
            this.query = query;
        }
    }
}

