/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.outputters;

import java.util.Hashtable;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IComponent;
import org.eclipse.hyades.logging.adapter.IContext;
import org.eclipse.hyades.logging.adapter.IOutputter;
import org.eclipse.hyades.logging.adapter.impl.Context;
import org.eclipse.hyades.logging.adapter.impl.Outputter;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.core.LoggingAgent;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.util.EventFormatter;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CBELogOutputter
extends Outputter
implements IOutputter {
    private LoggingAgent cbelogger = null;
    private static String defaultAgentName = "GenericAdapterCBELogger";
    private String agentName = null;
    private int bufferSize = 100;
    private long waitTime = -1L;
    private boolean firstEvents = true;

    public Object[] processEventItems(Object[] msgs) {
        if (msgs == null) {
            return null;
        }
        return this.processCBEs((CommonBaseEvent[])msgs);
    }

    /*
     * Unable to fully structure code
     */
    private CommonBaseEvent[] processCBEs(CommonBaseEvent[] events) {
        block7: {
            cbesReturned = 0;
            if (!this.cbelogger.isAgentControllerAvailable()) {
                event = this.getEventFactory().createCommonBaseEvent();
                event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Log_Outputter_AgentControllerUnavailable_ERROR_");
                event.setSeverity((short)50);
                this.log(event);
                return events;
            }
            if (!this.firstEvents || events.length <= 0 || this.cbelogger.isLogging() || this.waitTime < 0L) break block7;
            event = this.getEventFactory().createCommonBaseEvent();
            event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Logging_Agent_Waiting_INFO_");
            event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), this.getAgentName()});
            event.setSeverity((short)10);
            this.log(event);
            if (this.waitTime <= 0L) ** GOTO lbl23
            this.cbelogger.waitUntilLogging(this.waitTime);
            break block7;
lbl-1000:
            // 1 sources

            {
                event = this.getEventFactory().createCommonBaseEvent();
                event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Logging_Agent_Waiting_INFO_");
                event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), this.getAgentName()});
                event.setSeverity((short)10);
                this.log(event);
lbl23:
                // 2 sources

                ** while (!this.cbelogger.waitUntilLogging((long)1000L))
            }
        }
        if (this.firstEvents && events.length > 0) {
            this.firstEvents = false;
        }
        i = 0;
        while (i < events.length) {
            if (events[i] != null) {
                try {
                    this.cbelogger.write(EventFormatter.toCanonicalXMLString((CommonBaseEvent)events[i], (boolean)false));
                    this.incrementItemsProcessedCount();
                    ++cbesReturned;
                }
                catch (Exception v0) {
                    event = this.getEventFactory().createCommonBaseEvent();
                    event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Logging_Agent_Write_ERROR_");
                    event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), this.getAgentName()});
                    event.setSeverity((short)60);
                    this.log(event);
                }
            }
            ++i;
        }
        this.trace("HyadesGATrace_Component_Processing_End_INFO_", this.getName(), Integer.toString(cbesReturned));
        return events;
    }

    public Object[] testProcessEventItems(Object[] msgs) throws AdapterInvalidConfig {
        if (!(msgs instanceof CommonBaseEvent[])) {
            throw new AdapterInvalidConfig("This outputter will only accept arrays of CommonBaseEvent");
        }
        return this.testProcessCBEs((CommonBaseEvent[])msgs);
    }

    private CommonBaseEvent[] testProcessCBEs(CommonBaseEvent[] events) {
        return events;
    }

    public void update() throws AdapterInvalidConfig {
        super.update();
        Element element = this.getConfiguration();
        Element outputterTypeInstance = null;
        String waittm = null;
        Hashtable outputterProperties = this.getProperties();
        if (outputterProperties != null && !outputterProperties.isEmpty()) {
            waittm = (String)outputterProperties.get("waitUntilLoggingTime");
            if (waittm != null && waittm.length() > 0) {
                this.setWaitTime(Long.valueOf(waittm));
            } else {
                this.setWaitTime(-1L);
            }
            this.setAgentName((String)outputterProperties.get("agentName"));
            String bufSizeStr = (String)outputterProperties.get("bufferSize");
            if (bufSizeStr != null) {
                try {
                    int bufSize = Integer.valueOf(bufSizeStr);
                    this.setBufferSize(bufSize);
                }
                catch (NumberFormatException numberFormatException) {
                    CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                    event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Logging_Agent_Write_ERROR_");
                    event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), this.getAgentName(), "100"});
                    event.setSeverity((short)30);
                    this.log(event);
                }
            }
        } else if (element != null) {
            NodeList outputterNodes = element.getChildNodes();
            int i = 0;
            while (i < outputterNodes.getLength()) {
                Element outputterNode;
                if (outputterNodes.item(i).getNodeType() == 1 && (outputterNode = (Element)outputterNodes.item(i)).getTagName().equals("op:LoggingAgentOutputterType")) {
                    String bufSizeStr;
                    String wtime;
                    outputterTypeInstance = outputterNode;
                    if (outputterTypeInstance.hasAttribute("waitUntilLoggingTime") && (wtime = outputterTypeInstance.getAttribute("waitUntilLoggingTime")) != null && !wtime.equals("")) {
                        this.setWaitTime(Long.valueOf(wtime));
                    }
                    if (outputterTypeInstance.hasAttribute("agentName")) {
                        this.setAgentName(outputterTypeInstance.getAttribute("agentName"));
                    }
                    if (outputterTypeInstance.hasAttribute("bufferSize") && (bufSizeStr = outputterTypeInstance.getAttribute("bufferSize")) != null) {
                        try {
                            int bufSize = Integer.valueOf(bufSizeStr);
                            this.setBufferSize(bufSize);
                        }
                        catch (NumberFormatException numberFormatException) {
                            CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                            event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Logging_Agent_Write_ERROR_");
                            event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), this.getAgentName(), "100"});
                            event.setSeverity((short)30);
                            this.log(event);
                        }
                    }
                }
                ++i;
            }
        }
        boolean validating = false;
        IComponent current = this;
        while (current != null) {
            if (current instanceof IContext) {
                IContext context = (IContext)current;
                if (!(context instanceof Context)) break;
                validating = ((Context)context).isValidating();
                break;
            }
            current = current.getParent();
        }
        if (this.cbelogger == null && !validating && !this.isDisabled()) {
            String logAgentName = this.getAgentName() == null ? defaultAgentName : this.getAgentName();
            this.cbelogger = new LoggingAgent(logAgentName, this.bufferSize);
            if (!this.cbelogger.isAgentControllerAvailable()) {
                throw new AdapterInvalidConfig(Messages.getString("HyadesGA_CBE_Log_Outputter_AgentControllerUnavailable_ERROR_"));
            }
        }
        this.firstEvents = true;
    }

    public void setAgentName(String aName) {
        this.agentName = aName;
        this.updateConfigurationPropertyChild("agentName", aName);
    }

    public String getAgentName() {
        return this.agentName;
    }

    public void setBufferSize(int bufSize) {
        this.bufferSize = bufSize;
        this.updateConfigurationPropertyChild("bufferSize", Integer.toString(bufSize));
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setWaitTime(long wTime) {
        this.waitTime = wTime;
        this.updateConfigurationPropertyChild("waitUntilLoggingTime", Long.toString(wTime));
    }

    public long getWaitTime() {
        return this.waitTime;
    }

    public void stop() {
        if (this.cbelogger != null) {
            this.cbelogger.deregister();
        }
    }
}

