/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.dmtoolkit.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.cosmos.me.dmtoolkit.common.DMToolkitCommonPlugin;
import org.eclipse.cosmos.me.dmtoolkit.common.ui.artifacts.IProjectConfig;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;

public class Utilities {
    public static final String SRC_FOLDER = "src";

    public static String getDataManagerClassContents(IProjectConfig config) {
        StringWriter writer = new StringWriter();
        String nl = System.getProperty("line.separator");
        if (!config.getPackageName().equals("")) {
            writer.append("package " + config.getPackageName() + ";" + nl);
            writer.append(nl);
        }
        int i = 0;
        while (i < config.getImportPackages().length) {
            writer.append("import " + config.getImportPackages()[i] + ";" + nl);
            ++i;
        }
        if (config.getImportPackages().length > 0) {
            writer.append(nl);
        }
        writer.append("@ManagedResource" + nl);
        writer.append("public class " + config.getGeneratedClassName() + " extends " + config.getParentClassName() + " {" + nl);
        writer.append("\tpublic " + config.getGeneratedClassName() + "() {" + nl);
        writer.append("\t\t" + Utilities.getGeneratedConstructorComment() + nl);
        writer.append("\t}" + nl);
        writer.append("}" + nl);
        return writer.toString();
    }

    protected static String getGeneratedConstructorComment() {
        return "// TODO Auto-generated constructor method stub";
    }

    public static void createProjectClass(IProject project, IProjectConfig config, IProgressMonitor monitor, String classSource, String className) {
        IFolder folder = project.getFolder(SRC_FOLDER);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IPackageFragmentRoot fragRoot = javaProject.getPackageFragmentRoot((IResource)folder);
        IPackageFragment fragment = null;
        try {
            fragment = fragRoot.createPackageFragment(config.getPackageName(), true, monitor);
            fragment.createCompilationUnit(String.valueOf(className) + ".java", classSource, true, monitor);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        if (monitor != null) {
            monitor.worked(1);
        }
    }

    public static void createDataManagerClass(IProject project, IProjectConfig config, IProgressMonitor monitor) throws CoreException {
        Utilities.createProjectClass(project, config, monitor, config.getClassSource(), config.getGeneratedClassName());
    }

    public static Text createLabelTextPair(Composite composite, String labelString, String initialFieldValue, boolean multi) {
        Label label = new Label(composite, 16384);
        label.setLayoutData((Object)new GridData(2));
        label.setText(labelString);
        int otherStyle = multi ? 66 : 4;
        Text textField = new Text(composite, 0x800 | otherStyle);
        textField.setLayoutData((Object)(multi ? new GridData(1808) : Utilities.gdhfill()));
        textField.setText(initialFieldValue);
        return textField;
    }

    public static GridData gdhfill() {
        return new GridData(768);
    }

    public static String populateResourceTemplate(String[] substitutionMap, String resourceLocation) throws CoreException {
        return Utilities.populateResourceTemplate(substitutionMap, resourceLocation, DMToolkitCommonPlugin.getDefault().getBundle());
    }

    public static String populateResourceTemplate(String[] substitutionMap, String resourceLocation, Bundle bundle) throws CoreException {
        StringWriter writer = new StringWriter();
        String nl = System.getProperty("line.separator");
        URL initializerSource = bundle.getResource(resourceLocation);
        InputStream inputStream = null;
        try {
            inputStream = initializerSource.openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            String line = null;
            while ((line = reader.readLine()) != null) {
                int i = 0;
                while (i < substitutionMap.length) {
                    line = line.replace(substitutionMap[i], substitutionMap[i + 1]);
                    i += 2;
                }
                writer.append(line);
                writer.append(nl);
            }
            reader.close();
            inputStream.close();
        }
        catch (IOException e) {
            throw DMToolkitCommonPlugin.createCoreException(e);
        }
        return writer.toString();
    }
}

