/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.dmtoolkit.common.ui;

import org.eclipse.cosmos.me.dmtoolkit.common.Messages;
import org.eclipse.cosmos.me.dmtoolkit.common.Utilities;
import org.eclipse.cosmos.me.dmtoolkit.common.ui.artifacts.IProjectConfig;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DataManagerConfigPage
extends WizardPage {
    private IProjectConfig model = null;
    private Text packageNameTextField;
    private Text classNameTextField;
    private Text resourceIdTextField;
    private Text displayNameTextField;
    private Text descriptionTextField;

    protected DataManagerConfigPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        String packageNameFieldInitialContents = this.getModel().getPackageName();
        this.packageNameTextField = Utilities.createLabelTextPair(composite, Messages.wizardPagePackageNameField, packageNameFieldInitialContents, false);
        String generatedClassNameInitialContents = this.getModel().getGeneratedClassName();
        this.classNameTextField = Utilities.createLabelTextPair(composite, Messages.wizardPageGeneratedClassNameField, generatedClassNameInitialContents, false);
        String resourceIdInitialContents = this.getModel().getResourceId();
        this.resourceIdTextField = Utilities.createLabelTextPair(composite, Messages.wizardPageResourceIDField, resourceIdInitialContents, false);
        String displayNameLabelString = Messages.wizardPageDisplayNameField;
        String displayNameInitialContents = this.getModel().getDisplayName();
        this.displayNameTextField = Utilities.createLabelTextPair(composite, displayNameLabelString, displayNameInitialContents, false);
        String descriptionLabelString = Messages.wizardPageDescriptionField;
        String descriptionInitialContents = this.getModel().getDescription();
        this.descriptionTextField = Utilities.createLabelTextPair(composite, descriptionLabelString, descriptionInitialContents, true);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    public void setModel(Object model) {
        this.model = (IProjectConfig)model;
    }

    public IProjectConfig getModel() {
        return this.model;
    }

    public void transferStateToModel() {
        this.getModel().setGeneratedClassName(this.classNameTextField.getText());
        this.getModel().setPackageName(this.packageNameTextField.getText());
        this.getModel().setResourceId(this.resourceIdTextField.getText());
        this.getModel().setDescription(this.descriptionTextField.getText());
        this.getModel().setDisplayName(this.displayNameTextField.getText());
    }
}

