/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.dmtoolkit.common.ui;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.dmtoolkit.common.Messages;
import org.eclipse.cosmos.me.dmtoolkit.common.ui.artifacts.IProjectConfig;
import org.eclipse.cosmos.me.dmtoolkit.common.ui.artifacts.IReferenceParameterTuple;
import org.eclipse.cosmos.me.dmtoolkit.common.ui.artifacts.ToolkitArtifactFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.snippets.viewers.CursorCellHighlighter;
import org.eclipse.jface.snippets.viewers.TableCursor;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class DataManagerEPRPage
extends WizardPage {
    public static final String PREFIX_COLUMN = Messages.wizardPageEPRPrefixColumn;
    public static final String NAME_COLUMN = Messages.wizardPageEPRNameColumn;
    public static final String NAMESPACE_COLUMN = Messages.wizardPageEPRNamespaceColumn;
    public static final String VALUE_COLUMN = Messages.wizardPageEPRValueColumn;
    private IProjectConfig model = null;
    private Text uriTextField;
    private TableViewer referenceParametersTableViewer;

    protected DataManagerEPRPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(composite, 16384);
        label.setLayoutData((Object)new GridData(2));
        label.setText(Messages.wizardPageEPRURILabel);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.uriTextField = new Text(composite, 2052);
        this.uriTextField.setLayoutData((Object)gridData);
        this.uriTextField.setText(this.getModel().getEprUri());
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        Label referenceParametersLabel = new Label(composite, 16384);
        referenceParametersLabel.setLayoutData((Object)gridData);
        referenceParametersLabel.setText(Messages.wizardPageEPRReferenceParametersLabel);
        this.createRuleBindingsTable(composite);
        this.createAddRemoveButtons(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    public void setModel(Object model) {
        this.model = (IProjectConfig)model;
    }

    public IProjectConfig getModel() {
        return this.model;
    }

    public void transferStateToModel() {
        this.getModel().setEprUri(this.uriTextField.getText());
        this.getModel().setReferenceParameters((ArrayList)this.referenceParametersTableViewer.getInput());
    }

    protected void createAddRemoveButtons(Composite parent) {
        Composite buttonComposite = DataManagerEPRPage.createVerticalButtonPanel(parent);
        Button addButton = DataManagerEPRPage.createVerticalButtonPanelButton(buttonComposite, Messages.wizardPageEPRAddButton);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DataManagerEPRPage.this.addButtonClicked();
            }
        });
        Button removeButton = DataManagerEPRPage.createVerticalButtonPanelButton(buttonComposite, Messages.wizardPageEPRRemoveButton);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DataManagerEPRPage.this.removeButtonClicked();
            }
        });
    }

    protected void removeButtonClicked() {
        IStructuredSelection selection = (IStructuredSelection)this.referenceParametersTableViewer.getSelection();
        ((Collection)this.referenceParametersTableViewer.getInput()).removeAll(selection.toList());
        this.referenceParametersTableViewer.refresh();
    }

    protected void addButtonClicked() {
        IReferenceParameterTuple tuple = ToolkitArtifactFactory.createReferenceParameterTuple();
        ((Collection)this.referenceParametersTableViewer.getInput()).add(tuple);
        this.referenceParametersTableViewer.refresh();
        this.referenceParametersTableViewer.editElement((Object)tuple, 0);
    }

    protected static Button createVerticalButtonPanelButton(Composite buttonComposite, String buttonText) {
        Button button = new Button(buttonComposite, 0);
        button.setText(buttonText);
        GridData buttonData = new GridData(256);
        buttonData.verticalAlignment = 1;
        button.setLayoutData((Object)buttonData);
        return button;
    }

    protected static Composite createVerticalButtonPanel(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 1;
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttonComposite.setLayout((Layout)buttonLayout);
        GridData buttonCompositeData = new GridData();
        buttonCompositeData.verticalAlignment = 4;
        buttonComposite.setLayoutData((Object)buttonCompositeData);
        return buttonComposite;
    }

    protected void createRuleBindingsTable(Composite parent) {
        this.referenceParametersTableViewer = new TableViewer(parent, 67586);
        this.setTableProperties();
    }

    protected void setTableProperties() {
        TableLayout layout = new TableLayout();
        Table ruleBindingsTable = this.referenceParametersTableViewer.getTable();
        ruleBindingsTable.setLayout((Layout)layout);
        ruleBindingsTable.setLinesVisible(true);
        ruleBindingsTable.setLayoutData((Object)new GridData(4, -1, true, false));
        ruleBindingsTable.setHeaderVisible(true);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 50;
        gridData.horizontalSpan = 2;
        ruleBindingsTable.setLayoutData((Object)gridData);
        String[] columnNames = new String[]{PREFIX_COLUMN, NAMESPACE_COLUMN, NAME_COLUMN, VALUE_COLUMN};
        String[] columnProperties = new String[]{PREFIX_COLUMN, NAMESPACE_COLUMN, NAME_COLUMN, VALUE_COLUMN};
        ColumnPixelData columnLayout = new ColumnPixelData(100, true);
        TableColumn column = null;
        int i = 0;
        while (i < columnNames.length) {
            column = new TableColumn(ruleBindingsTable, 16384);
            column.setResizable(columnLayout.resizable);
            column.setText(columnNames[i]);
            layout.addColumnData((ColumnLayoutData)columnLayout);
            ++i;
        }
        this.referenceParametersTableViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this.referenceParametersTableViewer.getTable()), new TextCellEditor((Composite)this.referenceParametersTableViewer.getTable()), new TextCellEditor((Composite)this.referenceParametersTableViewer.getTable()), new TextCellEditor((Composite)this.referenceParametersTableViewer.getTable())});
        this.referenceParametersTableViewer.setCellModifier((ICellModifier)new ReferenceParametersTableCellModifier(this));
        this.referenceParametersTableViewer.setColumnProperties(columnProperties);
        this.referenceParametersTableViewer.setLabelProvider((IBaseLabelProvider)new RuntimeParametersLabelProvider());
        this.referenceParametersTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.referenceParametersTableViewer.setInput(this.getModel().getReferenceParameters());
        TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager(this.referenceParametersTableViewer, (FocusCellHighlighter)new CursorCellHighlighter((ColumnViewer)this.referenceParametersTableViewer, new TableCursor((AbstractTableViewer)this.referenceParametersTableViewer)));
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.referenceParametersTableViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 3 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
            }
        };
        TableViewerEditor.create((TableViewer)this.referenceParametersTableViewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
    }

    public class ReferenceParametersTableCellModifier
    implements ICellModifier {
        private DataManagerEPRPage wizardPage;

        public ReferenceParametersTableCellModifier(DataManagerEPRPage wizardPage) {
            this.wizardPage = wizardPage;
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            if (property == PREFIX_COLUMN) {
                return ((IReferenceParameterTuple)element).getPrefix();
            }
            if (property == NAME_COLUMN) {
                return ((IReferenceParameterTuple)element).getName();
            }
            if (property == NAMESPACE_COLUMN) {
                return ((IReferenceParameterTuple)element).getNamespace();
            }
            if (property == VALUE_COLUMN) {
                return ((IReferenceParameterTuple)element).getValue();
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            if (value == null) {
                return;
            }
            IReferenceParameterTuple tuple = element instanceof TableItem ? (IReferenceParameterTuple)((TableItem)element).getData() : (IReferenceParameterTuple)element;
            String text = ((String)value).trim();
            if (property == PREFIX_COLUMN) {
                tuple.setPrefix(text);
            }
            if (property == NAME_COLUMN) {
                tuple.setName(text);
            }
            if (property == NAMESPACE_COLUMN) {
                tuple.setNamespace(text);
            }
            if (property == VALUE_COLUMN) {
                tuple.setValue(text);
            }
            this.wizardPage.referenceParametersTableViewer.refresh();
        }
    }

    private class RuntimeParametersLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private RuntimeParametersLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            IReferenceParameterTuple tuple = (IReferenceParameterTuple)element;
            switch (columnIndex) {
                case 0: {
                    return tuple.getPrefix();
                }
                case 1: {
                    return tuple.getNamespace();
                }
                case 2: {
                    return tuple.getName();
                }
                case 3: {
                    return tuple.getValue();
                }
            }
            return String.valueOf(Messages.wizardPageEPRUnknown) + columnIndex;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

