/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.dmtoolkit.common.ui;

import org.eclipse.cosmos.me.dmtoolkit.common.Messages;
import org.eclipse.cosmos.me.dmtoolkit.common.ui.artifacts.IProjectConfig;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class MDRServicesPage
extends WizardPage {
    private IProjectConfig model = null;
    private Button queryServiceCheckbox;
    private Button registrationServiceCheckbox;

    protected MDRServicesPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(composite, 16384);
        label.setLayoutData((Object)new GridData(2));
        label.setText(Messages.wizardPageMdrServicesLabel);
        GridData gridData = new GridData(768);
        this.queryServiceCheckbox = new Button(composite, 32);
        this.queryServiceCheckbox.setText(Messages.wizardPageMdrQueryServiceCheckbox);
        this.queryServiceCheckbox.setLayoutData((Object)gridData);
        this.queryServiceCheckbox.setSelection(this.getModel().getImplementQueryService());
        gridData = new GridData(768);
        this.registrationServiceCheckbox = new Button(composite, 32);
        this.registrationServiceCheckbox.setText(Messages.wizardPageMdrRegistrationServiceCheckbox);
        this.registrationServiceCheckbox.setLayoutData((Object)gridData);
        this.registrationServiceCheckbox.setSelection(this.getModel().getImplementRegistrationService());
        this.queryServiceCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MDRServicesPage.this.checkServiceSelections();
            }
        });
        this.registrationServiceCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MDRServicesPage.this.checkServiceSelections();
            }
        });
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    public void setModel(Object model) {
        this.model = (IProjectConfig)model;
    }

    public IProjectConfig getModel() {
        return this.model;
    }

    public void transferStateToModel() {
        this.getModel().setImplementQueryService(this.queryServiceCheckbox.getSelection());
        this.getModel().setImplementRegistrationService(this.registrationServiceCheckbox.getSelection());
    }

    protected void checkServiceSelections() {
        if (!this.queryServiceCheckbox.getSelection() && this.registrationServiceCheckbox.getSelection()) {
            this.setErrorMessage(Messages.wizardPageMdrErrorRegistrationServiceWithoutQueryService);
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }
}

