/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.dmtoolkit.common.ui.internal;

import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.cosmos.me.dmtoolkit.common.Messages;
import org.eclipse.cosmos.me.dmtoolkit.common.ui.artifacts.IProjectConfig;
import org.eclipse.cosmos.me.dmtoolkit.common.ui.artifacts.IReferenceParameterTuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProjectConfig
implements IProjectConfig {
    private String packageName = null;
    private String generatedClassName = null;
    private String resourceId = "";
    private String displayName = "";
    private String description = "";
    private String eprUri = "";
    private ArrayList referenceParameters = new ArrayList();

    @Override
    public String getPackageName() {
        if (this.packageName == null) {
            this.packageName = this.defaultPackageName();
        }
        return this.packageName;
    }

    protected String defaultPackageName() {
        return Messages.projectConfigPackageNameDefault;
    }

    @Override
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Override
    public String getGeneratedClassName() {
        if (this.generatedClassName == null) {
            this.generatedClassName = this.defaultGeneratedClassName();
        }
        return this.generatedClassName;
    }

    protected abstract String defaultGeneratedClassName();

    @Override
    public void setGeneratedClassName(String generatedClassName) {
        this.generatedClassName = generatedClassName;
    }

    @Override
    public String getResourceId() {
        return this.resourceId;
    }

    @Override
    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public abstract String getProjectTypeName();

    @Override
    public Properties toProperties() {
        Properties props = new Properties();
        props.put("RESOURCE_ID", this.getResourceId());
        props.put("DISPLAY_NAME", this.getDisplayName());
        props.put("DESCRIPTION", this.getDescription());
        props.put("MGMT_DOMAIN_EPR_FILE", "domainEPR.xml");
        return props;
    }

    @Override
    public String getOverriddenMethodContents() {
        return "";
    }

    @Override
    public abstract String getParentClassName();

    @Override
    public String[] getImportPackages() {
        String[] pkgs = new String[]{"org.eclipse.cosmos.dc.dataManager.impl.AbstractDataManager", "org.eclipse.cosmos.me.management.annotations.ManagedResource"};
        return pkgs;
    }

    @Override
    public abstract String getClassSource() throws CoreException;

    @Override
    public String getEprUri() {
        return this.eprUri;
    }

    @Override
    public void setEprUri(String eprUri) {
        this.eprUri = eprUri;
    }

    @Override
    public void addReferenceParameter(IReferenceParameterTuple parameter) {
        this.referenceParameters.add(parameter);
    }

    @Override
    public ArrayList<IReferenceParameterTuple> getReferenceParameters() {
        return (ArrayList)this.referenceParameters.clone();
    }

    @Override
    public void setReferenceParameters(ArrayList<IReferenceParameterTuple> tupleList) {
        this.referenceParameters = tupleList;
    }

    @Override
    public boolean getImplementQueryService() {
        return false;
    }

    @Override
    public boolean getImplementRegistrationService() {
        return false;
    }

    @Override
    public void setImplementQueryService(boolean implement) {
    }

    @Override
    public void setImplementRegistrationService(boolean implement) {
    }
}

