/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.dmtoolkit.common.ui.internal;

import java.io.StringWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.cosmos.me.dmtoolkit.common.Messages;
import org.eclipse.cosmos.me.dmtoolkit.common.Utilities;
import org.eclipse.cosmos.me.dmtoolkit.common.ui.internal.AbstractProjectConfig;

public class MDRProjectConfig
extends AbstractProjectConfig {
    private boolean implementQueryService = true;
    private boolean implementRegistrationService = false;

    protected String defaultGeneratedClassName() {
        return this.getImplementRegistrationService() ? Messages.projectConfigFederatingCMDBClassNameDefault : Messages.projectConfigMDRClassNameDefault;
    }

    public String getProjectTypeName() {
        return Messages.projectConfigMDRType;
    }

    public String getParentClassName() {
        String fullName = this.getParentClassNameFull();
        return fullName.substring(fullName.lastIndexOf(46) + 1);
    }

    public String[] getImportPackages() {
        return null;
    }

    public String getMdrImports() {
        StringWriter writer = new StringWriter();
        if (this.getImplementRegistrationService()) {
            writer.write("import org.eclipse.cosmos.dc.cmdbf.services.common.INotificationHandlerFactory;\n");
        }
        return writer.toString();
    }

    public boolean getImplementQueryService() {
        return this.implementQueryService;
    }

    public void setImplementQueryService(boolean implementQueryService) {
        this.implementQueryService = implementQueryService;
    }

    public boolean getImplementRegistrationService() {
        return this.implementRegistrationService;
    }

    public void setImplementRegistrationService(boolean implementRegistrationService) {
        this.implementRegistrationService = implementRegistrationService;
    }

    public String getClassSource() throws CoreException {
        String[] substitutionMap = new String[]{"%PACKAGE_NAME%", this.getPackageName(), "%EXTRA_IMPORTS%", this.getMdrImports(), "%MDR_CLASS%", this.getGeneratedClassName(), "%ABSTRACT_PARENT_CLASS_FULL%", this.getParentClassNameFull(), "%ABSTRACT_PARENT_CLASS%", this.getParentClassName(), "%OPERATION_INITS%", this.getOperationInits(), "%REG_SERVICE_METHOD_OVERRIDE%", this.getRegistrationServiceOverride()};
        String resourceLocation = "resources/mdrTemplate.txt";
        return Utilities.populateResourceTemplate(substitutionMap, resourceLocation);
    }

    protected String getParentClassNameFull() {
        return this.getImplementRegistrationService() ? "org.eclipse.cosmos.dc.mdr.registration.AbstractFederatingCMDB" : "org.eclipse.cosmos.dc.mdr.impl.AbstractMdr";
    }

    protected String getRegistrationServiceOverride() throws CoreException {
        if (!this.getImplementRegistrationService()) {
            return "";
        }
        return Utilities.populateResourceTemplate(new String[0], "resources/regServiceMethodOverride.txt");
    }

    protected String getOperationInits() {
        StringWriter writer = new StringWriter();
        if (this.getImplementQueryService()) {
            writer.write("\n\t\tgetQueryOperation().initialize(init);");
        }
        if (this.getImplementRegistrationService()) {
            writer.write("\n\t\tgetRegistrationOperation().initialize(init);");
            writer.write("\n\t\tgetDeregistrationOperation().initialize(init);");
        }
        return writer.toString();
    }
}

