/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.snippets.viewers;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public abstract class AbstractCellCursor
extends Canvas {
    private ViewerCell[] cells = new ViewerCell[0];
    private ColumnViewer viewer;
    private int activationTime = 0;
    private boolean inFocusRequest = false;

    public AbstractCellCursor(ColumnViewer viewer, int style) {
        super((Composite)viewer.getControl(), style);
        this.viewer = viewer;
        Listener l = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 9: {
                        AbstractCellCursor.this.paint(event);
                        break;
                    }
                    case 1: {
                        AbstractCellCursor.this.getParent().notifyListeners(1, event);
                        ArrayList<Object> list = new ArrayList<Object>();
                        int i = 0;
                        while (i < AbstractCellCursor.this.cells.length) {
                            list.add(AbstractCellCursor.this.cells[i].getElement());
                            ++i;
                        }
                        AbstractCellCursor.this.viewer.setSelection((ISelection)new StructuredSelection(list));
                        break;
                    }
                    case 3: {
                        if (event.time < AbstractCellCursor.this.activationTime) {
                            Event cEvent = AbstractCellCursor.this.copyEvent(event);
                            cEvent.type = 8;
                            AbstractCellCursor.this.getParent().notifyListeners(8, cEvent);
                            break;
                        }
                        AbstractCellCursor.this.getParent().notifyListeners(3, AbstractCellCursor.this.copyEvent(event));
                        break;
                    }
                    case 8: {
                        AbstractCellCursor.this.getParent().notifyListeners(8, AbstractCellCursor.this.copyEvent(event));
                        break;
                    }
                    case 15: {
                        if (!AbstractCellCursor.this.isVisible()) break;
                        AbstractCellCursor.this.inFocusRequest = true;
                        if (!AbstractCellCursor.this.inFocusRequest) {
                            AbstractCellCursor.this.forceFocus();
                        }
                        AbstractCellCursor.this.inFocusRequest = false;
                    }
                }
            }
        };
        this.addListener(9, l);
        this.addListener(1, l);
        this.addListener(3, l);
        this.addListener(8, l);
        this.getParent().addListener(15, l);
    }

    public void setSelection(ViewerCell cell, int eventTime) {
        this.cells = new ViewerCell[]{cell};
        this.setBounds(cell.getBounds());
        this.forceFocus();
        this.redraw();
        this.activationTime = eventTime + this.getDisplay().getDoubleClickTime();
    }

    protected ViewerCell[] getSelectedCells() {
        return this.cells;
    }

    private Event copyEvent(Event event) {
        Event cEvent = new Event();
        cEvent.button = event.button;
        cEvent.character = event.character;
        cEvent.count = event.count;
        cEvent.data = event.data;
        cEvent.detail = event.detail;
        cEvent.display = event.display;
        cEvent.doit = event.doit;
        cEvent.end = event.end;
        cEvent.gc = event.gc;
        cEvent.height = event.height;
        cEvent.index = event.index;
        cEvent.item = this.getSelectedCells()[0].getControl();
        cEvent.keyCode = event.keyCode;
        cEvent.start = event.start;
        cEvent.stateMask = event.stateMask;
        cEvent.text = event.text;
        cEvent.time = event.time;
        cEvent.type = event.type;
        cEvent.widget = event.widget;
        cEvent.width = event.width;
        Point p = this.viewer.getControl().toControl(this.toDisplay(event.x, event.y));
        cEvent.x = p.x;
        cEvent.y = p.y;
        return cEvent;
    }

    protected abstract void paint(Event var1);
}

