/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.snippets.viewers;

import org.eclipse.jface.snippets.viewers.AbstractCellCursor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationListener;
import org.eclipse.jface.viewers.ColumnViewerEditorDeactivationEvent;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.ViewerCell;

public class CursorCellHighlighter
extends FocusCellHighlighter {
    private ColumnViewer viewer;
    private AbstractCellCursor cursor;

    public CursorCellHighlighter(ColumnViewer viewer, AbstractCellCursor cursor) {
        super(viewer);
        this.viewer = viewer;
        this.cursor = cursor;
    }

    protected void focusCellChanged(ViewerCell cell) {
        super.focusCellChanged(cell);
        if (!this.viewer.isCellEditorActive()) {
            System.err.println("SHOW EDITOR");
            this.cursor.setSelection(cell, 0);
            this.cursor.setVisible(true);
        }
    }

    protected void init() {
        this.hookListener();
    }

    private void hookListener() {
        ColumnViewerEditorActivationListener listener = new ColumnViewerEditorActivationListener(){

            public void afterEditorActivated(ColumnViewerEditorActivationEvent event) {
            }

            public void afterEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
                CursorCellHighlighter.this.cursor.setVisible(true);
                CursorCellHighlighter.this.cursor.setSelection(CursorCellHighlighter.this.getFocusCell(), 0);
            }

            public void beforeEditorActivated(ColumnViewerEditorActivationEvent event) {
                CursorCellHighlighter.this.cursor.setVisible(false);
            }

            public void beforeEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
            }
        };
        this.viewer.getColumnViewerEditor().addEditorActivationListener(listener);
    }
}

