/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.snippets.viewers;

import org.eclipse.jface.snippets.viewers.AbstractCellCursor;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Table;

public class TableCursor
extends AbstractCellCursor {
    public TableCursor(AbstractTableViewer viewer) {
        super((ColumnViewer)viewer, 0);
    }

    protected void paint(Event event) {
        String text;
        if (this.getSelectedCells().length == 1 && this.getSelectedCells()[0] == null) {
            return;
        }
        ViewerCell cell = this.getSelectedCells()[0];
        GC gc = event.gc;
        Display display = this.getDisplay();
        gc.setBackground(this.getBackground());
        gc.setForeground(this.getForeground());
        gc.fillRectangle(event.x, event.y, event.width, event.height);
        int x = 0;
        Point size = this.getSize();
        Image image = cell.getImage();
        if (image != null) {
            Rectangle imageSize = image.getBounds();
            int imageY = (size.y - imageSize.height) / 2;
            gc.drawImage(image, x, imageY);
            x += imageSize.width;
        }
        if ((text = cell.getText()) != "") {
            int alignmnent;
            Rectangle bounds = cell.getBounds();
            Point extent = gc.stringExtent(text);
            String platform = SWT.getPlatform();
            if ("win32".equals(platform)) {
                if (((Table)this.getParent()).getColumnCount() == 0 || cell.getColumnIndex() == 0) {
                    x += 2;
                } else {
                    alignmnent = ((Table)this.getParent()).getColumn(cell.getColumnIndex()).getAlignment();
                    switch (alignmnent) {
                        case 16384: {
                            x += 6;
                            break;
                        }
                        case 131072: {
                            x = bounds.width - extent.x - 6;
                            break;
                        }
                        case 0x1000000: {
                            x += (bounds.width - x - extent.x) / 2;
                        }
                    }
                }
            } else if (((Table)this.getParent()).getColumnCount() == 0) {
                x += 5;
            } else {
                alignmnent = ((Table)this.getParent()).getColumn(cell.getColumnIndex()).getAlignment();
                switch (alignmnent) {
                    case 16384: {
                        x += 5;
                        break;
                    }
                    case 131072: {
                        x = bounds.width - extent.x - 2;
                        break;
                    }
                    case 0x1000000: {
                        x += (bounds.width - x - extent.x) / 2 + 2;
                    }
                }
            }
            int textY = (size.y - extent.y) / 2;
            gc.drawString(text, x, textY);
        }
        if (this.isFocusControl()) {
            gc.setBackground(display.getSystemColor(2));
            gc.setForeground(display.getSystemColor(1));
            gc.drawFocus(0, 0, size.x, size.y);
        }
    }
}

