/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.common;

import java.util.HashMap;
import org.eclipse.cosmos.dc.common.ConsoleExtension;
import org.eclipse.cosmos.dc.common.spi.BindingService;
import org.eclipse.cosmos.dc.common.spi.ServiceRegistry;
import org.eclipse.cosmos.dc.runtime.osgi.OSGiRuntimeHost;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class Activator
implements BundleActivator,
ServiceListener,
ServiceRegistry {
    private static final String BINDING_FILTER = "(objectclass=org.eclipse.cosmos.dc.common.spi.BindingService)";
    private ConsoleExtension commands;
    private HashMap<String, BindingService> bindingMap = new HashMap();
    private HashMap<ServiceReference, String> referenceMap = new HashMap();
    private BundleContext context;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        context.addServiceListener((ServiceListener)this, BINDING_FILTER);
        ServiceReference[] refs = context.getAllServiceReferences("org.eclipse.cosmos.dc.common.spi.BindingService", BINDING_FILTER);
        if (refs != null) {
            ServiceReference[] serviceReferenceArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference ref = serviceReferenceArray[n2];
                BindingService binding = (BindingService)context.getService(ref);
                this.bindingMap.put(binding.getNamespace(), binding);
                this.referenceMap.put(ref, binding.getNamespace());
                ++n2;
            }
        }
        OSGiRuntimeHost.setRegistry(this);
        this.commands = new ConsoleExtension(context);
    }

    public void stop(BundleContext context) throws Exception {
        this.commands.stop();
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference ref = null;
        String namespace = null;
        switch (event.getType()) {
            case 2: {
                break;
            }
            case 1: {
                ref = event.getServiceReference();
                BindingService binding = (BindingService)this.context.getService(ref);
                this.referenceMap.put(ref, binding.getNamespace());
                this.bindingMap.put(binding.getNamespace(), binding);
                break;
            }
            case 4: {
                namespace = this.referenceMap.get(ref);
                if (namespace == null) break;
                this.bindingMap.remove(namespace);
            }
        }
    }

    public BindingService getBindingServiceForNamespace(String namespace) {
        return this.bindingMap.get(namespace);
    }
}

