/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.common.registry.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.muse.core.serializer.Serializer;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.util.xml.XsdUtils;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.eclipse.cosmos.dc.common.registry.DataFlow;
import org.eclipse.cosmos.dc.common.registry.DataSet;
import org.eclipse.cosmos.dc.common.registry.DataSource;
import org.eclipse.cosmos.dc.common.registry.DataSourceType;
import org.eclipse.cosmos.dc.common.registry.Dimension;
import org.eclipse.cosmos.dc.common.registry.DimensionSet;
import org.eclipse.cosmos.dc.common.registry.ProviderRegistry;
import org.eclipse.cosmos.dc.common.registry.impl.SimpleDataFlow;
import org.eclipse.cosmos.dc.common.registry.impl.SimpleDataSet;
import org.eclipse.cosmos.dc.common.registry.impl.SimpleDataSource;
import org.eclipse.cosmos.dc.common.registry.impl.SimpleDataSourceType;
import org.eclipse.cosmos.dc.common.registry.impl.SimpleDimension;
import org.eclipse.cosmos.dc.common.registry.impl.SimpleDimensionSet;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RegistrySerializer
implements Serializer {
    private static RegistrySerializer dataSourceSerializer = new RegistrySerializer(DataSource.class);
    private static RegistrySerializer dataSourceTypeSerializer = new RegistrySerializer(DataSourceType.class);
    private static RegistrySerializer dataFlowSerializer = new RegistrySerializer(DataFlow.class);
    private static RegistrySerializer dataSetSerializer = new RegistrySerializer(DataSet.class);
    private static RegistrySerializer keySetSerializer = new RegistrySerializer(DimensionSet.class);
    private static final int DATASET_TYPE = 0;
    private static final int DATAFLOW_TYPE = 1;
    private static final int DATASOURCE_TYPE = 2;
    private static final int DATASOURCETYPE_TYPE = 3;
    private static final int KEYSET_TYPE = 4;
    private static final int INVALID_TYPE = -1;
    private Class type;
    private int switchType = -1;

    public static RegistrySerializer getDataFlowSerializer() {
        return dataFlowSerializer;
    }

    public static RegistrySerializer getDataSetSerializer() {
        return dataSetSerializer;
    }

    public static RegistrySerializer getDataSourceSerializer() {
        return dataSourceSerializer;
    }

    public static RegistrySerializer getDataSourceTypeSerializer() {
        return dataSourceTypeSerializer;
    }

    public static RegistrySerializer getKeySetSerializer() {
        return keySetSerializer;
    }

    private RegistrySerializer(Class type) {
        this.type = type;
        if (DataSet.class.isAssignableFrom(type)) {
            this.switchType = 0;
        } else if (DataFlow.class.isAssignableFrom(type)) {
            this.switchType = 1;
        } else if (DataSource.class.isAssignableFrom(type)) {
            this.switchType = 2;
        } else if (DataSourceType.class.isAssignableFrom(type)) {
            this.switchType = 3;
        } else if (DimensionSet.class.isAssignableFrom(type)) {
            this.switchType = 4;
        }
    }

    public Object fromXML(Element xml) throws SoapFault {
        try {
            String name = xml.getLocalName();
            if (ProviderRegistry.DATASET_QNAME.getLocalPart().equals(name)) {
                return this.datasetFromXML(xml);
            }
            if (ProviderRegistry.DATAFLOW_QNAME.getLocalPart().equals(name)) {
                return this.dataflowFromXML(xml);
            }
            if (ProviderRegistry.DATASOURCE_QNAME.getLocalPart().equals(name)) {
                return this.datasourceFromXML(xml);
            }
            if (ProviderRegistry.DATASOURCETYPE_QNAME.getLocalPart().equals(name)) {
                return this.datasourcetypeFromXML(xml);
            }
            if (ProviderRegistry.KEYSET_QNAME.getLocalPart().equals(name)) {
                return this.keysetFromXML(xml);
            }
            throw new SoapFault("Invalid object type");
        }
        catch (Throwable t) {
            throw new SoapFault("Unable to deserialize ", t);
        }
    }

    private DimensionSet keysetFromXML(Element xml) {
        Element[] keyElements = XmlUtils.getAllElements((Node)xml, (String)"http://cosmos.eclipse.org/capabilities/registry", (String)ProviderRegistry.KEY_QNAME.getLocalPart());
        String dimName = xml.getAttribute("name");
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        Element[] elementArray = keyElements;
        int n = keyElements.length;
        int n2 = 0;
        while (n2 < n) {
            Element keyElement = elementArray[n2];
            String name = keyElement.getAttribute("name");
            String type = keyElement.getAttribute("type");
            dims.add(new SimpleDimension(name, type));
            ++n2;
        }
        return new SimpleDimensionSet(dimName, dims);
    }

    private DataSourceType datasourcetypeFromXML(Element xml) {
        String name = xml.getAttribute("name");
        return new SimpleDataSourceType(name);
    }

    private DataSource datasourceFromXML(Element xml) {
        String name = xml.getAttribute("name");
        Element sourcetypeElement = XmlUtils.getElement((Node)xml, (QName)ProviderRegistry.DATASOURCETYPE_QNAME);
        DataSourceType sourceType = this.datasourcetypeFromXML(sourcetypeElement);
        return new SimpleDataSource(name, sourceType);
    }

    private DataFlow dataflowFromXML(Element xml) {
        String name = xml.getAttribute("name");
        Element sourceElement = XmlUtils.getElement((Node)xml, (QName)ProviderRegistry.DATASOURCE_QNAME);
        Element keysetElement = XmlUtils.getElement((Node)xml, (QName)ProviderRegistry.KEYSET_QNAME);
        DataSource source = this.datasourceFromXML(sourceElement);
        DimensionSet keyset = this.keysetFromXML(keysetElement);
        return new SimpleDataFlow(name, source, keyset);
    }

    private DataSet datasetFromXML(Element xml) throws Exception {
        String name = xml.getAttribute("name");
        String start = xml.getAttribute("start");
        String stop = xml.getAttribute("stop");
        Element flowElement = XmlUtils.getElement((Node)xml, (QName)ProviderRegistry.DATAFLOW_QNAME);
        Element sourceElement = XmlUtils.getElement((Node)xml, (QName)ProviderRegistry.DATASOURCE_QNAME);
        DataFlow flow = this.dataflowFromXML(flowElement);
        DataSource source = this.datasourceFromXML(sourceElement);
        return new SimpleDataSet(name, flow, source, XsdUtils.getLocalTime((String)start), XsdUtils.getLocalTime((String)stop));
    }

    public Class getSerializableType() {
        return this.type;
    }

    public Element toXML(Object obj, QName qname) throws SoapFault {
        Element child;
        block8: {
            block7: {
                child = null;
                if (!this.type.isInstance(obj)) break block7;
                switch (this.switchType) {
                    case 0: {
                        child = this.toXML((DataSet)obj);
                        break block8;
                    }
                    case 1: {
                        child = this.toXML((DataFlow)obj);
                        break block8;
                    }
                    case 2: {
                        child = this.toXML((DataSource)obj);
                        break block8;
                    }
                    case 3: {
                        child = this.toXML((DataSourceType)obj);
                        break block8;
                    }
                    case 4: {
                        child = this.toXML((DimensionSet)obj);
                        break block8;
                    }
                    default: {
                        throw new SoapFault("Invalid object type");
                    }
                }
            }
            throw new SoapFault("Invalid object type");
        }
        return child;
    }

    private Element toXML(DataSet dataset) {
        Element dsElement = XmlUtils.createElement((QName)ProviderRegistry.DATASET_QNAME);
        dsElement.setAttribute("name", dataset.getName());
        dsElement.setAttribute("start", XsdUtils.getLocalTimeString((Date)dataset.getStart()));
        dsElement.setAttribute("stop", XsdUtils.getLocalTimeString((Date)dataset.getStop()));
        Element flowElement = this.toXML(dataset.getDataFlow());
        Element sourceElement = this.toXML(dataset.getDataSource());
        dsElement.appendChild(sourceElement);
        dsElement.appendChild(flowElement);
        return dsElement;
    }

    private Element toXML(DataSource datasource) {
        Element dsElement = XmlUtils.createElement((QName)ProviderRegistry.DATASOURCE_QNAME);
        dsElement.setAttribute("name", datasource.getName());
        Element typeElement = this.toXML(datasource.getDataSourceType());
        dsElement.appendChild(typeElement);
        return dsElement;
    }

    private Element toXML(DataSourceType datatype) {
        Element typeElement = XmlUtils.createElement((QName)ProviderRegistry.DATASOURCETYPE_QNAME);
        typeElement.setAttribute("name", datatype.getName());
        return typeElement;
    }

    private Element toXML(DataFlow dataflow) {
        Element flowElement = XmlUtils.createElement((QName)ProviderRegistry.DATAFLOW_QNAME);
        flowElement.setAttribute("name", dataflow.getName());
        Element typeElement = this.toXML(dataflow.getDataSource());
        Element keysetElement = this.toXML(dataflow.getDimensionSet());
        flowElement.appendChild(typeElement);
        flowElement.appendChild(keysetElement);
        return flowElement;
    }

    private Element toXML(DimensionSet dimset) {
        Element dimsetElement = XmlUtils.createElement((QName)ProviderRegistry.KEYSET_QNAME);
        dimsetElement.setAttribute("name", dimset.getName());
        Collection<Dimension> dims = dimset.getDimensions();
        for (Dimension dim : dims) {
            dimsetElement.appendChild(this.toXML(dim));
        }
        return dimsetElement;
    }

    private Element toXML(Dimension dim) {
        Element dimElement = XmlUtils.createElement((QName)ProviderRegistry.KEY_QNAME);
        dimElement.setAttribute("name", dim.getName());
        dimElement.setAttribute("type", dim.getType());
        return dimElement;
    }
}

