/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.local.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.cosmos.dc.common.domain.Domain;
import org.eclipse.cosmos.dc.common.registry.DataFlow;
import org.eclipse.cosmos.dc.common.registry.DataSet;
import org.eclipse.cosmos.dc.common.registry.DataSource;
import org.eclipse.cosmos.dc.common.registry.DataSourceType;
import org.eclipse.cosmos.dc.common.registry.DimensionSet;
import org.eclipse.cosmos.dc.common.registry.ProviderRegistry;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedFrameworkAutowire;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedResource;
import org.eclipse.cosmos.dc.mgmt.common.ContributionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedResource(autowireName="ProviderRegistry")
public class InMemoryProviderRegistry
implements ProviderRegistry {
    @ManagedFrameworkAutowire(name="Domain")
    private Domain domain;
    public static final Collection<DataSet> EMPTY_LIST = new ArrayList<DataSet>();
    private HashMap<String, DataFlow> flowMap = new HashMap();
    private HashMap<String, DataSet> setMap = new HashMap();
    private HashMap<String, DataSource> sourceMap = new HashMap();
    private HashMap<String, DataSourceType> sourceTypeMap = new HashMap();
    private HashMap<String, DimensionSet> dimSetMap = new HashMap();
    private HashMap<DataFlow, Collection<DataSet>> setsByFlowMap = new HashMap();
    private HashMap<DataSource, Collection<DataSet>> setsBySourceMap = new HashMap();
    private ArrayList<DataSet> allSets = new ArrayList();

    public void setManager(ContributionManager manager) {
        manager.manage((Object)this);
    }

    public Collection<DataSet> getDataSetsForFlow(DataFlow flow) {
        Collection<DataSet> list = this.setsByFlowMap.get(flow);
        if (list == null) {
            return EMPTY_LIST;
        }
        return list;
    }

    public Collection<DataSet> getDataSetsForSource(DataSource source) {
        Collection<DataSet> list = this.setsBySourceMap.get(source);
        if (list == null) {
            return EMPTY_LIST;
        }
        return list;
    }

    public boolean registerDataFlow(DataFlow flow) throws Exception {
        DataFlow f = this.flowMap.get(flow.getName());
        if (f != null) {
            throw new Exception("DataFlow with name " + f.getName() + " already registered.");
        }
        this.flowMap.put(flow.getName(), flow);
        return true;
    }

    public synchronized boolean registerDataSet(DataSet ds) throws Exception {
        DataSet set = this.setMap.get(ds.getName());
        if (set != null) {
            throw new Exception("Dataset with name " + ds.getName() + " already registered.");
        }
        this.setMap.put(ds.getName(), ds);
        Collection<DataSet> sets = this.setsByFlowMap.get(ds.getDataFlow());
        if (sets == null) {
            sets = new ArrayList<DataSet>();
            this.setsByFlowMap.put(ds.getDataFlow(), sets);
        }
        sets.add(ds);
        sets = this.setsBySourceMap.get(ds.getDataSource());
        if (sets == null) {
            sets = new ArrayList<DataSet>();
            this.setsBySourceMap.put(ds.getDataSource(), sets);
        }
        sets.add(ds);
        this.allSets.add(ds);
        return true;
    }

    public synchronized boolean updateDataSet(DataSet ds) throws Exception {
        DataSet set = this.setMap.get(ds.getName());
        if (set == null) {
            throw new Exception("Dataset with name " + ds.getName() + " does not exist.");
        }
        this.setMap.put(ds.getName(), ds);
        this.setsByFlowMap.get(ds.getDataFlow());
        return true;
    }

    public boolean registerDataSource(DataSource src) throws Exception {
        DataSource s = this.sourceMap.get(src.getName());
        if (s != null) {
            throw new Exception("DataSource with name " + src.getName() + " already registered.");
        }
        this.sourceMap.put(src.getName(), src);
        return true;
    }

    public boolean registerDataSourceType(DataSourceType src) throws Exception {
        DataSourceType s = this.sourceTypeMap.get(src.getName());
        if (s != null) {
            throw new Exception("DataSourceType with name " + src.getName() + " already registered.");
        }
        this.sourceTypeMap.put(src.getName(), src);
        return true;
    }

    public boolean registerDimensionSet(DimensionSet dims) throws Exception {
        DimensionSet s = this.dimSetMap.get(dims.getName());
        if (s != null) {
            throw new Exception("DimensionSet with name " + dims.getName() + " already registered.");
        }
        this.dimSetMap.put(dims.getName(), dims);
        return true;
    }

    public DataFlow getDataFlow(String name) {
        return this.flowMap.get(name);
    }

    public DataSet getDataSet(String name) {
        return this.setMap.get(name);
    }

    public DataSource getDataSource(String name) {
        return this.sourceMap.get(name);
    }

    public DataSourceType getDataSourceType(String name) {
        return this.sourceTypeMap.get(name);
    }

    public DimensionSet getDimensionSet(String name) {
        return this.dimSetMap.get(name);
    }

    public Collection<DataSet> getAllDataSets() {
        return this.allSets;
    }

    public Collection<DataFlow> getAllDataFlows() {
        return this.flowMap.values();
    }

    public Collection<DataSource> getAllDataSources() {
        return this.sourceMap.values();
    }

    public Collection<DataSet> getDataSetsForFlow(String flowName) {
        DataFlow flow = this.flowMap.get(flowName);
        if (flow == null) {
            return EMPTY_LIST;
        }
        return this.getDataSetsForFlow(flow);
    }

    public Collection<DataSet> getDataSetsForSource(String sourceName) {
        DataSource source = this.sourceMap.get(sourceName);
        if (source == null) {
            return EMPTY_LIST;
        }
        return this.getDataSetsForSource(source);
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    public Collection<DataSet> getDataSetsForSourceKeyset(String source, String keyset) throws Exception {
        return null;
    }

    public DataSet getLatestDataSetForSourceKeyset(String source, String keyset) throws Exception {
        return null;
    }
}

