/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.local.registry;

import com.ibatis.common.resources.Resources;
import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapClientBuilder;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.cosmos.dc.common.domain.Domain;
import org.eclipse.cosmos.dc.common.registry.DataFlow;
import org.eclipse.cosmos.dc.common.registry.DataSet;
import org.eclipse.cosmos.dc.common.registry.DataSource;
import org.eclipse.cosmos.dc.common.registry.DataSourceType;
import org.eclipse.cosmos.dc.common.registry.Dimension;
import org.eclipse.cosmos.dc.common.registry.DimensionSet;
import org.eclipse.cosmos.dc.common.registry.ProviderRegistry;
import org.eclipse.cosmos.dc.common.registry.impl.SimpleDataFlow;
import org.eclipse.cosmos.dc.common.registry.impl.SimpleDataSet;
import org.eclipse.cosmos.dc.common.registry.impl.SimpleDataSource;
import org.eclipse.cosmos.dc.common.registry.impl.SimpleDataSourceType;
import org.eclipse.cosmos.dc.common.registry.impl.SimpleDimension;
import org.eclipse.cosmos.dc.common.registry.impl.SimpleDimensionSet;
import org.eclipse.cosmos.dc.local.registry.persistence.impl.DataFlowImpl;
import org.eclipse.cosmos.dc.local.registry.persistence.impl.DataSetImpl;
import org.eclipse.cosmos.dc.local.registry.persistence.impl.DataSourceImpl;
import org.eclipse.cosmos.dc.local.registry.persistence.impl.DataSourceTypeImpl;
import org.eclipse.cosmos.dc.local.registry.persistence.impl.DimensionImpl;
import org.eclipse.cosmos.dc.local.registry.persistence.impl.KeySetEntryImpl;
import org.eclipse.cosmos.dc.local.registry.persistence.impl.KeySetImpl;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedFrameworkAutowire;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedResource;
import org.eclipse.cosmos.dc.mgmt.common.ContributionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedResource(autowireName="ProviderRegistry")
public class SQLProviderRegistry
implements ProviderRegistry {
    @ManagedFrameworkAutowire(name="Domain")
    private Domain domain;
    public static final Collection<DataSet> EMPTY_LIST = new ArrayList<DataSet>();
    private SqlMapClient sqlMapper;

    public void setManager(ContributionManager manager) {
        manager.manage((Object)this);
        ClassLoader prevLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                Reader reader = Resources.getResourceAsReader((String)"org/eclipse/cosmos/dc/local/registry/persistence/sql/SqlMapConfig.xml");
                this.sqlMapper = SqlMapClientBuilder.buildSqlMapClient((Reader)reader);
                reader.close();
            }
            catch (Throwable t) {
                t.printStackTrace();
                Thread.currentThread().setContextClassLoader(prevLoader);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevLoader);
        }
    }

    public void setSqlMapper(SqlMapClient sqlMapper) {
        this.sqlMapper = sqlMapper;
    }

    public Collection<DataSet> getDataSetsForFlow(DataFlow flow) {
        DataFlowImpl flowImpl = null;
        ArrayList<DataSet> returnList = null;
        try {
            flowImpl = (DataFlowImpl)this.sqlMapper.queryForObject("getDataFlowForName", (Object)flow.getName());
            if (flowImpl != null) {
                List sets = this.sqlMapper.queryForList("getAllDataSetsForFlow", (Object)flowImpl.getId());
                returnList = new ArrayList<DataSet>();
                for (DataSetImpl impl : sets) {
                    returnList.add(this.getDataSet(impl.getName()));
                }
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return returnList;
    }

    public Collection<DataSet> getDataSetsForSource(DataSource source) {
        DataSourceImpl sourceImpl = null;
        ArrayList<DataSet> returnList = null;
        try {
            sourceImpl = (DataSourceImpl)this.sqlMapper.queryForObject("getDataSourceForName", (Object)source.getName());
            if (sourceImpl != null) {
                List sets = this.sqlMapper.queryForList("getAllDataSetsForSource", (Object)sourceImpl.getId());
                returnList = new ArrayList<DataSet>();
                for (DataSetImpl impl : sets) {
                    DataSet ds = this.getDataSet(impl.getName());
                    if (ds == null) continue;
                    returnList.add(ds);
                }
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return returnList;
    }

    public boolean registerDataFlow(DataFlow df) throws Exception {
        DataFlowImpl flow = null;
        DataSourceImpl source = null;
        KeySetImpl keys = null;
        try {
            flow = (DataFlowImpl)this.sqlMapper.queryForObject("getDataFlowForName", (Object)df.getName());
            if (flow == null) {
                source = (DataSourceImpl)this.sqlMapper.queryForObject("getDataSourceForName", (Object)df.getDataSource().getName());
                keys = (KeySetImpl)this.sqlMapper.queryForObject("getKeySetForName", (Object)df.getDimensionSet().getName());
                flow = new DataFlowImpl();
                flow.setName(df.getName());
                flow.setSource(source.getId());
                flow.setKeySet(keys.getId());
                this.sqlMapper.insert("registerDataFlow", (Object)flow);
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
            return false;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
        return true;
    }

    public synchronized boolean registerDataSet(DataSet ds) throws Exception {
        DataSetImpl set = null;
        DataFlowImpl flow = null;
        DataSourceImpl src = null;
        try {
            set = (DataSetImpl)this.sqlMapper.queryForObject("getDataSetForName", (Object)ds.getName());
            if (set == null) {
                src = (DataSourceImpl)this.sqlMapper.queryForObject("getDataSourceForName", (Object)ds.getDataSource().getName());
                flow = (DataFlowImpl)this.sqlMapper.queryForObject("getDataFlowForName", (Object)ds.getDataFlow().getName());
                set = new DataSetImpl();
                set.setName(ds.getName());
                set.setSource(src.getId());
                set.setFlow(flow.getId());
                set.setStart(ds.getStart());
                set.setStop(ds.getStart());
                this.sqlMapper.insert("registerDataSet", (Object)set);
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
            return false;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
        return true;
    }

    public synchronized boolean updateDataSet(DataSet ds) throws Exception {
        DataSetImpl set = null;
        try {
            set = (DataSetImpl)this.sqlMapper.queryForObject("getDataSetForName", (Object)ds.getName());
            if (set != null) {
                this.sqlMapper.update("updateDataSet", (Object)set);
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
            return false;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean registerDataSource(DataSource ds) throws Exception {
        DataSourceTypeImpl type = null;
        DataSourceImpl src = null;
        try {
            src = (DataSourceImpl)this.sqlMapper.queryForObject("getDataSourceForName", (Object)ds.getName());
            if (src == null) {
                type = (DataSourceTypeImpl)this.sqlMapper.queryForObject("getDataSourceTypeForName", (Object)ds.getDataSourceType().getName());
                src = new DataSourceImpl();
                src.setName(ds.getName());
                src.setType(type.getId());
                this.sqlMapper.insert("registerDataSource", (Object)src);
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
            return false;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean registerDataSourceType(DataSourceType src) throws Exception {
        DataSourceTypeImpl type = null;
        try {
            type = (DataSourceTypeImpl)this.sqlMapper.queryForObject("getDataSourceTypeForName", (Object)src.getName());
            if (type == null) {
                type = new DataSourceTypeImpl();
                type.setName(src.getName());
                this.sqlMapper.insert("registerDataSourceType", (Object)type);
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
            return false;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean registerDimensionSet(DimensionSet dimset) throws Exception {
        DimensionImpl impl = new DimensionImpl();
        KeySetImpl keyset = null;
        KeySetEntryImpl keysetEntry = new KeySetEntryImpl();
        try {
            keyset = (KeySetImpl)this.sqlMapper.queryForObject("getKeySetForName", (Object)dimset.getName());
            if (keyset == null) {
                keyset = new KeySetImpl();
                keyset.setName(dimset.getName());
                Object setid = this.sqlMapper.insert("registerKeySet", (Object)keyset);
                Collection dims = dimset.getDimensions();
                int i = 1;
                for (Dimension dim : dims) {
                    impl.setName(dim.getName());
                    impl.setType(dim.getType());
                    Object dimid = this.sqlMapper.insert("addDimension", (Object)impl);
                    keysetEntry.setDimension((Integer)dimid);
                    keysetEntry.setKeySet((Integer)setid);
                    keysetEntry.setSequence(i++);
                    this.sqlMapper.insert("addKeySetEntry", (Object)keysetEntry);
                }
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
            return false;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
        return true;
    }

    public DataFlow getDataFlow(String name) {
        DataFlowImpl flow = null;
        SimpleDataFlow retFlow = null;
        try {
            flow = (DataFlowImpl)this.sqlMapper.queryForObject("getDataFlowForName", (Object)name);
            if (flow != null) {
                KeySetImpl keyset = (KeySetImpl)this.sqlMapper.queryForObject("getKeySet", (Object)flow.getKeySet());
                DataSourceImpl source = (DataSourceImpl)this.sqlMapper.queryForObject("getDataSource", (Object)flow.getSource());
                retFlow = new SimpleDataFlow(flow.getName(), this.getDataSource(source.getName()), this.getDimensionSet(keyset.getName()));
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return retFlow;
    }

    public DataSet getDataSet(String name) {
        SimpleDataSet dataset = null;
        try {
            DataSetImpl impl = (DataSetImpl)this.sqlMapper.queryForObject("getDataSetForName", (Object)name);
            if (impl != null) {
                DataFlowImpl df = (DataFlowImpl)this.sqlMapper.queryForObject("getDataFlow", (Object)impl.getFlow());
                DataFlow flow = this.getDataFlow(df.getName());
                DataSourceImpl ds = (DataSourceImpl)this.sqlMapper.queryForObject("getDataSource", (Object)impl.getSource());
                DataSource source = this.getDataSource(ds.getName());
                dataset = new SimpleDataSet(name, flow, source, impl.getStart(), impl.getStop());
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return dataset;
    }

    public DataSource getDataSource(String name) {
        DataSourceTypeImpl type = null;
        DataSourceImpl source = null;
        SimpleDataSource retType = null;
        try {
            source = (DataSourceImpl)this.sqlMapper.queryForObject("getDataSourceForName", (Object)name);
            if (source != null) {
                type = (DataSourceTypeImpl)this.sqlMapper.queryForObject("getDataSourceType", (Object)source.getType());
                SimpleDataSourceType dst = new SimpleDataSourceType(type.getName());
                retType = new SimpleDataSource(name, (DataSourceType)dst);
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return retType;
    }

    public DataSourceType getDataSourceType(String name) {
        DataSourceTypeImpl type = null;
        SimpleDataSourceType retType = null;
        try {
            type = (DataSourceTypeImpl)this.sqlMapper.queryForObject("getDataSourceTypeForName", (Object)name);
            if (type != null) {
                retType = new SimpleDataSourceType(name);
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return retType;
    }

    public DimensionSet getDimensionSet(String name) {
        try {
            KeySetImpl keySet = (KeySetImpl)this.sqlMapper.queryForObject("getKeySetForName", (Object)name);
            if (keySet != null) {
                List entries = this.sqlMapper.queryForList("getKeysetEntries", (Object)keySet.getId());
                ArrayList<SimpleDimension> dims = new ArrayList<SimpleDimension>();
                for (KeySetEntryImpl entry : entries) {
                    DimensionImpl dim = (DimensionImpl)this.sqlMapper.queryForObject("getDimension", (Object)entry.getDimension());
                    SimpleDimension s = new SimpleDimension(dim.getName(), dim.getType());
                    dims.add(s);
                }
                SimpleDimensionSet set = new SimpleDimensionSet(keySet.getName(), dims);
                return set;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Collection<DataSet> getAllDataSets() {
        Collection<DataSet> list = EMPTY_LIST;
        try {
            List sets = this.sqlMapper.queryForList("getAllDataSets");
            if (!sets.isEmpty()) {
                list = new ArrayList<DataSet>();
                for (DataSetImpl set : sets) {
                    list.add(this.getDataSet(set.getName()));
                }
            }
        }
        catch (Throwable throwable) {}
        return list;
    }

    public Collection<DataFlow> getAllDataFlows() {
        ArrayList<DataFlow> list = null;
        try {
            List flows = this.sqlMapper.queryForList("getAllDataFlows");
            if (!flows.isEmpty()) {
                list = new ArrayList<DataFlow>();
                for (DataFlowImpl flow : flows) {
                    list.add(this.getDataFlow(flow.getName()));
                }
            }
        }
        catch (Throwable throwable) {}
        return list;
    }

    public Collection<DataSource> getAllDataSources() {
        ArrayList<DataSource> list = null;
        try {
            List sources = this.sqlMapper.queryForList("getAllDataSources");
            if (!sources.isEmpty()) {
                list = new ArrayList<DataSource>();
                for (DataSourceImpl source : sources) {
                    list.add(this.getDataSource(source.getName()));
                }
            }
        }
        catch (Throwable throwable) {}
        return list;
    }

    public Collection<DataSet> getDataSetsForFlow(String flowName) {
        DataFlow flow = this.getDataFlow(flowName);
        if (flow != null) {
            return this.getDataSetsForFlow(flow);
        }
        return null;
    }

    public Collection<DataSet> getDataSetsForSource(String sourceName) {
        DataSource source = this.getDataSource(sourceName);
        if (source != null) {
            return this.getDataSetsForSource(source);
        }
        return null;
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    private DataFlowImpl getDataFlowForSourceKeyset(String source, String keyset) {
        DataSourceImpl sourceImpl = null;
        KeySetImpl keySetImpl = null;
        try {
            sourceImpl = (DataSourceImpl)this.sqlMapper.queryForObject("getDataSourceForName", (Object)source);
            keySetImpl = (KeySetImpl)this.sqlMapper.queryForObject("getKeySetForName", (Object)keyset);
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            HashMap<String, Integer> parmMap = new HashMap<String, Integer>();
            parmMap.put("source", sourceImpl.getId());
            parmMap.put("keySet", keySetImpl.getId());
            return (DataFlowImpl)this.sqlMapper.queryForObject("getDataFlowForMap", parmMap);
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return null;
    }

    public Collection<DataSet> getDataSetsForSourceKeyset(String source, String keyset) throws Exception {
        DataFlowImpl flow = this.getDataFlowForSourceKeyset(source, keyset);
        return this.getDataSetsForFlow(flow.getName());
    }

    public DataSet getLatestDataSetForSourceKeyset(String source, String keyset) throws Exception {
        DataFlowImpl flow = this.getDataFlowForSourceKeyset(source, keyset);
        ArrayList<DataSet> returnList = null;
        try {
            List sets = this.sqlMapper.queryForList("getLatestDataSetsForFlow", (Object)flow.getId());
            returnList = new ArrayList<DataSet>();
            for (DataSetImpl impl : sets) {
                returnList.add(this.getDataSet(impl.getName()));
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (returnList != null && !returnList.isEmpty()) {
            return (DataSet)returnList.iterator().next();
        }
        return null;
    }
}

